/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.billing.convergys;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.billing.BaseSTBFormatter;
import com.n2bb.common.billing.ConversionException;

public class ConvergysSTBFormatter
extends BaseSTBFormatter {
    public static final String myclass = "ConvergysSTBFormatter";
    public static final String VENDOR_NAME = "Convergys";

    public ConvergysSTBFormatter() {
        super(VENDOR_NAME);
    }

    public String getSA(String id) throws ConversionException {
        String mymethod = "getSA";
        if (!this.validateInternalId(id)) {
            throw new ConversionException();
        }
        String formattedId = super.addColons(super.getSA(id));
        N2BB_LogClient.instance().debug(myclass, "getSA", "Converted equipment id: " + id + " to Convergys SA equipment id: " + formattedId);
        return formattedId;
    }

    public String parseEquipmentId(String id) throws ConversionException {
        String mymethod = "parseEquipmentId";
        String formattedId = null;
        switch (super.getEquipmentIdType(id)) {
            case SA_WITH_COLONS: {
                formattedId = super.parseSA(super.stripColons(id));
                break;
            }
            case MOTO_DAC: {
                formattedId = super.parseDAC(id);
                break;
            }
            case MOTO_NAS_NO_CHECKSUM: {
                formattedId = super.parseNAS(id);
                break;
            }
            default: {
                N2BB_LogClient.instance().error(myclass, "parseEquipmentId", "Invalid Equipment ID: " + id + " received from Convergys - " + "regex matched a non-Convergys equipment id type");
                throw new ConversionException();
            }
        }
        return formattedId;
    }
}

