/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.billing.csg;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.billing.BaseSTBFormatter;
import com.n2bb.common.billing.ConversionException;

public class CSGSTBFormatter
extends BaseSTBFormatter {
    public static final String myclass = "CSGSTBFormatter";
    public static final String VENDOR_NAME = "CSG";
    public static final String CSG_DAC_PAD = "0000";

    public CSGSTBFormatter() {
        super(VENDOR_NAME);
    }

    public String getSA(String id) throws ConversionException {
        String mymethod = "getSA";
        if (!this.validateInternalId(id)) {
            throw new ConversionException();
        }
        String formattedId = super.addColons(super.getSA(id));
        N2BB_LogClient.instance().debug(myclass, "getSA", "Converted equipment id: " + id + " to CSG SA equipment id: " + formattedId);
        return formattedId;
    }

    public String getDAC(String id) throws ConversionException {
        String mymethod = "getDAC";
        if (!this.validateInternalId(id)) {
            throw new ConversionException();
        }
        String formattedId = CSG_DAC_PAD + super.getDAC(id);
        N2BB_LogClient.instance().debug(myclass, "getDAC", "Converted equipment id: " + id + " to CSG Moto DAC equipment id: " + formattedId);
        return formattedId;
    }

    public String getNAS(String id) throws ConversionException {
        String mymethod = "getNAS";
        if (!this.validateInternalId(id)) {
            throw new ConversionException();
        }
        String formattedId = this.addDashes(super.getBaseMoto(id) + super.getMotoChecksum(id));
        N2BB_LogClient.instance().debug(myclass, "getNAS", "Converted equipment id: " + id + " to CSG Moto NAS equipment id: " + formattedId);
        return formattedId;
    }

    public String addDashes(String id) {
        StringBuilder formattedId = new StringBuilder(id);
        formattedId.insert(3, "-");
        formattedId.insert(9, "-");
        formattedId.insert(15, "-");
        return formattedId.toString();
    }

    public String parseEquipmentId(String id) throws ConversionException {
        String mymethod = "parseEquipmentId";
        String formattedId = null;
        switch (super.getEquipmentIdType(id)) {
            case SA_WITH_COLONS: {
                formattedId = super.parseSA(super.stripColons(id));
                break;
            }
            case MOTO_DAC_ZERO_PADDED: {
                formattedId = super.parseDAC(id.substring(4));
                break;
            }
            case MOTO_NAS_WITH_CHECKSUM: {
                formattedId = this.parseNAS(id);
                break;
            }
            default: {
                N2BB_LogClient.instance().error(myclass, "parseEquipmentId", "Invalid Equipment ID: " + id + " received from CSG - " + "regex matched a non-CSG equipment id type");
                throw new ConversionException();
            }
        }
        return formattedId;
    }

    public String parseNAS(String id) throws ConversionException {
        String mymethod = "parseNAS";
        String formattedId = super.parseNAS(id.substring(0, 15));
        if (super.checkChecksum(formattedId, id.substring(16))) {
            return formattedId;
        }
        N2BB_LogClient.instance().error(myclass, "parseNAS", "Invalid checksum reveived for NAS id: " + id);
        throw new ConversionException();
    }
}

