/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.db;

import com.n2bb.LogModule.N2BB_LogClient;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ConnectionManager {
    private final String myClass = "ConnectionManager";
    private DataSource m_connMgr;
    protected int maxConn;

    public ConnectionManager(String user, String pwd, String uri, String validationQuery, int maxConn, boolean shouldAutoCommit) {
        String myMethod = "ConnectionManager";
        byte whenExhastedAction = 1;
        long maxWait = -1L;
        int maxIdle = 8;
        boolean testOnBorrow = false;
        boolean testOnReturn = false;
        long timeBetweenEvictionRunsMillis = -1L;
        int numTestsPerEvictionRun = 3;
        long minEvictableIdleTimeMillis = 1800000L;
        boolean testWhileIdle = false;
        long evictorSleepMillis = -1L;
        System.setProperty("jdbc.drivers", "oracle.jdbc.driver.OracleDriver");
        N2BB_LogClient.instance().debug("ConnectionManager", myMethod, "Connection validation string: " + validationQuery);
        if (validationQuery != null && validationQuery.length() > 0) {
            testOnBorrow = true;
        }
        GenericObjectPool connPool = new GenericObjectPool(null, maxConn, whenExhastedAction, maxWait, maxIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(uri, user, pwd);
        PoolableConnectionFactory poolableConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)connPool, null, validationQuery, false, shouldAutoCommit);
        this.m_connMgr = new PoolingDataSource((ObjectPool)connPool);
    }

    public Connection getConnection() throws SQLException {
        return this.m_connMgr.getConnection();
    }
}

