/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.socket.SocketData;
import com.n2bb.common.socket.SynchronousReaderThread;
import com.n2bb.common.socket.SynchronousWriterThread;
import com.n2bb.common.socket.TCPConnectionManager;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class SynchronousConnectionManager
extends TCPConnectionManager {
    private static final String myclass = "SynchronousConnectionManager";
    protected Map<SelectableChannel, ChannelStat> channelInUseMap = new HashMap<SelectableChannel, ChannelStat>(1000);
    private Timer timer = new Timer();
    private long channelTimeout = 0L;

    public SynchronousConnectionManager() throws IOException {
        this.reader = new SynchronousReaderThread(this);
        this.writer = new SynchronousWriterThread(this);
    }

    public SynchronousConnectionManager(int timeoutSeconds) throws IOException {
        this();
        this.channelTimeout = timeoutSeconds <= 0 ? 0L : (long)timeoutSeconds * 1000L;
        if (this.channelTimeout > 0L) {
            TimerTask purgeTask = new TimerTask(){

                public void run() {
                    SynchronousConnectionManager.this.timer.purge();
                }
            };
            long maxinterval = this.channelTimeout * 100L < 300000L ? this.channelTimeout * 100L : 300000L;
            this.timer.schedule(purgeTask, this.channelTimeout * 100L, this.channelTimeout * 100L);
        }
    }

    public boolean isChannelInUse(SelectableChannel channel) {
        boolean retval = this.channelInUseMap.get((Object)channel).inUse;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelInUse(SocketChannel channel, boolean inUse) {
        List channelList;
        List list = channelList = this.connectionMap.get(this.connectionMap.get(channel));
        synchronized (list) {
            ChannelStat stat = this.channelInUseMap.get(channel);
            if (stat == null) {
                stat = new ChannelStat();
                stat.inUse = inUse;
                stat.teardown = null;
            } else if (inUse) {
                final SocketChannel teardownChannel = channel;
                stat.inUse = inUse;
                stat.teardown = null;
                if (this.channelTimeout > 0L) {
                    stat.teardown = new TimerTask(){

                        public void run() {
                            Socket skt = teardownChannel.socket();
                            SocketAddress saddr = skt.getRemoteSocketAddress();
                            N2BB_LogClient.instance().error(SynchronousConnectionManager.myclass, "setChannelInUse", "Removing connection to " + saddr + " due to receive timeout");
                            SynchronousConnectionManager.this.removeConnection(teardownChannel);
                        }
                    };
                }
            } else {
                if (stat.teardown != null) {
                    stat.teardown.cancel();
                }
                stat.inUse = inUse;
                stat.teardown = null;
            }
            this.channelInUseMap.put(channel, stat);
            if (!inUse) {
                channelList.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel useNextChannel(SocketAddress address) {
        List channelList;
        String mymethod = "useNextChannel";
        SocketChannel retval = null;
        while (retval == null && (channelList = this.connectionMap.get(address)) != null) {
            List list = channelList;
            synchronized (list) {
                ListIterator iter = channelList.listIterator();
                while (iter.hasNext()) {
                    SocketChannel currval = (SocketChannel)iter.next();
                    boolean channelInUse = this.channelInUseMap.get((Object)currval).inUse;
                    if (channelInUse) continue;
                    N2BB_LogClient.instance().debug(myclass, "useNextChannel", "Found channel to " + address);
                    retval = currval;
                    this.setChannelInUse(retval, true);
                    break;
                }
                if (retval == null) {
                    N2BB_LogClient.instance().debug(myclass, "useNextChannel", "All channels to " + address + " in use, waiting for available channel");
                    try {
                        channelList.wait();
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
        }
        return retval;
    }

    public SocketChannel addConnection(SocketAddress address) throws IOException {
        SocketChannel retval = super.addConnection(address);
        this.setChannelInUse(retval, false);
        return retval;
    }

    public void registerConnection(SocketAddress address, SocketChannel channel) {
        super.registerConnection(address, channel);
        this.setChannelInUse(channel, false);
    }

    public void removeConnection(SocketChannel channel) {
        super.removeConnection(channel);
        this.channelInUseMap.remove(channel);
    }

    public void write(SocketData data) {
        this.writer.put(data);
    }

    private class ChannelStat {
        public boolean inUse = false;
        public TimerTask teardown = null;

        private ChannelStat() {
        }
    }
}

