/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.socket.SynchronousConnectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public abstract class SynchronousConnectionPool {
    private static final String myClass = "SynchronousConnectionPool";
    protected GenericKeyedObjectPool connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new SynchronousConnectionFactory());
    private boolean keepConnection = true;

    public SynchronousConnectionPool(int maxTotal, boolean keepConnection) {
        this.connectionPool.setTestOnBorrow(true);
        this.connectionPool.setTestOnReturn(true);
        this.connectionPool.setMaxTotal(maxTotal);
        this.keepConnection = keepConnection;
    }

    public void addConnection(InetSocketAddress address) throws Exception {
        this.connectionPool.addObject((Object)address);
    }

    public byte[] writeWithWait(InetSocketAddress address, byte[] data) throws Exception {
        String myMethod = "writeWithWait";
        byte[] retval = null;
        N2BB_LogClient.instance().LogMethodEntry(myClass, "writeWithWait");
        Socket sock = (Socket)this.connectionPool.borrowObject((Object)address);
        try {
            OutputStream os = sock.getOutputStream();
            os.write(data);
            os.flush();
            InputStream is = sock.getInputStream();
            retval = this.readResponse(is);
        }
        catch (IOException e) {
            N2BB_LogClient.instance().error(myClass, "writeWithWait", "Encountered an error when writing to a socket. Will invalidate socket and try to connect again. Error was: " + e.getMessage());
            this.connectionPool.invalidateObject((Object)address, (Object)sock);
            this.addConnection(address);
            sock = (Socket)this.connectionPool.borrowObject((Object)address);
            OutputStream os = sock.getOutputStream();
            os.write(data);
            InputStream is = sock.getInputStream();
            retval = this.readResponse(is);
        }
        if (this.keepConnection) {
            this.connectionPool.returnObject((Object)address, (Object)sock);
        } else {
            this.connectionPool.invalidateObject((Object)address, (Object)sock);
        }
        N2BB_LogClient.instance().LogMethodExit(myClass, "writeWithWait");
        return retval;
    }

    protected abstract byte[] readResponse(InputStream var1) throws Exception;
}

