/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.common.socket.SocketData;
import com.n2bb.common.socket.SynchronousConnectionManager;
import com.n2bb.common.socket.TCPReaderThread;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class SynchronousReaderThread
extends TCPReaderThread {
    protected SynchronousConnectionManager synchronousConnectionManager = null;

    public SynchronousReaderThread(SynchronousConnectionManager connectionManager) throws IOException {
        super(connectionManager);
        this.synchronousConnectionManager = connectionManager;
    }

    protected void handleKey(SelectionKey currentKey) throws IOException {
        if (currentKey.isValid()) {
            if (currentKey.isAcceptable()) {
                ServerSocketChannel ssc = (ServerSocketChannel)currentKey.channel();
                SocketChannel sc = ssc.accept();
                if (sc != null) {
                    sc.finishConnect();
                    sc.configureBlocking(false);
                    this.register(sc);
                    this.myConnectionManager.registerConnection(sc.socket().getRemoteSocketAddress(), sc);
                }
            } else {
                SocketChannel sc = (SocketChannel)currentKey.channel();
                if (sc.isOpen() && sc.isConnected()) {
                    if (currentKey.isReadable()) {
                        SocketData data = this.read(sc);
                        if (data.data == null) {
                            data.channel.close();
                        } else {
                            this.synchronousConnectionManager.setChannelInUse((SocketChannel)data.channel, !this.synchronousConnectionManager.isChannelInUse(data.channel));
                        }
                        this.put(data);
                    }
                } else {
                    sc.close();
                }
            }
        }
    }
}

