/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.socket.SocketData;
import com.n2bb.common.socket.SynchronousConnectionManager;
import com.n2bb.common.socket.TCPWriterThread;
import java.nio.channels.SocketChannel;

public class SynchronousWriterThread
extends TCPWriterThread {
    private static final String myclass = "SynchronousWriterThread";
    private SynchronousConnectionManager connectionManager;

    public SynchronousWriterThread(SynchronousConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public SynchronousConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void write(SocketData data) {
        String mymethod = "write";
        if (data.channel != null) {
            super.write(data);
            boolean channelInUseFlag = this.connectionManager.isChannelInUse(data.channel);
            if (channelInUseFlag) {
                this.connectionManager.setChannelInUse((SocketChannel)data.channel, false);
            } else {
                N2BB_LogClient.instance().warning(myclass, "write", "Writing data directly to channel '" + data.address + "' not marked as in use");
            }
        } else {
            data.channel = this.connectionManager.useNextChannel(data.address);
            if (data.channel != null) {
                N2BB_LogClient.instance().debug(myclass, "write", "Putting message on wire to " + data.address);
                super.write(data);
            } else {
                N2BB_LogClient.instance().error(myclass, "write", "No connections to '" + data.address + "', dropping message");
            }
        }
    }
}

