/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.socket.ConnectionManager;
import com.n2bb.common.socket.ConnectionMap;
import com.n2bb.common.socket.SocketData;
import com.n2bb.common.socket.TCPReaderThread;
import com.n2bb.common.socket.TCPWriterThread;
import com.n2bb.common.util.Queue;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Set;

public class TCPConnectionManager
extends ConnectionManager {
    final String myclass = "TCPConnectionManager";
    protected boolean done = false;
    protected TCPWriterThread writer = null;
    protected TCPReaderThread reader = null;
    protected ConnectionRenewalThread renewalThread = null;
    protected ConnectionMap connectionMap = new ConnectionMap();

    public TCPConnectionManager() throws IOException {
        this.writer = new TCPWriterThread();
        this.reader = new TCPReaderThread(this);
    }

    public TCPConnectionManager(boolean renewRemovedConnections) throws IOException {
        this();
        if (renewRemovedConnections) {
            this.renewalThread = new ConnectionRenewalThread(this);
            this.renewalThread.start();
        }
    }

    public TCPConnectionManager(boolean renewRemovedConnections, int renewDelay) throws IOException {
        this(renewRemovedConnections);
        if (this.renewalThread != null) {
            this.renewalThread.setSleepTime(renewDelay);
        }
    }

    public void start() {
        this.writer.start();
        this.reader.start();
    }

    public void shutdown() {
        this.done = true;
        this.reader.shutdown();
        this.reader.interrupt();
        this.writer.shutdown();
        this.writer.interrupt();
    }

    public ServerSocketChannel addListener(SocketAddress address) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        ServerSocket sock = channel.socket();
        try {
            sock.setReuseAddress(true);
        }
        catch (SocketException se) {
            // empty catch block
        }
        sock.bind(address);
        channel.configureBlocking(false);
        this.reader.registerListener(channel);
        return channel;
    }

    public void scheduleRenewal(SocketAddress address) {
        if (this.renewalThread != null) {
            this.renewalThread.scheduleRenewal(address);
        }
    }

    public SocketChannel addConnection(SocketAddress address) throws IOException {
        SocketChannel channel = SocketChannel.open(address);
        channel.finishConnect();
        channel.configureBlocking(false);
        this.reader.register(channel);
        this.registerConnection(address, channel);
        return channel;
    }

    public synchronized void removeConnection(SocketChannel channel) {
        String mymethod = "removeConnection";
        try {
            SocketAddress address = this.connectionMap.get(channel);
            this.reader.deregister(channel);
            this.connectionMap.remove(channel);
            N2BB_LogClient.instance().debug("TCPConnectionManager", "removeConnection", "removed " + address + " from connectionMap");
            this.scheduleRenewal(address);
        }
        catch (IOException io) {
            N2BB_LogClient.instance().logStackTrace("TCPConnectionManager", "removeConnection", "IO Exception: ", (Throwable)io, 3);
        }
    }

    public synchronized void removeConnection(SocketAddress address) {
        String mymethod = "removeConnection";
        try {
            List connectionList = this.getConnection(address);
            if (connectionList != null) {
                for (int i = 0; i < connectionList.size(); ++i) {
                    SocketChannel channel = (SocketChannel)connectionList.get(i);
                    if (channel == null) continue;
                    this.reader.deregister(channel);
                }
            }
            this.connectionMap.remove(address);
            this.scheduleRenewal(address);
        }
        catch (IOException io) {
            N2BB_LogClient.instance().logStackTrace("TCPConnectionManager", "removeConnection", "IO Exception: ", (Throwable)io, 3);
        }
    }

    public synchronized SocketAddress getAddress(SocketChannel channel) {
        return this.connectionMap.get(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConnection(SocketAddress address) {
        ConnectionMap.ConnectionMapBucket bucket = null;
        TCPConnectionManager tCPConnectionManager = this;
        synchronized (tCPConnectionManager) {
            bucket = this.connectionMap.getBucket(address);
        }
        List retval = null;
        if (bucket != null) {
            retval = bucket.getChannels();
        }
        return retval;
    }

    public synchronized List getConnection(InetAddress address) {
        List retval = null;
        Set s = this.connectionMap.keySet();
        for (InetSocketAddress sockaddr : s) {
            if (!sockaddr.getAddress().equals(address)) continue;
            retval = this.getConnection(sockaddr);
            break;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel getOrCreateConnection(SocketAddress address) throws IOException {
        ConnectionMap.ConnectionMapBucket bucket = null;
        boolean createConnection = false;
        TCPConnectionManager tCPConnectionManager = this;
        synchronized (tCPConnectionManager) {
            bucket = this.connectionMap.getBucket(address);
            if (bucket == null) {
                bucket = this.connectionMap.createAndLock(address);
                createConnection = true;
            }
        }
        SocketChannel channel = null;
        if (createConnection) {
            try {
                channel = this.addConnection(address);
            }
            catch (IOException io) {
                this.connectionMap.unlockAndRemove(address);
            }
            finally {
                this.connectionMap.unlock(address);
            }
        } else {
            List connectionList = bucket.getChannels();
            if (connectionList != null && connectionList.size() > 0) {
                channel = (SocketChannel)connectionList.get(0);
            }
        }
        if (channel == null) {
            throw new IOException("Unable to connect to host");
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SocketData data) {
        String mymethod = "write";
        TCPConnectionManager tCPConnectionManager = this;
        synchronized (tCPConnectionManager) {
            if (data.channel == null) {
                List connectionList = this.getConnection(data.address);
                if (connectionList != null) {
                    data.channel = (SocketChannel)connectionList.get(0);
                } else {
                    N2BB_LogClient.instance().error("TCPConnectionManager", "write", "Unable to find channel for address " + data.address);
                }
            }
        }
        this.writer.put(data);
    }

    public SocketData read() {
        return this.reader.get();
    }

    public synchronized void registerConnection(SocketAddress address, SocketChannel channel) {
        String mymethod = "registerConnection";
        this.connectionMap.put(address, channel);
    }

    void performPostRenewalActions(SocketAddress address) {
    }

    protected class ConnectionRenewalThread
    extends Thread {
        final String myclass = "ConnectionRenewalThread";
        TCPConnectionManager m_connectionManager;
        Queue m_renewalQueue = new Queue();
        int m_sleepTime = 5000;

        public ConnectionRenewalThread(TCPConnectionManager mgr) {
            this.m_connectionManager = mgr;
        }

        public ConnectionRenewalThread(TCPConnectionManager mgr, int sleepTime) {
            this(mgr);
            this.setSleepTime(sleepTime);
        }

        public void setSleepTime(int sleepTime) {
            if (sleepTime > 0) {
                this.m_sleepTime = sleepTime;
            }
        }

        public void run() {
            while (true) {
                this.renew();
                try {
                    ConnectionRenewalThread.sleep(this.m_sleepTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private synchronized void renew() {
            String mymethod = "renew";
            if (this.m_renewalQueue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            int i = this.m_renewalQueue.size();
            while (i-- > 0) {
                SocketAddress address = (SocketAddress)this.m_renewalQueue.remove();
                try {
                    N2BB_LogClient.instance().info("ConnectionRenewalThread", "renew", "Lost connection to " + address + ". Reconnecting");
                    this.m_connectionManager.addConnection(address);
                    this.m_connectionManager.performPostRenewalActions(address);
                }
                catch (ConnectException e) {
                    this.m_renewalQueue.add(address);
                }
                catch (IOException e) {
                    this.m_renewalQueue.add(address);
                    N2BB_LogClient.instance().logStackTrace("ConnectionRenewalThread", "renew", "Caught IO Exception", (Throwable)e, 3);
                }
            }
        }

        public synchronized void scheduleRenewal(SocketAddress address) {
            this.m_renewalQueue.add(address);
            this.notify();
        }
    }
}

