/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.socket.ReaderThread;
import com.n2bb.common.socket.SocketData;
import com.n2bb.common.socket.TCPConnectionManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TCPReaderThread
extends ReaderThread {
    final String myclass = "TCPReaderThread";
    ByteBuffer tmpbuf = null;
    protected TCPConnectionManager myConnectionManager;

    public TCPReaderThread(TCPConnectionManager myConnectionManager) throws IOException {
        this.myConnectionManager = myConnectionManager;
        this.tmpbuf = ByteBuffer.allocateDirect(65536);
    }

    protected void handleKey(SelectionKey currentKey) throws IOException {
        if (currentKey.isValid()) {
            if (currentKey.isAcceptable()) {
                ServerSocketChannel ssc = (ServerSocketChannel)currentKey.channel();
                SocketChannel sc = ssc.accept();
                if (sc != null) {
                    sc.finishConnect();
                    sc.configureBlocking(false);
                    this.register(sc);
                    this.myConnectionManager.registerConnection(sc.socket().getRemoteSocketAddress(), sc);
                }
            } else {
                SocketChannel sc = (SocketChannel)currentKey.channel();
                if (sc.isOpen() && sc.isConnected()) {
                    if (currentKey.isReadable()) {
                        SocketData data = this.read(sc);
                        if (data.data == null) {
                            data.channel.close();
                        }
                        this.put(data);
                    }
                } else {
                    sc.close();
                }
            }
        }
    }

    protected SocketData read(SelectableChannel channel) {
        String mymethod = "read";
        SocketChannel myChannel = (SocketChannel)channel;
        SocketData data = new SocketData(myChannel.socket().getRemoteSocketAddress(), myChannel, null);
        try {
            int bytesRead = myChannel.read(this.tmpbuf);
            if (bytesRead > 0) {
                ByteBuffer readbuf;
                this.tmpbuf.flip();
                byte[] readByte = new byte[this.tmpbuf.limit()];
                this.tmpbuf.get(readByte);
                data.data = readbuf = ByteBuffer.wrap(readByte);
                this.tmpbuf.clear();
            }
        }
        catch (Exception exc) {
            N2BB_LogClient.instance().warning("TCPReaderThread", mymethod, "Caught Exception reading from " + this.myConnectionManager.getAddress(myChannel) + ":" + exc.getMessage());
        }
        return data;
    }

    protected ByteBuffer readBytes(SocketChannel channel, int bytes) throws IOException {
        ByteBuffer retval = ByteBuffer.allocate(bytes);
        int bytesRead = -1;
        for (int totalBytesRead = 0; totalBytesRead != bytes; totalBytesRead += bytesRead) {
            bytesRead = channel.read(retval);
            if (bytesRead >= 0) continue;
            retval = null;
            break;
        }
        return retval;
    }
}

