/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.util;

import com.n2bb.common.util.CircularArrayIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CircularArray
implements List {
    private Object[] m_array;
    private int m_head = 0;
    private int m_tail = 0;
    private int m_length = 0;
    private int m_lastelem = 0;
    private int m_maxsize;

    public CircularArray(int size) {
        this.m_maxsize = size;
        this.clear();
    }

    public boolean add(Object value) {
        if (this.m_length != 0) {
            this.m_tail = this.m_tail == this.m_lastelem ? 0 : ++this.m_tail;
            if (this.m_tail == this.m_head) {
                this.m_head = this.m_head == this.m_lastelem ? 0 : ++this.m_head;
            }
        }
        if (this.m_length < this.m_maxsize) {
            ++this.m_length;
        }
        this.m_array[this.m_tail] = value;
        return true;
    }

    public void clear() {
        this.m_head = 0;
        this.m_tail = 0;
        this.m_length = 0;
        this.m_lastelem = this.m_maxsize - 1;
        this.m_array = new Object[this.m_maxsize];
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        int element;
        Object retval = null;
        if (index < this.m_length && index >= 0) {
            element = this.m_head + index;
            if (element > this.m_lastelem) {
                element = index - (this.m_lastelem - this.m_tail);
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        retval = this.m_array[element];
        return retval;
    }

    public int getMaxSize() {
        return this.m_maxsize;
    }

    public boolean contains(Object o) {
        for (int i = 0; i < this.m_length; ++i) {
            if (!this.get(i).equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        return false;
    }

    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public int indexOf(Object o) {
        for (int i = 0; i < this.m_length; ++i) {
            if (!this.get(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.m_length == 0;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(Object o) {
        for (int i = this.m_length; i >= 0; --i) {
            if (!this.get(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return new CircularArrayIterator(this);
    }

    public ListIterator listIterator(int index) {
        return new CircularArrayIterator(this, index);
    }

    public int size() {
        return this.m_length;
    }

    public List subList(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    public Object[] toArray() {
        return this.m_array;
    }

    public Object[] toArray(Object[] a) {
        return this.m_array;
    }

    public void add(int index, Object element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

