/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.util;

public class HexUtils {
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            sb.append(" ");
            if ((i + 1) % 16 != 0) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = HexUtils.charToNibble(s.charAt(i));
            int low = HexUtils.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid?hex?character:?" + c);
    }
}

