/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.util;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.util.Queue;

public abstract class ProducerConsumerPattern {
    private String myclass = "ProducerConsumerPattern";
    private Queue queue;
    protected boolean done = false;
    protected boolean doConsumeAll = false;
    protected int overflow = 0;

    public ProducerConsumerPattern(int consumers) {
        this.queue = new Queue();
        for (int i = 0; i < consumers; ++i) {
            Consumer c = new Consumer(this);
            c.start();
        }
    }

    public ProducerConsumerPattern(int consumers, boolean doConsumeAll, int overflow) {
        this.doConsumeAll = doConsumeAll;
        this.overflow = overflow;
        this.queue = new Queue();
        for (int i = 0; i < consumers; ++i) {
            Consumer c = new Consumer(this);
            c.start();
        }
    }

    public abstract void process(Object var1);

    public final synchronized void shutdown() {
        this.done = true;
        this.notifyAll();
    }

    public final synchronized void produce(Object o) {
        String mymethod = "produce";
        if (this.overflow > 0 && this.queue.size() >= this.overflow) {
            N2BB_LogClient.instance().info(this.myclass, mymethod, "Throwing away data");
        }
        this.queue.add(o);
        this.notify();
    }

    protected final synchronized Object consume() {
        Object retval = null;
        while (retval == null && !this.done) {
            retval = this.queue.remove(0);
            if (retval != null) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return retval;
    }

    protected final synchronized Queue consumeAll() {
        Queue retQ = null;
        if (this.queue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.queue.size() > 0) {
            retQ = this.queue;
            this.queue = new Queue();
        }
        return retQ;
    }

    protected class Consumer
    extends Thread {
        ProducerConsumerPattern pcp = null;

        Consumer(ProducerConsumerPattern pcp) {
            this.pcp = pcp;
        }

        public void run() {
            while (!this.pcp.done) {
                Object o;
                Object object = o = ProducerConsumerPattern.this.doConsumeAll ? this.pcp.consumeAll() : this.pcp.consume();
                if (this.pcp.done) continue;
                this.pcp.process(o);
            }
        }
    }
}

