/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.corba.orb;

import com.n2bb.LogModule.N2BB_LogClient;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class OrbAccessory {
    public static final String myclass = "OrbAccessory";
    private ORB m_orb = null;
    private String m_orbID = "";
    private NamingContextExt m_nameCtxExt = null;
    protected static final String DEFAULTNAMESERVICE = "corbaloc::NameServer:5000/NameService";

    public OrbAccessory(String orbID, ORB orb) throws org.omg.CORBA.ORBPackage.InvalidName {
        N2BB_LogClient.instance().debug(myclass, myclass, "init");
        this.m_orb = orb;
        this.m_orbID = orbID;
        if (this.m_orb != null) {
            try {
                Object ns = this.m_orb.resolve_initial_references("NameService");
                N2BB_LogClient.instance().debug(myclass, myclass, "resolved initial reference.");
                this.m_nameCtxExt = NamingContextExtHelper.narrow((Object)ns);
                N2BB_LogClient.instance().debug(myclass, myclass, "narrowed naming context.");
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName in) {
                N2BB_LogClient.instance().debug(myclass, myclass, "couble not obtain naming context.  using default instead: corbaloc::NameServer:5000/NameService");
                try {
                    Object ns = this.m_orb.string_to_object(DEFAULTNAMESERVICE);
                    this.m_nameCtxExt = NamingContextExtHelper.narrow((Object)ns);
                    N2BB_LogClient.instance().debug(myclass, myclass, "narrowed naming context for default name service.");
                }
                catch (Exception exc) {
                    N2BB_LogClient.instance().error(myclass, myclass, "Error occurred: " + exc.getMessage());
                    throw in;
                }
            }
        }
    }

    public void destroy() {
        this.destroyORB();
    }

    protected void destroyORB() {
        N2BB_LogClient.instance().debug(myclass, "destroyORB", "trying to destroy orb...");
        if (this.m_orb != null) {
            this.m_orb.destroy();
            N2BB_LogClient.instance().debug(myclass, "destroyORB", "orb is destroyed.");
        }
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public NamingContextExt getRootNamingContextExt() {
        return this.m_nameCtxExt;
    }

    public synchronized void bindObject(NameComponent[] nc, Object object) throws CannotProceed, InvalidName {
        NameComponent[] currentName = new NameComponent[1];
        NamingContextExt currentContext = this.m_nameCtxExt;
        for (int i = 0; i < nc.length - 1; ++i) {
            currentName[0] = nc[i];
            try {
                Object nextContext = currentContext.resolve(currentName);
                currentContext = NamingContextHelper.narrow((Object)nextContext);
                continue;
            }
            catch (NotFound nf) {
                try {
                    currentContext = currentContext.bind_new_context(currentName);
                    continue;
                }
                catch (NotFound nf2) {
                    continue;
                }
                catch (AlreadyBound ab) {
                    // empty catch block
                }
            }
        }
        currentName[0] = nc[nc.length - 1];
        try {
            currentContext.rebind(currentName, object);
        }
        catch (NotFound nf) {
            // empty catch block
        }
    }

    public Object resolveObject(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        Object obj = this.m_nameCtxExt.resolve(nc);
        return obj;
    }

    public void deleteObjectBinding(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        this.m_nameCtxExt.unbind(nc);
    }

    public NamingContextExt getNamingContext() {
        Object namingObj = null;
        NamingContextExt ctx = null;
        N2BB_LogClient.instance().debug(myclass, "getNamingContext", "Trying to get the Naming context.");
        try {
            namingObj = this.m_orb.resolve_initial_references("NameService");
        }
        catch (Exception e) {
            N2BB_LogClient.instance().error(myclass, "getNamingContext", "Can not find the naming service.");
        }
        if (namingObj == null) {
            N2BB_LogClient.instance().error(myclass, "getNamingContext", "Naming Service Object is null.");
        }
        try {
            ctx = NamingContextExtHelper.narrow((Object)namingObj);
            if (ctx == null) {
                N2BB_LogClient.instance().error(myclass, "getNamingContext", "Naming Service Object is null.  This object does not implement a NamingContext");
            } else {
                N2BB_LogClient.instance().debug(myclass, "getNamingContext", "Naming Context Acquired...");
            }
        }
        catch (Exception e) {
            N2BB_LogClient.instance().error(myclass, "getNamingContext", "Attempt to narrow naming object failed..." + e.getMessage());
        }
        return ctx;
    }

    public NamingContextExt createNamingContext(String[] fullPath) {
        return this.createNamingContext(fullPath, fullPath.length - 1);
    }

    private NamingContextExt createNamingContext(String[] fullPath, int len) {
        NamingContextExt ctx = this.getNamingContext();
        Object namingCtx = null;
        try {
            NameComponent[] nameComponents = new NameComponent[len];
            for (int i = 0; i < len; ++i) {
                nameComponents[i] = new NameComponent(fullPath[i], "Context");
            }
            try {
                namingCtx = ctx.resolve(nameComponents);
            }
            catch (NotFound ex) {
                try {
                    ctx.bind_new_context(nameComponents);
                    namingCtx = ctx.resolve(nameComponents);
                }
                catch (AlreadyBound already) {
                    namingCtx = ctx.resolve(nameComponents);
                }
                catch (Exception exp) {}
            }
            catch (Exception ex) {
                // empty catch block
            }
            return NamingContextExtHelper.narrow((Object)namingCtx);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object getFactoryObject(String[] fullPath) throws Exception {
        NamingContextExt ctx = this.createNamingContext(fullPath);
        try {
            NameComponent[] nameComponents = OrbAccessory.getFactoryNameComponents(fullPath);
            return ctx.resolve(nameComponents);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static NameComponent[] getFactoryNameComponents(String[] fullPath) {
        return new NameComponent[]{new NameComponent(fullPath[fullPath.length - 1], "Factory")};
    }

    public void bindFactoryObject(String[] fullPath, Object obj) {
        NamingContextExt ctx = this.createNamingContext(fullPath);
        try {
            NameComponent[] nameComponents = OrbAccessory.getFactoryNameComponents(fullPath);
            ctx.rebind(nameComponents, obj);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void unbindFactoryObject(String[] fullPath) {
        NamingContextExt ctx = this.createNamingContext(fullPath);
        try {
            NameComponent[] nameComponents = OrbAccessory.getFactoryNameComponents(fullPath);
            ctx.unbind(nameComponents);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

