/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SessionEventBean
implements Serializable {
    private static Logger log = Logger.getLogger(SessionEventBean.class);
    public static int count = 0;
    public long sessionKey;
    public int eventCode = 0;
    public String startTime;
    public String endTime;

    public SessionEventBean(String eventCode, int severity, String task, String component) {
        this.eventCode = new Integer(eventCode);
        this.sessionKey = new Integer(++count).intValue();
    }

    public SessionEventBean(String raw) {
        int pos = raw.indexOf("}{");
        String header = raw.substring(1, pos);
        System.out.println("Header" + header);
        this.parseHeader(header);
        ++pos;
        pos = raw.indexOf(" ", pos) + 1;
        String body = raw.substring(pos);
        this.parseBody(body);
    }

    public SessionEventBean(String raw, long transId) {
        this(raw);
        this.sessionKey = transId;
        System.out.println("SessionEventBean Created");
    }

    public void parseHeader(String header) {
        int curPos = header.indexOf(" ");
        if (curPos == 0) {
            curPos = header.indexOf(" ", 2);
        }
        this.eventCode = this.parseEvent(header);
        log.debug((Object)("Event code " + this.eventCode + header));
        System.out.println("Event code = " + this.eventCode);
        ++curPos;
        while (curPos > 0) {
            curPos = this.parseNextToken(curPos, header);
        }
    }

    public void parseBody(String header) {
        int curPos = this.parseNextToken(0, header);
        while (curPos > 0) {
            curPos = this.parseNextToken(curPos, header);
        }
    }

    public int parseNextToken(int pos, String raw) {
        try {
            String temp = raw.substring(pos, raw.indexOf("}", pos) + 1);
            if (temp.indexOf("DD") >= 0) {
                String transId = this.getStringVal(temp);
                StringTokenizer tok = new StringTokenizer(transId);
                String tid = null;
                while (tok.hasMoreTokens()) {
                    tid = tok.nextToken(";");
                    int spot = tid.indexOf("=");
                    if (spot <= 0) continue;
                    if (tid.substring(0, spot).equals("End_Time")) {
                        this.endTime = tid.substring(spot + 1);
                    }
                    if (!tid.substring(0, spot).equals("Session_Start_Time")) continue;
                    this.startTime = tid.substring(spot + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return raw.indexOf(" ", pos) + 1;
    }

    public int getIntVal(String s) {
        int start = s.indexOf("{") + 1;
        int end = s.indexOf("}");
        if (start > 0 && end > 0) {
            return Integer.parseInt(s.substring(start, end));
        }
        return -1;
    }

    public String getStringVal(String s) {
        int start = s.indexOf("{") + 1;
        int end = s.indexOf("}");
        if (start > 0 && end > 0) {
            return s.substring(start, end);
        }
        return "";
    }

    private int parseEvent(String msg) {
        int spot = msg.indexOf("EVENT{") + 6;
        int end = msg.indexOf("}", spot);
        String event = msg.substring(spot, end);
        return Integer.parseInt(event);
    }

    public static void main(String[] args) {
    }
}

