/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import com.n2bb.AlertsModule.util.SettingsClient;
import com.n2bb.smp.SessionKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SessionKeyMap
extends Thread {
    private static final Logger log = Logger.getLogger(SessionKeyMap.class);
    private static final long MINIMUM_REAPERINTERVAL = 60000L;
    private static final long MINIMUM_EXPTIME = 60000L;
    private Map sessionKeyMap = null;
    private long reaperInterval = SettingsClient.smpReaperThreadInterval * 60000;
    private long expTime = SettingsClient.smpCacheExpireTimeout * 60000;
    static SessionKeyMap instance = null;

    SessionKeyMap() {
        this((SettingsClient)null);
    }

    public SessionKeyMap(SettingsClient sc) {
        this.sessionKeyMap = Collections.synchronizedMap(new HashMap());
        this.start();
    }

    public static SessionKeyMap getInstance(SettingsClient sc) {
        if (instance == null) {
            instance = new SessionKeyMap(sc);
        }
        return instance;
    }

    static SessionKeyMap getInstance() {
        if (instance == null) {
            instance = new SessionKeyMap();
        }
        return instance;
    }

    public SessionKey getSessionKeyData(String tId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering getSessionKeyData()");
            log.debug((Object)("tId: " + tId));
        }
        SessionKey tempSessionKey = (SessionKey)this.sessionKeyMap.get(tId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("tempSessionKey: " + tempSessionKey));
            log.debug((Object)"Leaving getSessionKeyData()");
        }
        return tempSessionKey;
    }

    public void putSessionKeyData(String sessionId, SessionKey fdata) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering putSessionKeyData()");
            log.debug((Object)("sessionId: " + sessionId));
            log.debug((Object)("fdata: " + fdata));
        }
        this.sessionKeyMap.put(sessionId, fdata);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving putSessionKeyData()");
        }
    }

    public boolean containsKey(String tId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering containsKey()");
            log.debug((Object)("tId: " + tId));
        }
        boolean containsKey = this.sessionKeyMap.containsKey(tId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("containsKey: " + containsKey));
            log.debug((Object)"Leaving containsKey()");
        }
        return containsKey;
    }

    public void removeSessionKeyData(String sessionId) {
        Object value;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering removeSessionKeyData()");
            log.debug((Object)("sessionId: " + sessionId));
        }
        if ((value = this.sessionKeyMap.remove(sessionId)) == null && log.isDebugEnabled()) {
            log.debug((Object)("Didn't find session = " + sessionId + " in Dsmcc Session map"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving removeSessionKeyData()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateDebug() {
        Map map = this.sessionKeyMap;
        synchronized (map) {
            for (String string : this.sessionKeyMap.keySet()) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering run()");
        }
        if (this.reaperInterval < 60000L) {
            this.reaperInterval = 60000L;
        }
        if (this.expTime < 60000L) {
            this.expTime = 60000L;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reaper interval: " + this.reaperInterval));
            log.debug((Object)("Cache expiry time: " + this.expTime));
        }
        while (true) {
            try {
                while (true) {
                    SessionKeyMap.sleep(this.reaperInterval);
                    Map map = this.sessionKeyMap;
                    synchronized (map) {
                        for (String dsmccSessionId : this.sessionKeyMap.keySet()) {
                            SessionKey sk = (SessionKey)this.sessionKeyMap.get(dsmccSessionId);
                            long timeInCache = System.currentTimeMillis() - sk.getCreateTime().getTime();
                            if (sk == null || timeInCache < this.expTime) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Reaper is removing session key with sequence #" + sk.getUniqueKey()));
                            }
                            this.sessionKeyMap.remove(dsmccSessionId);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void systemOut(String message) {
        System.out.println(message);
    }
}

