/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import com.n2bb.AlertsModule.consumers.UDPConsumerBase;
import com.n2bb.AlertsModule.util.SettingsClient;
import com.n2bb.smp.EventCounterBean;
import com.n2bb.smp.SessionErrorBean;
import com.n2bb.smp.SessionEventBean;
import com.n2bb.smp.SessionHistoryBean;
import com.n2bb.smp.SessionKey;
import com.n2bb.smp.SessionKeyMap;
import com.n2bb.smp.smpDBWriter;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SmpUDPConsumer
extends UDPConsumerBase {
    private static final Logger log = Logger.getLogger(SmpUDPConsumer.class);
    private static final String MY_CLASS = "SmpUDPConsumer";
    SettingsClient sc = null;
    smpDBWriter dbWriter = null;

    SmpUDPConsumer(int port, Integer bufferSize, int threads) throws Exception {
        super(port, bufferSize.intValue(), threads);
        this.dbWriter = SmpUDPConsumer.getDBWriter();
        this.dbWriter.init(this.sc);
    }

    public SmpUDPConsumer(SettingsClient m_SClient, Integer rcvBufferSize) throws Exception {
        super(SettingsClient.smpListenPort, rcvBufferSize.intValue(), SettingsClient.smpConsumerThreads);
        this.sc = m_SClient;
        this.dbWriter = SmpUDPConsumer.getDBWriter();
        this.dbWriter.init(this.sc);
    }

    static smpDBWriter getDBWriter() {
        try {
            return smpDBWriter.instance();
        }
        catch (Exception e) {
            log.error((Object)"Exception while getting smpDBWriter instance.");
            return null;
        }
    }

    protected void processMessage(Object[] obj) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering processMessage()");
            log.debug((Object)("Message: " + (String)obj[1]));
            if (this.messageQueue.getSize() % 100 == 0) {
                log.debug((Object)("smp logger message queue size... " + this.messageQueue.getSize()));
            }
        }
        String msg = (String)obj[1];
        SessionKey sessionKey = null;
        String sessionId = this.parseDsmccSessionId(msg);
        if (sessionId != null) {
            sessionKey = this.getSessionKey(sessionId);
        }
        int type = this.parseType(msg);
        try {
            switch (type) {
                case 0: {
                    System.out.println("Writing Session history");
                    this.dbWriter.writeSessionHistory(new SessionHistoryBean(msg, sessionKey.getUniqueKey()));
                    break;
                }
                case 1: {
                    System.out.println("Writing Session Event");
                    this.dbWriter.writeSessionEvent(new SessionEventBean(msg, sessionKey.getUniqueKey()));
                    break;
                }
                case 2: {
                    System.out.println("Writing Session Error");
                    this.dbWriter.writeSessionError(new SessionErrorBean(msg, sessionKey.getUniqueKey()));
                    break;
                }
                case 100: {
                    this.dbWriter.writeEventCounter(new EventCounterBean(msg));
                    break;
                }
                default: {
                    System.out.println("Unknown type: " + type);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error writing object ", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving processMessage()");
        }
    }

    public static void main(String[] args) {
        Object[] obj = new Object[2];
        try {
            SmpUDPConsumer c = new SmpUDPConsumer(null, 1);
            System.out.println("TYPE=100");
            String message = "TYPE=100 EVENT=101 COUNT=1 TIMEKEY=2005012";
            obj[0] = new Long(message.length());
            obj[1] = message;
            c.processMessage(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int parseType(String msg) {
        int spot = msg.indexOf("TYPE=");
        if (spot != -1) {
            int end = msg.indexOf(" ", spot);
            String typ = msg.substring(spot + 5, end);
            return Integer.parseInt(typ);
        }
        System.out.println("BCN " + msg);
        spot = msg.indexOf(" ");
        int end = msg.indexOf(" ", spot + 1);
        String typ = msg.substring(spot + 1, end);
        System.out.println("typ = " + typ + " " + spot + " " + end);
        return Integer.parseInt(typ);
    }

    private String parseDsmccSessionId(String s) {
        int spot = s.indexOf("Session_ID=");
        int end = s.indexOf(125, spot);
        if (spot > -1 && end > -1) {
            String id = s.substring(spot + 11, end);
            if (-1 != (end = id.indexOf(59))) {
                id = id.substring(0, end);
            }
            return id;
        }
        return null;
    }

    private SessionKey getSessionKey(String sessionId) {
        SessionKey sessionKey = null;
        if (SessionKeyMap.getInstance(this.sc).containsKey(sessionId)) {
            sessionKey = SessionKeyMap.getInstance(this.sc).getSessionKeyData(sessionId);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SessionKey not found for dsmccsessionid " + sessionId + " iterating map"));
                SessionKeyMap.getInstance(this.sc).iterateDebug();
            }
            SessionKeyMap.getInstance(this.sc).iterateDebug();
            try {
                sessionKey = new SessionKey(this.dbWriter.getSessionSequence(), new Timestamp(System.currentTimeMillis()));
                SessionKeyMap.getInstance(this.sc).putSessionKeyData(sessionId, sessionKey);
            }
            catch (Exception e) {
                log.error((Object)"Error obtaining session sequence", (Throwable)e);
                System.out.println("Error getting Session Sequence.");
            }
        }
        return sessionKey;
    }
}

