/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import com.n2bb.common.socket.SocketData;
import com.n2bb.common.socket.UDPConnectionManager;
import com.n2bb.smp.SmpEvent;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class UDPListener
extends Thread {
    private DatagramSocket dataSocket;
    private int packetLength = 2048;
    private Logger logger = Logger.getLogger(UDPListener.class);
    String ip;
    Connection c;
    private UDPConnectionManager udpConnectionMgr;
    private DatagramChannel channel;

    public UDPListener(String ipAddress, int aPort, int rcvBufferSize) throws Exception {
        this.logger.info((Object)("UDPListener starting - requested socket receive buffer size... " + rcvBufferSize));
        UDPListener.registerDriver();
        this.c = UDPListener.getConnection(UDPListener.buildURL("10.252.3.230", "1521", "BMS"), "bms", "bms");
        this.ip = ipAddress;
        try {
            this.udpConnectionMgr = new UDPConnectionManager();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
        try {
            this.channel = this.udpConnectionMgr.addListener((SocketAddress)new InetSocketAddress(aPort));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            this.udpConnectionMgr.start();
            this.channel.socket().setReceiveBufferSize(rcvBufferSize);
        }
        catch (SocketException ex1) {
            ex1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logger.info((Object)"UDPListener thread running");
        try {
            SocketData sd = null;
            while (true) {
                sd = this.udpConnectionMgr.read();
                byte[] b = sd.data.array();
                String smpObj = new String(b, 0, b.length);
                SmpEvent msa = new SmpEvent(smpObj);
            }
        }
        catch (Exception e) {
            this.logger.fatal((Object)("UDPListener thread dying - " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
        }
    }

    public static Connection getConnection(String url, String user, String pass) {
        try {
            return DriverManager.getConnection(url, user, pass);
        }
        catch (SQLException sqe) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String buildURL(String host, String port, String sid) {
        return "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
    }

    public static void registerDriver() {
        try {
            DriverManager.registerDriver((Driver)Class.forName("oracle.jdbc.driver.OracleDriver").newInstance());
        }
        catch (Exception cnfe) {
            cnfe.printStackTrace();
        }
    }
}

