/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import com.n2bb.AlertsModule.util.SettingsClient;
import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.smp.Constants.Events;
import com.n2bb.smp.EventCounterBean;
import com.n2bb.smp.SessionErrorBean;
import com.n2bb.smp.SessionEventBean;
import com.n2bb.smp.SessionHistoryBean;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class smpDBWriter {
    private static final String strPSSessionSequence = "SELECT SMB_SESSION_SEQUENCE.NEXTVAL FROM DUAL";
    private static final String strPSEvent = "INSERT INTO EVENTS(SESSIONKEY,EVENT_CODE,STARTTIME,ENDTIME) VALUES (?,?,?,?)";
    private static final String strPSError = "INSERT INTO ERRORS(SESSIONKEY,EVENT_CODE,RMKS,EVTIME) VALUES (?,?,?,?)";
    private static final String strPSSession = "DECLARE \n\tvrec SESSIONHISTORY%ROWTYPE; \n\tm_SESSIONKEY\t\t\t\tSESSIONHISTORY.SESSIONKEY%TYPE;\n\tm_DSMCCSESSIONID\t\t\tSESSIONHISTORY.DSMCCSESSIONID%TYPE;\n\tm_TERMINALID\t\t\t\tSESSIONHISTORY.TERMINALID%TYPE;\n\tm_SERVICEID\t\t\t\t\tSESSIONHISTORY.SERVICEID%TYPE;\n\tm_SVCGWID\t\t\t\t\tSESSIONHISTORY.SVCGWID%TYPE;\n\tm_SERVICEGROUP\t\t\t\tSESSIONHISTORY.SERVICEGROUP%TYPE;\n\tm_OFFERING\t\t\t\t\tSESSIONHISTORY.OFFERING%TYPE;\n\tm_SESSIONINSTANTIATIONTIME\tSESSIONHISTORY.SESSIONINSTANTIATIONTIME%TYPE;\n\tm_SESSIONDESTRUCTIONTIME\tSESSIONHISTORY.SESSIONDESTRUCTIONTIME%TYPE;\n\tm_ASSETID\t\t\t\t\tSESSIONHISTORY.ASSETID%TYPE;\n\tm_STREAMID\t\t\t\t\tSESSIONHISTORY.STREAMID%TYPE;\n\tm_STREAMSERVICEID\t\t\tSESSIONHISTORY.STREAMSERVICEID%TYPE;\n\tm_CONDITIONALACCESSKEY\t\tSESSIONHISTORY.CONDITIONALACCESSKEY%TYPE;\n\tm_ISACONTENTID\t\t\t\tSESSIONHISTORY.ISACONTENTID%TYPE;\n\tm_CUSTOMERID\t\t\t\tSESSIONHISTORY.CUSTOMERID%TYPE;\n\tm_ETHERNETDESCRIPTOR\t\tSESSIONHISTORY.ETHERNETDESCRIPTOR%TYPE;\n\tm_VIDEOSERVERID\t\t\t\tSESSIONHISTORY.VIDEOSERVERID%TYPE;\n\tm_LSCHANDLE\t\t\t\t\tSESSIONHISTORY.LSCHANDLE%TYPE;\n\tm_LSCSERVERIP\t\t\t\tSESSIONHISTORY.LSCSERVERIP%TYPE;\n\tm_LSCSERVERPORT\t\t\t\tSESSIONHISTORY.LSCSERVERPORT%TYPE;\n\tm_LSCSERVERMODE\t\t\t\tSESSIONHISTORY.LSCSERVERMODE%TYPE;\n\tm_MPEGPROGRAMID\t\t\t\tSESSIONHISTORY.MPEGPROGRAMID%TYPE;\n\tm_PRICE\t\t\t\t\t\tSESSIONHISTORY.PRICE%TYPE;\n\tm_QAMIDCHANNEL\t\t\t\tSESSIONHISTORY.QAMIDCHANNEL%TYPE;\n\tm_QAMFREQUENCY\t\t\t\tSESSIONHISTORY.QAMFREQUENCY%TYPE;\n\tm_QAMMODULATION\t\t\t\tSESSIONHISTORY.QAMMODULATION%TYPE;\n\tm_REASONCODE\t\t\t\tSESSIONHISTORY.REASONCODE%TYPE;\n\tm_RESPONSECODE\t\t\t\tSESSIONHISTORY.RESPONSECODE%TYPE;\n\tm_RETRIES\t\t\t\t\tSESSIONHISTORY.RETRIES%TYPE;\n\tm_TSDOWNSTREAMBW\t\t\tSESSIONHISTORY.TSDOWNSTREAMBW%TYPE;\n\tm_VASPID\t\t\t\t\tSESSIONHISTORY.VASPID%TYPE;\n\tm_DURATION\t\t\t\t\tSESSIONHISTORY.DURATION%TYPE;\n\tm_SITEKEY\t\t\t\t\tSESSIONHISTORY.SITEKEY%TYPE;\n\tm_TRANSACTIONKEY\t\t\tSESSIONHISTORY.TRANSACTIONKEY%TYPE;\n\tm_MULTIPLEASSET\t\t\t\tSESSIONHISTORY.MULTIPLEASSET%TYPE;\n\tm_STATUS\t\t\t\t\tSESSIONHISTORY.STATUS%TYPE;\n\tm_HUB\t\t\t\t\t\tSESSIONHISTORY.HUB%TYPE;\n\tm_ENCRYPTED\t\t\t\t\tSESSIONHISTORY.ENCRYPTED%TYPE;\n\tm_PURCHASEKEY\t\t\t\tSESSIONHISTORY.PURCHASEKEY%TYPE;\n\tm_PURCHASETIME\t\t\t\tSESSIONHISTORY.PURCHASETIME%TYPE;\n\tm_ISINQUIRY\t\t\t\t\tSESSIONHISTORY.ISINQUIRY%TYPE;\n\tm_PURCHASERESULT\t\t\tSESSIONHISTORY.PURCHASERESULT%TYPE;\n\tm_BILLINGCODE\t\t\t\tSESSIONHISTORY.BILLINGCODE%TYPE;\n\tm_HIGHDEF\t\t\t\t\tSESSIONHISTORY.HIGHDEF%TYPE;\n\tm_SITENAME\t\t\t\t\tSESSIONHISTORY.SITENAME%TYPE;\n\tm_EVENTKEY\t\t\t\t\tSESSIONHISTORY.EVENTKEY%TYPE;\n\tm_INSERTTIME\t\t\t\tSESSIONHISTORY.INSERTTIME%TYPE;\n\tm_TSIDOUT\t\t\t\t\tSESSIONHISTORY.TSIDOUT%TYPE;\n\tm_TERMINALSUBNET\t\t\tSESSIONHISTORY.TERMINALSUBNET%TYPE;\n\tm_HUBID\t\t\t\t\t\tSESSIONHISTORY.HUBID%TYPE;\n\tm_ASSETPROVAPPNAME\t\t\tSESSIONHISTORY.ASSETPROVAPPNAME%TYPE;\n\tm_FORWARDASSNMP\t\t\t\tSESSIONHISTORY.FORWARDASSNMP%TYPE;\n\tm_IPADDRESS\t\t\t\t\tSESSIONHISTORY.IPADDRESS%TYPE;\n\tm_VENDORID\t\t\t\t\tSESSIONHISTORY.VENDORID%TYPE;\n\tm_FORACTIVITY\t\t\t\tSESSIONHISTORY.FORACTIVITY%TYPE;\n\tm_DATA_VALUE\t\t\t\tSESSIONHISTORY.DATA_VALUE%TYPE;\n\tm_PVT_DATA\t\t\t\t\tSESSIONHISTORY.PVT_DATA%TYPE;\n\tm_VERRCODE\t\t\t\t\tSESSIONHISTORY.VERRCODE%TYPE;\n   CURSOR CU is \n\t\tSELECT * FROM SESSIONHISTORY \n\t\tWHERE SESSIONKEY = m_SESSIONKEY\n\t\tFOR UPDATE;\nBEGIN\n\tm_SESSIONKEY := ?;\n\tm_DSMCCSESSIONID := ?;\n\tm_TERMINALID := ?;\n\tm_SERVICEID := ?;\n\tm_SVCGWID := ?;\n\tm_SERVICEGROUP := ?;\n\tm_OFFERING := ?;\n\tm_SESSIONINSTANTIATIONTIME := ?;\n\tm_SESSIONDESTRUCTIONTIME := ?;\n\tm_ASSETID := ?;\n\tm_STREAMID := ?;\n\tm_STREAMSERVICEID := ?;\n\tm_CONDITIONALACCESSKEY := ?;\n\tm_ISACONTENTID := ?;\n\tm_CUSTOMERID := ?;\n\tm_ETHERNETDESCRIPTOR := ?;\n\tm_VIDEOSERVERID := ?;\n\tm_LSCHANDLE := ?;\n\tm_LSCSERVERIP := ?;\n\tm_LSCSERVERPORT := ?;\n\tm_LSCSERVERMODE := ?;\n\tm_MPEGPROGRAMID := ?;\n\tm_PRICE := ?;\n\tm_QAMIDCHANNEL := ?;\n\tm_QAMFREQUENCY := ?;\n\tm_QAMMODULATION := ?;\n\tm_REASONCODE := ?;\n\tm_RESPONSECODE := ?;\n\tm_RETRIES := ?;\n\tm_TSDOWNSTREAMBW := ?;\n\tm_VASPID := ?;\n\tm_DURATION := ?;\n\tm_SITEKEY := ?;\n\tm_TRANSACTIONKEY := ?;\n\tm_MULTIPLEASSET := ?;\n\tm_STATUS := ?;\n\tm_HUB := ?;\n\tm_ENCRYPTED := ?;\n\tm_PURCHASEKEY := ?;\n\tm_PURCHASETIME := ?;\n\tm_ISINQUIRY := ?;\n\tm_PURCHASERESULT := ?;\n\tm_BILLINGCODE := ?;\n\tm_HIGHDEF := ?;\n\tm_SITENAME := ?;\n\tm_EVENTKEY := ?;\n\tm_INSERTTIME := ?;\n\tm_TSIDOUT := ?;\n\tm_TERMINALSUBNET := ?;\n\tm_HUBID := ?;\n\tm_ASSETPROVAPPNAME := ?;\n\tm_FORWARDASSNMP := ?;\n\tm_IPADDRESS := ?;\n\tm_VENDORID := ?;\n\tm_FORACTIVITY := ?;\n\tm_DATA_VALUE := ?;\n\tm_PVT_DATA := ?;\n\tm_VERRCODE := ?;\n                   \n\tOPEN CU;\n   LOOP\n\tFETCH CU INTO vrec;\n\tIF CU%NOTFOUND\n\tTHEN\n\t\tINSERT INTO SESSIONHISTORY (SESSIONKEY, DSMCCSESSIONID, TERMINALID, SERVICEID, SVCGWID,\n\t\t\tSERVICEGROUP, OFFERING, SESSIONINSTANTIATIONTIME, SESSIONDESTRUCTIONTIME, ASSETID, \n\t\t\tSTREAMID, STREAMSERVICEID, CONDITIONALACCESSKEY, ISACONTENTID, CUSTOMERID, ETHERNETDESCRIPTOR,\n\t\t\tVIDEOSERVERID, LSCHANDLE, LSCSERVERIP, LSCSERVERPORT, LSCSERVERMODE, MPEGPROGRAMID, PRICE,\n\t\t\tQAMIDCHANNEL, QAMFREQUENCY, QAMMODULATION, REASONCODE, RESPONSECODE, RETRIES, TSDOWNSTREAMBW,\n\t\t\tVASPID, DURATION, SITEKEY, TRANSACTIONKEY, MULTIPLEASSET, STATUS, HUB, ENCRYPTED, PURCHASEKEY,\n\t\t\tPURCHASETIME, ISINQUIRY, PURCHASERESULT, BILLINGCODE, HIGHDEF, SITENAME, EVENTKEY, INSERTTIME,\n\t\t\tTSIDOUT, TERMINALSUBNET, HUBID, ASSETPROVAPPNAME, FORWARDASSNMP, IPADDRESS, VENDORID, \n\t\t\tFORACTIVITY, DATA_VALUE, PVT_DATA, VERRCODE)\n\t\tVALUES (m_SESSIONKEY, m_DSMCCSESSIONID, m_TERMINALID, m_SERVICEID, m_SVCGWID, m_SERVICEGROUP,\n\t\t\tm_OFFERING, m_SESSIONINSTANTIATIONTIME, m_SESSIONDESTRUCTIONTIME, m_ASSETID, m_STREAMID, \n\t\t\tm_STREAMSERVICEID, m_CONDITIONALACCESSKEY, m_ISACONTENTID, m_CUSTOMERID, m_ETHERNETDESCRIPTOR,\n\t\t\tm_VIDEOSERVERID, m_LSCHANDLE, m_LSCSERVERIP, m_LSCSERVERPORT, m_LSCSERVERMODE, m_MPEGPROGRAMID,\n\t\t\tm_PRICE, m_QAMIDCHANNEL, m_QAMFREQUENCY, m_QAMMODULATION, m_REASONCODE, m_RESPONSECODE, \n\t\t\tm_RETRIES, m_TSDOWNSTREAMBW, m_VASPID, m_DURATION, m_SITEKEY, m_TRANSACTIONKEY, m_MULTIPLEASSET,\n\t\t\tm_STATUS, m_HUB, m_ENCRYPTED, m_PURCHASEKEY, m_PURCHASETIME, m_ISINQUIRY, m_PURCHASERESULT, \n\t\t\tm_BILLINGCODE, m_HIGHDEF, m_SITENAME, m_EVENTKEY, m_INSERTTIME, m_TSIDOUT, m_TERMINALSUBNET, \n\t\t\tm_HUBID, m_ASSETPROVAPPNAME, m_FORWARDASSNMP, m_IPADDRESS, m_VENDORID, m_FORACTIVITY, \n\t\t\tm_DATA_VALUE, m_PVT_DATA, m_VERRCODE);\n\t\tCLOSE CU;\n\t\tEXIT;\n\tEND IF;\n\tIF m_SESSIONKEY IS NOT NULL\n\tTHEN\n\t\tvrec.SESSIONKEY := m_SESSIONKEY;\n\tEND IF;\n\tIF m_DSMCCSESSIONID IS NOT NULL\n\tTHEN\n\t\tvrec.DSMCCSESSIONID := m_DSMCCSESSIONID;\n\tEND IF;\n\tIF m_TERMINALID IS NOT NULL\n\tTHEN\n\t\tvrec.TERMINALID := m_TERMINALID;\n\tEND IF;\n\tIF m_SERVICEID IS NOT NULL\n\tTHEN\n\t\tvrec.SERVICEID := m_SERVICEID;\n\tEND IF;\n\tIF m_SVCGWID IS NOT NULL\n\tTHEN\n\t\tvrec.SVCGWID := m_SVCGWID;\n\tEND IF;\n\tIF m_SERVICEGROUP IS NOT NULL\n\tTHEN\n\t\tvrec.SERVICEGROUP := m_SERVICEGROUP;\n\tEND IF;\n\tIF m_OFFERING IS NOT NULL\n\tTHEN\n\t\tvrec.OFFERING := m_OFFERING;\n\tEND IF;\n\tIF m_SESSIONINSTANTIATIONTIME IS NOT NULL\n\tTHEN\n\t\tvrec.SESSIONINSTANTIATIONTIME := m_SESSIONINSTANTIATIONTIME;\n\tEND IF;\n\tIF m_SESSIONDESTRUCTIONTIME IS NOT NULL\n\tTHEN\n\t\tvrec.SESSIONDESTRUCTIONTIME := m_SESSIONDESTRUCTIONTIME;\n\tEND IF;\n\tIF m_ASSETID IS NOT NULL\n\tTHEN\n\t\tvrec.ASSETID := m_ASSETID;\n\tEND IF;\n\tIF m_STREAMID IS NOT NULL\n\tTHEN\n\t\tvrec.STREAMID := m_STREAMID;\n\tEND IF;\n\tIF m_STREAMSERVICEID IS NOT NULL\n\tTHEN\n\t\tvrec.STREAMSERVICEID := m_STREAMSERVICEID;\n\tEND IF;\n\tIF m_CONDITIONALACCESSKEY IS NOT NULL\n\tTHEN\n\t\tvrec.CONDITIONALACCESSKEY := m_CONDITIONALACCESSKEY;\n\tEND IF;\n\tIF m_ISACONTENTID IS NOT NULL\n\tTHEN\n\t\tvrec.ISACONTENTID := m_ISACONTENTID;\n\tEND IF;\n\tIF m_CUSTOMERID IS NOT NULL\n\tTHEN\n\t\tvrec.CUSTOMERID := m_CUSTOMERID;\n\tEND IF;\n\tIF m_ETHERNETDESCRIPTOR IS NOT NULL\n\tTHEN\n\t\tvrec.ETHERNETDESCRIPTOR := m_ETHERNETDESCRIPTOR;\n\tEND IF;\n\tIF m_VIDEOSERVERID IS NOT NULL\n\tTHEN\n\t\tvrec.VIDEOSERVERID := m_VIDEOSERVERID;\n\tEND IF;\n\tIF m_LSCHANDLE IS NOT NULL\n\tTHEN\n\t\tvrec.LSCHANDLE := m_LSCHANDLE;\n\tEND IF;\n\tIF m_LSCSERVERIP IS NOT NULL\n\tTHEN\n\t\tvrec.LSCSERVERIP := m_LSCSERVERIP;\n\tEND IF;\n\tIF m_LSCSERVERPORT IS NOT NULL\n\tTHEN\n\t\tvrec.LSCSERVERPORT := m_LSCSERVERPORT;\n\tEND IF;\n\tIF m_LSCSERVERMODE IS NOT NULL\n\tTHEN\n\t\tvrec.LSCSERVERMODE := m_LSCSERVERMODE;\n\tEND IF;\n\tIF m_MPEGPROGRAMID IS NOT NULL\n\tTHEN\n\t\tvrec.MPEGPROGRAMID := m_MPEGPROGRAMID;\n\tEND IF;\n\tIF m_PRICE IS NOT NULL\n\tTHEN\n\t\tvrec.PRICE := m_PRICE;\n\tEND IF;\n\tIF m_QAMIDCHANNEL IS NOT NULL\n\tTHEN\n\t\tvrec.QAMIDCHANNEL := m_QAMIDCHANNEL;\n\tEND IF;\n\tIF m_QAMFREQUENCY IS NOT NULL\n\tTHEN\n\t\tvrec.QAMFREQUENCY := m_QAMFREQUENCY;\n\tEND IF;\n\tIF m_QAMMODULATION IS NOT NULL\n\tTHEN\n\t\tvrec.QAMMODULATION := m_QAMMODULATION;\n\tEND IF;\n\tIF m_REASONCODE IS NOT NULL\n\tTHEN\n\t\tvrec.REASONCODE := m_REASONCODE;\n\tEND IF;\n\tIF m_RESPONSECODE IS NOT NULL\n\tTHEN\n\t\tvrec.RESPONSECODE := m_RESPONSECODE;\n\tEND IF;\n\tIF m_RETRIES IS NOT NULL\n\tTHEN\n\t\tvrec.RETRIES := m_RETRIES;\n\tEND IF;\n\tIF m_TSDOWNSTREAMBW IS NOT NULL\n\tTHEN\n\t\tvrec.TSDOWNSTREAMBW := m_TSDOWNSTREAMBW;\n\tEND IF;\n\tIF m_VASPID IS NOT NULL\n\tTHEN\n\t\tvrec.VASPID := m_VASPID;\n\tEND IF;\n\tIF m_DURATION IS NOT NULL\n\tTHEN\n\t\tvrec.DURATION := m_DURATION;\n\tEND IF;\n\tIF m_SITEKEY IS NOT NULL\n\tTHEN\n\t\tvrec.SITEKEY := m_SITEKEY;\n\tEND IF;\n\tIF m_TRANSACTIONKEY IS NOT NULL\n\tTHEN\n\t\tvrec.TRANSACTIONKEY := m_TRANSACTIONKEY;\n\tEND IF;\n\tIF m_MULTIPLEASSET IS NOT NULL\tTHEN\t\tvrec.MULTIPLEASSET := m_MULTIPLEASSET;\tEND IF;\tIF m_STATUS IS NOT NULL\tTHEN\t\tvrec.STATUS := m_STATUS;\tEND IF;\tIF m_HUB IS NOT NULL\tTHEN\t\tvrec.HUB := m_HUB;\tEND IF;\tIF m_ENCRYPTED IS NOT NULL\tTHEN\t\tvrec.ENCRYPTED := m_ENCRYPTED;\tEND IF;\tIF m_PURCHASEKEY IS NOT NULL\tTHEN\t\tvrec.PURCHASEKEY := m_PURCHASEKEY; \tEND IF;\tIF m_PURCHASETIME IS NOT NULL\tTHEN\t\tvrec.PURCHASETIME := m_PURCHASETIME;\tEND IF;\tIF m_ISINQUIRY IS NOT NULL\tTHEN\t\tvrec.ISINQUIRY := m_ISINQUIRY;\tEND IF;\tIF m_PURCHASERESULT IS NOT NULL\tTHEN\t\tvrec.PURCHASERESULT := m_PURCHASERESULT;\tEND IF;\tIF m_BILLINGCODE IS NOT NULL\tTHEN\t\tvrec.BILLINGCODE := m_BILLINGCODE;\tEND IF;\tIF m_HIGHDEF IS NOT NULL\tTHEN\t\tvrec.HIGHDEF := m_HIGHDEF;\tEND IF;\tIF m_SITENAME IS NOT NULL\tTHEN\t\tvrec.SITENAME := m_SITENAME;\tEND IF;\tIF m_EVENTKEY IS NOT NULL\tTHEN\t\tvrec.EVENTKEY := m_EVENTKEY;\tEND IF;\tIF m_INSERTTIME IS NOT NULL\tTHEN\t\tvrec.INSERTTIME := m_INSERTTIME;\tEND IF;\tIF m_TSIDOUT IS NOT NULL\tTHEN\t\tvrec.TSIDOUT := m_TSIDOUT;\tEND IF;\tIF m_TERMINALSUBNET IS NOT NULL\tTHEN\t\tvrec.TERMINALSUBNET := m_TERMINALSUBNET;\tEND IF;\tIF m_HUBID IS NOT NULL\tTHEN\t\tvrec.HUBID := m_HUBID;\tEND IF;\tIF m_ASSETPROVAPPNAME IS NOT NULL\tTHEN\t\tvrec.ASSETPROVAPPNAME := m_ASSETPROVAPPNAME;\tEND IF;\tIF m_FORWARDASSNMP IS NOT NULL\tTHEN\t\tvrec.FORWARDASSNMP := m_FORWARDASSNMP;\tEND IF;\tIF m_IPADDRESS IS NOT NULL\tTHEN\t\tvrec.IPADDRESS := m_IPADDRESS;\tEND IF;\tIF m_VENDORID IS NOT NULL\tTHEN\t\tvrec.VENDORID := m_VENDORID;\tEND IF;\tIF m_FORACTIVITY IS NOT NULL\tTHEN\t\t vrec.FORACTIVITY := m_FORACTIVITY;\tEND IF;\tIF m_DATA_VALUE IS NOT NULL\tTHEN\t\tvrec.DATA_VALUE := m_DATA_VALUE;\tEND IF;\tIF m_PVT_DATA IS NOT NULL\tTHEN\t\tvrec.PVT_DATA := m_PVT_DATA;\tEND IF;\tIF m_VERRCODE IS NOT NULL\tTHEN\t\tvrec.VERRCODE := m_VERRCODE;\tEND IF;\n\tUPDATE SESSIONHISTORY SET SESSIONKEY=vrec.SESSIONKEY, DSMCCSESSIONID=vrec.DSMCCSESSIONID,\t\tTERMINALID=vrec.TERMINALID, SERVICEID=vrec.SERVICEID, SVCGWID=vrec.SVCGWID, \t\tSERVICEGROUP=vrec.SERVICEGROUP, OFFERING=vrec.OFFERING, \t\tSESSIONINSTANTIATIONTIME=vrec.SESSIONINSTANTIATIONTIME, \t\tSESSIONDESTRUCTIONTIME=vrec.SESSIONDESTRUCTIONTIME, ASSETID=vrec.ASSETID, \t\tSTREAMID=vrec.STREAMID, STREAMSERVICEID=vrec.STREAMSERVICEID, \t\tCONDITIONALACCESSKEY=vrec.CONDITIONALACCESSKEY, ISACONTENTID=vrec.ISACONTENTID, \t\tCUSTOMERID=vrec.CUSTOMERID, ETHERNETDESCRIPTOR=vrec.ETHERNETDESCRIPTOR, \t\tVIDEOSERVERID=vrec.VIDEOSERVERID, LSCHANDLE=vrec.LSCHANDLE, LSCSERVERIP=vrec.LSCSERVERIP, \t\tLSCSERVERPORT=vrec.LSCSERVERPORT, LSCSERVERMODE=vrec.LSCSERVERMODE, \t\tMPEGPROGRAMID=vrec.MPEGPROGRAMID, PRICE=vrec.PRICE, QAMIDCHANNEL=vrec.QAMIDCHANNEL, \t\tQAMFREQUENCY=vrec.QAMFREQUENCY, QAMMODULATION=vrec.QAMMODULATION, REASONCODE=vrec.REASONCODE, \t\tRESPONSECODE=vrec.RESPONSECODE, RETRIES=vrec.RETRIES, TSDOWNSTREAMBW=vrec.TSDOWNSTREAMBW, \t\tVASPID=vrec.VASPID, DURATION=vrec.DURATION, SITEKEY=vrec.SITEKEY, \t\tTRANSACTIONKEY=vrec.TRANSACTIONKEY, MULTIPLEASSET=vrec.MULTIPLEASSET, STATUS=vrec.STATUS, \t\tHUB=vrec.HUB, ENCRYPTED=vrec.ENCRYPTED, PURCHASEKEY=vrec.PURCHASEKEY, \t\tPURCHASETIME=vrec.PURCHASETIME, ISINQUIRY=vrec.ISINQUIRY, PURCHASERESULT=vrec.PURCHASERESULT, \t\tBILLINGCODE=vrec.BILLINGCODE, HIGHDEF=vrec.HIGHDEF, SITENAME=vrec.SITENAME, \t\tEVENTKEY=vrec.EVENTKEY, INSERTTIME=vrec.INSERTTIME, TSIDOUT=vrec.TSIDOUT, \t\tTERMINALSUBNET=vrec.TERMINALSUBNET, HUBID=vrec.HUBID, ASSETPROVAPPNAME=vrec.ASSETPROVAPPNAME, \t\tFORWARDASSNMP=vrec.FORWARDASSNMP, IPADDRESS=vrec.IPADDRESS, VENDORID=vrec.VENDORID, \t\tFORACTIVITY=vrec.FORACTIVITY, DATA_VALUE=vrec.DATA_VALUE, PVT_DATA=vrec.PVT_DATA, \t\tVERRCODE=vrec.VERRCODE\t\tWHERE CURRENT OF CU;\tCLOSE CU;\tEXIT;   END LOOP;\nEND;";
    static final String PSMergeEventCounter = "DECLARE \tm_TIME_KEY    \tEVENT_COUNTER.TIME_KEY%TYPE; \tm_EVENT_NAME  \tEVENT_COUNTER.EVENT_NAME%TYPE; \tm_COUNT \t\t    EVENT_COUNTER.EVENT_COUNT%TYPE; BEGIN m_TIME_KEY := ?;\n m_EVENT_NAME := ?;\n m_COUNT := ?;\n MERGE INTO EVENT_COUNTER ec\tUSING (SELECT * FROM DUAL) \tON (ec.TIME_KEY \t = m_TIME_KEY    and ec.EVENT_NAME = m_EVENT_NAME)  WHEN MATCHED THEN  \tUPDATE SET EVENT_COUNT = EVENT_COUNT + m_COUNT  WHEN NOT MATCHED THEN \tINSERT (TIME_KEY, EVENT_NAME, EVENT_COUNT) \tVALUES (m_TIME_KEY, m_EVENT_NAME, m_COUNT); END;";
    static SettingsClient sClient = null;
    static byte whenExhastedAction = 1;
    static long maxWait = -1L;
    static int maxIdle = 8;
    static boolean testOnBorrow = false;
    static boolean testOnReturn = false;
    static long timeBetweenEvictionRunsMillis = -1L;
    static int numTestsPerEvictionRun = 3;
    static long minEvictableIdleTimeMillis = 1800000L;
    static boolean testWhileIdle = false;
    static long evictorSleepMillis = -1L;
    static String validationQuery = "SELECT 1 FROM DUAL";
    static DataSource connMgr = null;
    static int maxConn = 5;
    static String uri = "jdbc:oracle:thin:@bmsrptdb:1521:BMSRPT";
    static String user = "BMS";
    static String password = "BMS";
    private static smpDBWriter instance;
    private static boolean isRunning;
    private DBSessionEventQueue sessionEventQueue;
    private DBSessionErrorQueue sessionErrorQueue;
    private DBSessionHistoryQueue sessionHistoryQueue;
    private DBEventCounterQueue eventCounterQueue;
    private static HashMap<String, Long> eventAccumulator;
    private static EventCounterFlush flushTread;
    private static String myClass;
    private static ReentrantLock accumulatorLock;

    public static smpDBWriter instance() throws Exception {
        if (instance == null) {
            try {
                instance = new smpDBWriter();
            }
            catch (Exception e) {
                instance = null;
                throw e;
            }
        }
        return instance;
    }

    public boolean init(SettingsClient sc) throws Exception {
        String myMethod = "init";
        sClient = sc;
        if (sClient != null) {
            maxConn = sClient.getLong("n2bb.smp.maxconn", 1);
            validationQuery = sClient.getString("", "", "n2bb.smp.Oracle.validationQuery", "SELECT 1 FROM DUAL");
            user = sClient.getString("n2bb.smp.user", "BMS");
            password = sClient.getString("n2bb.smp.password", "BMS");
            uri = sClient.getString("n2bb.smp.url", "jdbc:oracle:thin:@bmsrptdb:1521:BMSRPT");
            testOnBorrow = true;
            long idleTime = sClient.getLong("n2bb.bms.Oracle.evictIdleMillis", 0);
            long sleepTime = sClient.getLong("n2bb.bms.Oracle.evictorSleepMillis", 0);
            if (idleTime > 0L) {
                String msg = "Setting DBCP evictIdleMillis to " + idleTime + " Run every " + sleepTime;
                N2BB_LogClient.instance().logMessage(myClass, myMethod, msg, 9);
                testWhileIdle = true;
                minEvictableIdleTimeMillis = idleTime;
                timeBetweenEvictionRunsMillis = evictorSleepMillis;
            }
        }
        if (connMgr == null) {
            System.out.println("Setting up DB Pool");
            try {
                this.initDB();
            }
            catch (Exception e) {
                System.out.println("No Luck");
                String msg = "Exception from initDB:" + e.getMessage();
                N2BB_LogClient.instance().logMessage(myClass, myMethod, msg, 3);
                throw e;
            }
        }
        this.sessionEventQueue = new DBSessionEventQueue(1);
        this.sessionErrorQueue = new DBSessionErrorQueue(1);
        this.sessionHistoryQueue = new DBSessionHistoryQueue(1);
        this.eventCounterQueue = new DBEventCounterQueue(1);
        return true;
    }

    smpDBWriter() throws Exception {
        eventAccumulator = new HashMap();
        accumulatorLock = new ReentrantLock();
        flushTread = new EventCounterFlush();
        flushTread.start();
    }

    public long getSessionSequence() throws Exception {
        String myMethod = "getSessionSequence";
        Statement ps = null;
        ResultSet rs = null;
        Connection con = null;
        long result = -1L;
        try {
            con = connMgr.getConnection();
            ps = con.prepareStatement(strPSSessionSequence);
            rs = ps.executeQuery();
            rs.next();
            result = rs.getLong(1);
        }
        catch (SQLException se) {
            N2BB_LogClient.instance().logMessage(myClass, "getSessionSequence", se.getMessage(), 3);
            se.printStackTrace();
            throw se;
        }
        catch (Exception e) {
            N2BB_LogClient.instance().logMessage(myClass, "getSessionSequence", e.getMessage(), 3);
            throw e;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception ignore) {}
            try {
                con.close();
            }
            catch (Exception ignore) {}
        }
        return result;
    }

    public boolean writeSessionEvent(SessionEventBean eb) {
        String myMethod = "writeEvent";
        N2BB_LogClient.instance().logMessage(myClass, "writeEvent", "Writing event", 9);
        return this.sessionEventQueue.add(eb);
    }

    public boolean writeSessionError(SessionErrorBean seb) {
        return this.sessionErrorQueue.add(seb);
    }

    public boolean writeSessionHistory(SessionHistoryBean sb) {
        return this.sessionHistoryQueue.add(sb);
    }

    public boolean writeEventCounter(EventCounterBean ecb) {
        return this.eventCounterQueue.add(ecb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchWriteSessionEvent(Vector v) {
        String myMethod = "batchWriteEvent";
        N2BB_LogClient.instance().logMessage(myClass, "batchWriteEvent", "Writing " + v.size() + " events", 9);
        Statement ps = null;
        Object rs = null;
        Connection con = null;
        SessionEventBean eb = null;
        try {
            con = connMgr.getConnection();
            ps = con.prepareStatement(strPSEvent);
            for (int i = 0; i < v.size(); ++i) {
                eb = (SessionEventBean)v.get(i);
                ps.setLong(1, eb.sessionKey);
                ps.setLong(2, eb.eventCode);
                if (eb.startTime != null) {
                    ps.setTimestamp(3, new Timestamp(Long.parseLong(eb.startTime)));
                } else {
                    ps.setNull(3, 93);
                }
                if (eb.endTime != null) {
                    ps.setTimestamp(4, new Timestamp(Long.parseLong(eb.endTime)));
                } else {
                    ps.setNull(4, 93);
                }
                ps.addBatch();
            }
            ps.executeBatch();
            con.commit();
        }
        catch (SQLException sqle) {
            N2BB_LogClient.instance().logStackTrace(myClass, "batchWriteEvent", "Exception", (Throwable)sqle, 3);
        }
        catch (Exception e) {
            N2BB_LogClient.instance().logStackTrace(myClass, "batchWriteEvent", "Exception", (Throwable)e, 3);
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception ignore) {}
            try {
                con.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchWriteSessionError(Vector v) {
        String myMethod = "batchWriteError";
        N2BB_LogClient.instance().logMessage(myClass, "batchWriteError", "Writing " + v.size() + " errors", 9);
        Statement ps = null;
        Object rs = null;
        Connection con = null;
        SessionErrorBean eb = null;
        try {
            con = connMgr.getConnection();
            ps = con.prepareStatement(strPSError);
            for (int i = 0; i < v.size(); ++i) {
                eb = (SessionErrorBean)v.get(i);
                ps.setLong(1, eb.sessionKey);
                ps.setLong(2, eb.eventCode);
                ps.setString(3, eb.rmks);
                if (eb.date != null) {
                    ps.setTimestamp(4, new Timestamp(Long.parseLong(eb.date)));
                } else {
                    ps.setNull(4, 93);
                }
                ps.addBatch();
            }
            ps.executeBatch();
            con.commit();
        }
        catch (SQLException sqle) {
            N2BB_LogClient.instance().logStackTrace(myClass, "batchWriteError", "Exception", (Throwable)sqle, 3);
        }
        catch (Exception e) {
            N2BB_LogClient.instance().logStackTrace(myClass, "batchWriteError", "Exception", (Throwable)e, 3);
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception ignore) {}
            try {
                con.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchWriteSessionHistory(Vector v) {
        String myMethod = "batchWriteSession";
        N2BB_LogClient.instance().logMessage(myClass, "batchWriteSession", "Writing " + v.size() + " Sessions", 9);
        Statement ps = null;
        Object rs = null;
        Connection con = null;
        try {
            con = connMgr.getConnection();
            ps = con.prepareStatement(strPSSession);
            for (int i = 0; i < v.size(); ++i) {
                SessionHistoryBean sb = (SessionHistoryBean)v.get(i);
                ps.setLong(1, sb.sessionKey);
                ps.setString(2, sb.dsmccSessionId);
                ps.setString(3, sb.terminalId);
                ps.setString(4, sb.ServiceId);
                ps.setString(5, sb.svcGwId);
                ps.setString(6, sb.serviceGroup);
                ps.setString(7, sb.offering);
                if (sb.sessionInstantiationTime != null) {
                    ps.setTimestamp(8, new Timestamp(Long.parseLong(sb.sessionInstantiationTime)));
                } else {
                    ps.setNull(8, 93);
                }
                if (sb.sessionDestructionTime != null) {
                    ps.setTimestamp(9, new Timestamp(Long.parseLong(sb.sessionDestructionTime)));
                } else {
                    ps.setNull(9, 93);
                }
                ps.setString(10, sb.assetId);
                ps.setString(11, sb.streamId);
                ps.setString(12, sb.streamServiceId);
                ps.setString(13, sb.conditionalAccess_ID);
                ps.setString(14, null);
                ps.setString(15, sb.customerId);
                ps.setString(16, null);
                ps.setString(17, null);
                ps.setString(18, null);
                ps.setString(19, null);
                ps.setString(20, null);
                ps.setString(21, null);
                ps.setString(22, null);
                ps.setString(23, null);
                ps.setString(24, null);
                ps.setString(25, null);
                ps.setString(26, null);
                ps.setString(27, null);
                ps.setString(28, null);
                ps.setString(29, null);
                ps.setString(30, null);
                ps.setString(31, null);
                ps.setString(32, null);
                ps.setString(33, null);
                ps.setString(34, null);
                ps.setString(35, null);
                ps.setString(36, null);
                ps.setString(37, null);
                ps.setString(38, null);
                ps.setString(39, null);
                ps.setString(40, null);
                ps.setString(41, null);
                ps.setString(42, null);
                ps.setString(43, null);
                ps.setString(44, null);
                ps.setString(45, null);
                ps.setString(46, null);
                ps.setString(47, null);
                ps.setString(48, null);
                ps.setString(49, null);
                ps.setString(50, null);
                ps.setString(51, null);
                ps.setString(52, null);
                ps.setString(53, null);
                ps.setString(54, null);
                ps.setString(55, null);
                ps.setString(56, null);
                ps.setString(57, null);
                ps.setString(58, null);
                ps.addBatch();
            }
            ps.executeBatch();
            con.commit();
        }
        catch (SQLException sqle) {
            N2BB_LogClient.instance().logStackTrace(myClass, "batchWriteSession", "Exception", (Throwable)sqle, 3);
        }
        catch (Exception e) {
            N2BB_LogClient.instance().logStackTrace(myClass, "batchWriteSession", "Exception", (Throwable)e, 3);
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception ignore) {}
            try {
                con.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchWriteEventCounter(Vector<EventCounterBean> v) {
        for (EventCounterBean ecb : v) {
            String time = ecb.getTimeKey();
            String event = ecb.getEvent();
            long count = ecb.getCount();
            String TimeEventKey = String.format("%s:%s", time, event);
            try {
                accumulatorLock.lock();
                Long accumTime = eventAccumulator.get(TimeEventKey);
                if (accumTime != null) {
                    accumTime = accumTime + count;
                    eventAccumulator.put(TimeEventKey, accumTime);
                    continue;
                }
                accumTime = new Long(count);
                eventAccumulator.put(TimeEventKey, accumTime);
            }
            finally {
                accumulatorLock.unlock();
            }
        }
    }

    private synchronized void initDB() throws Exception {
        System.setProperty("jdbc.drivers", "oracle.jdbc.driver.OracleDriver");
        String myMethod = "initDB";
        try {
            GenericObjectPool connPool = new GenericObjectPool(null, maxConn, whenExhastedAction, maxWait, maxIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
            DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(uri, user, password);
            PoolableConnectionFactory poolableConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)connPool, null, validationQuery, false, false);
            connMgr = new PoolingDataSource((ObjectPool)connPool);
        }
        catch (Exception e) {
            N2BB_LogClient.instance().logMessage(myClass, "initDB", e.getMessage(), 3);
            throw e;
        }
    }

    static {
        isRunning = true;
        myClass = "smpDBWriter";
    }

    class EventCounterFlush
    extends Thread {
        EventCounterFlush() {
        }

        public void run() {
            while (isRunning) {
                try {
                    EventCounterFlush.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.flushData();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushData() {
            HashMap localhash;
            try {
                accumulatorLock.lock();
                localhash = eventAccumulator;
                eventAccumulator = new HashMap();
            }
            finally {
                accumulatorLock.unlock();
            }
            Connection con = null;
            Statement ps = null;
            try {
                con = connMgr.getConnection();
                ps = con.prepareStatement(smpDBWriter.PSMergeEventCounter);
                for (String timekey : localhash.keySet()) {
                    long count = (Long)localhash.get(timekey);
                    String[] s = timekey.split(":");
                    try {
                        int eventCode = Integer.parseInt(s[1]);
                        ps.setString(2, Events.intToEvent((int)eventCode).toString());
                    }
                    catch (Exception e) {
                        ps.setString(2, s[1]);
                    }
                    System.out.println("Writing eventkey " + timekey);
                    ps.setString(1, s[0]);
                    ps.setLong(3, count);
                    ps.addBatch();
                }
                ps.executeBatch();
                con.commit();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            finally {
                try {
                    ps.close();
                }
                catch (Exception e) {}
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
    }

    class DBEventCounterWriterThread
    extends Thread {
        DBEventCounterQueue q;
        String myClass = "DBEventCounterWriterThread";

        DBEventCounterWriterThread(DBEventCounterQueue q) {
            this.q = q;
        }

        public void run() {
            String myMethod = "run";
            while (true) {
                try {
                    while (true) {
                        Vector v = this.q.getQueue();
                        smpDBWriter.this.batchWriteEventCounter(v);
                    }
                }
                catch (Exception e) {
                    String msg = "Unexpected Exception";
                    N2BB_LogClient.instance().logMessage(this.myClass, myMethod, msg, 3);
                    continue;
                }
                break;
            }
        }
    }

    class DBSessionWriterThread
    extends Thread {
        DBSessionHistoryQueue q;
        String myClass = "DBSessionWriterThread";

        DBSessionWriterThread(DBSessionHistoryQueue q) {
            this.q = q;
        }

        public void run() {
            String myMethod = "run";
            while (true) {
                try {
                    while (true) {
                        Vector v = this.q.getQueue();
                        smpDBWriter.this.batchWriteSessionHistory(v);
                    }
                }
                catch (Exception e) {
                    String msg = "Unexpected Exception";
                    N2BB_LogClient.instance().logMessage(this.myClass, myMethod, msg, 3);
                    continue;
                }
                break;
            }
        }
    }

    class DBErrorWriterThread
    extends Thread {
        DBSessionErrorQueue q;
        String myClass = "DBErrorWriterThread";

        DBErrorWriterThread(DBSessionErrorQueue q) {
            this.q = q;
        }

        public void run() {
            String myMethod = "run";
            while (true) {
                try {
                    while (true) {
                        Vector v = this.q.getQueue();
                        smpDBWriter.this.batchWriteSessionError(v);
                    }
                }
                catch (Exception e) {
                    String msg = "Unexpected Exception";
                    N2BB_LogClient.instance().logMessage(this.myClass, myMethod, msg, 3);
                    continue;
                }
                break;
            }
        }
    }

    class DBEventWriterThread
    extends Thread {
        DBSessionEventQueue q;
        String myClass = "DBEventWriterThread";

        DBEventWriterThread(DBSessionEventQueue q) {
            this.q = q;
        }

        public void run() {
            String myMethod = "run";
            while (true) {
                try {
                    while (true) {
                        Vector v = this.q.getQueue();
                        smpDBWriter.this.batchWriteSessionEvent(v);
                    }
                }
                catch (Exception e) {
                    String msg = "Unexpected Exception";
                    N2BB_LogClient.instance().logMessage(this.myClass, myMethod, msg, 3);
                    continue;
                }
                break;
            }
        }
    }

    class DBEventCounterQueue {
        private Vector EventCounterQueue;
        private Vector EventCounterPool;
        private String myClass = "DBEventCounterQueue";

        public DBEventCounterQueue(int threads) {
            String myMethod = "DBSessionWriterQueue";
            this.EventCounterQueue = new Vector();
            this.EventCounterPool = new Vector();
            for (int i = 0; i < threads; ++i) {
                DBEventCounterWriterThread t = new DBEventCounterWriterThread(this);
                t.start();
                this.EventCounterPool.add(t);
            }
        }

        public synchronized boolean add(Object a) {
            String myMethod = "add";
            if (this.EventCounterQueue.size() > 10000) {
                N2BB_LogClient.instance().logMessage(this.myClass, "add", "EventCounter queue input throttled. Data discarded", 3);
                return false;
            }
            this.EventCounterQueue.add(a);
            this.notify();
            return true;
        }

        public synchronized Vector getQueue() {
            String myMethod = "getQueue";
            while (this.EventCounterQueue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Vector v = this.EventCounterQueue;
            this.EventCounterQueue = new Vector();
            return v;
        }
    }

    class DBSessionHistoryQueue {
        private Vector sessionWriterQueue;
        private Vector sessionThreadQueue;
        private String myClass = "DBSessionHistoryQueue";

        public DBSessionHistoryQueue(int threads) {
            String myMethod = "DBSessionWriterQueue";
            this.sessionWriterQueue = new Vector();
            this.sessionThreadQueue = new Vector();
            for (int i = 0; i < threads; ++i) {
                DBSessionWriterThread t = new DBSessionWriterThread(this);
                t.start();
                this.sessionThreadQueue.add(t);
            }
        }

        public synchronized boolean add(Object a) {
            String myMethod = "add";
            if (this.sessionWriterQueue.size() > 10000) {
                N2BB_LogClient.instance().logMessage(this.myClass, "add", "Session queue input throttled. Data discarded", 3);
                return false;
            }
            this.sessionWriterQueue.add(a);
            this.notify();
            return true;
        }

        public synchronized Vector getQueue() {
            String myMethod = "getQueue";
            while (this.sessionWriterQueue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Vector v = this.sessionWriterQueue;
            this.sessionWriterQueue = new Vector();
            return v;
        }
    }

    class DBSessionErrorQueue {
        private Vector errorWriterQueue;
        private Vector errorThreadQueue;
        private String myClass = "DBErrorWriterQueue";

        public DBSessionErrorQueue(int threads) {
            String myMethod = "DBErrorWriterQueue";
            this.errorWriterQueue = new Vector();
            this.errorThreadQueue = new Vector();
            for (int i = 0; i < threads; ++i) {
                DBErrorWriterThread t = new DBErrorWriterThread(this);
                t.start();
                this.errorThreadQueue.add(t);
            }
        }

        public synchronized boolean add(Object a) {
            String myMethod = "add";
            if (this.errorWriterQueue.size() > 10000) {
                N2BB_LogClient.instance().logMessage(this.myClass, "add", "Error queue input throttled. Data discarded", 3);
                return false;
            }
            this.errorWriterQueue.add(a);
            this.notify();
            return true;
        }

        public synchronized Vector getQueue() {
            String myMethod = "getQueue";
            while (this.errorWriterQueue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Vector v = this.errorWriterQueue;
            this.errorWriterQueue = new Vector();
            return v;
        }
    }

    class DBSessionEventQueue {
        private Vector eventWriterQueue;
        private Vector eventThreadQueue;
        private String myClass = "DBEventWriterQueue";

        public DBSessionEventQueue(int threads) {
            String myMethod = "DBEventWriterQueue";
            this.eventWriterQueue = new Vector();
            this.eventThreadQueue = new Vector();
            for (int i = 0; i < threads; ++i) {
                DBEventWriterThread t = new DBEventWriterThread(this);
                t.start();
                this.eventThreadQueue.add(t);
            }
        }

        public synchronized boolean add(Object a) {
            String myMethod = "add";
            if (this.eventWriterQueue.size() > 10000) {
                N2BB_LogClient.instance().logMessage(this.myClass, "add", "Event queue input throttled. Data discarded", 3);
                return false;
            }
            this.eventWriterQueue.add(a);
            this.notify();
            return true;
        }

        public synchronized Vector getQueue() {
            String myMethod = "getQueue";
            while (this.eventWriterQueue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Vector v = this.eventWriterQueue;
            this.eventWriterQueue = new Vector();
            return v;
        }
    }
}

