/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test;

import com.ericsson.cms.test.ITestResultLogger;
import com.ericsson.cms.test.TestResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DBTestResultLogger
implements ITestResultLogger {
    private static final Logger logger = Logger.getLogger(DBTestResultLogger.class);
    private static final String DS_JNDI_URL = "java:/neptune/testerDS";
    private String testRunId;
    private String testerName;

    @Override
    public void logTestCaseResult(TestResult result) {
        Connection c = null;
        Statement ps = null;
        try {
            String sql = "insert into test_result (test_id, tester_name, testcase_name, status, error_message) values (?, ?, ?, ?, ?)";
            c = this.getConnection();
            ps = c.prepareStatement(sql);
            ps.setString(1, this.testRunId);
            ps.setString(2, this.testerName);
            ps.setString(3, this.trim(result.getTestCaseName(), 200));
            ps.setInt(4, result.getTestStatus().ordinal());
            ps.setString(5, this.trim(result.getErrorMsg(), 2000));
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ps.close();
                c.close();
            }
            catch (SQLException e) {
                logger.warn((Object)"Exception while closing db statement and connection", (Throwable)e);
            }
        }
    }

    private String trim(String str, int length) {
        if (str != null && str.length() > length) {
            return str.substring(0, length);
        }
        return str;
    }

    @Override
    public void setTestRunId(String testRunId) {
        this.testRunId = testRunId;
    }

    @Override
    public void setTesterName(String testerName) {
        this.testerName = testerName;
    }

    private Connection getConnection() throws NamingException, SQLException {
        DataSource ds = (DataSource)new InitialContext().lookup(DS_JNDI_URL);
        return ds.getConnection();
    }
}

