/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test;

import com.ericsson.cms.test.DetailedRunStatus;
import com.ericsson.cms.test.ITester;
import com.ericsson.cms.test.ResultNotifier;
import com.ericsson.cms.test.RunStatus;
import com.ericsson.cms.test.TestManagerException;
import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.TestStatus;
import com.ericsson.cms.test.util.StringUtil;

public class TestManager {
    private static TestManager instance = new TestManager();
    private ResultNotifier notifier;

    private TestManager() {
    }

    public static TestManager getInstance() {
        return instance;
    }

    public synchronized void startTest(String className, String testRunId) throws TestManagerException {
        try {
            Class<?> testerClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            Object testerObj = testerClass.newInstance();
            if (!(testerObj instanceof ITester)) {
                throw new TestManagerException("Class " + className + " must implement ITester interface");
            }
            this.startTester((ITester)testerObj, className, testRunId);
        }
        catch (ClassNotFoundException ex) {
            throw new TestManagerException("Could not find class " + className, ex);
        }
        catch (InstantiationException ex) {
            throw new TestManagerException("Could not create an instance of " + className, ex);
        }
        catch (IllegalAccessException ex) {
            throw new TestManagerException("Could not create an instance of " + className, ex);
        }
    }

    public synchronized RunStatus getStatus() {
        return this.notifier == null ? RunStatus.READY : this.notifier.getStatus();
    }

    public synchronized DetailedRunStatus getDetailedStatus() {
        DetailedRunStatus status = new DetailedRunStatus();
        if (this.notifier == null) {
            status.setStatus(RunStatus.READY);
        } else {
            status.setStatus(this.notifier.getStatus());
            status.setDbBackupRequired(this.notifier.isDbBackupRequired());
            status.setTestRunId(this.notifier.getTestRunId());
            status.setTestClassName(this.notifier.getTestClassName());
        }
        return status;
    }

    public synchronized TestResults getTestResults() {
        return this.notifier == null ? new TestResults(null) : this.notifier.getTestResults();
    }

    private void startTester(final ITester tester, final String className, String testRunId) {
        this.notifier = new ResultNotifier(className, testRunId);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    tester.run(TestManager.this.notifier);
                }
                catch (Throwable t) {
                    TestResult result = new TestResult(className, TestStatus.FAILURE, StringUtil.getStackTrace(t));
                    TestManager.this.notifier.logTestCaseResult(result);
                    TestManager.this.notifier.setReady();
                }
            }
        };
        thread.start();
    }
}

