/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.client.CommandException;
import com.ericsson.cms.test.client.TestClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;

public class RemoteCommadExecuter {
    private static final String ERROR_WHILE_RUNNING = "Error while running: ";
    private static final String COMMAND_PLACEHOLDER = "{command}";
    private static final String RESTORE_COMMAND = "rollbackto_restore_point.sh";
    private static final String BACKUP_COMMAND = "create_restore_point.sh";
    private TestClientConfig config;

    public RemoteCommadExecuter(TestClientConfig config) {
        this.config = config;
    }

    public void backupDb(String component) throws CommandException {
        StringBuilder sb = new StringBuilder();
        GregorianCalendar gc = new GregorianCalendar();
        sb.append(BACKUP_COMMAND);
        sb.append(" ");
        sb.append(component.trim().replace(".", "_"));
        sb.append("_");
        sb.append(gc.get(1));
        sb.append("_");
        sb.append(gc.get(2));
        sb.append("_");
        sb.append(gc.get(5));
        sb.append("_");
        sb.append(gc.get(11));
        sb.append("_");
        sb.append(gc.get(12));
        String command = this.config.getServerConfig().getDbSshCommand();
        command = command.replace(COMMAND_PLACEHOLDER, sb.toString());
        System.out.println("Starting backing up db. command: " + command);
        this.runCmdScript(command, true);
        System.out.println("Finished backing up db.");
    }

    public void restoreDb() throws CommandException {
        String command = this.config.getServerConfig().getDbSshCommand();
        command = command.replace(COMMAND_PLACEHOLDER, "rollbackto_restore_point.sh " + this.config.getServerConfig().getDbRestorePoint());
        System.out.println("Starting restoreDb. command: " + command);
        this.runCmdScript(command, true);
        System.out.println("Finished restoreDb.");
    }

    public void restartJboss() throws CommandException {
        System.out.println("Restarting JBoss. command: " + this.config.getServerConfig().getReStartJbossCmd());
        this.runCmdScript(this.config.getServerConfig().getReStartJbossCmd(), false);
        System.out.println("Finished restarting jboss.");
    }

    public void stopJboss() throws CommandException {
        System.out.println("stopping JBoss. command: " + this.config.getServerConfig().getStopJbossCmd());
        this.runCmdScript(this.config.getServerConfig().getStopJbossCmd(), true);
        System.out.println("Finished stopping jboss.");
    }

    private void runCmdScript(String command, boolean wait) throws CommandException {
        try {
            Process p = Runtime.getRuntime().exec(command);
            if (!wait) {
                return;
            }
            p.waitFor();
            String output = this.getStream(p.getInputStream());
            System.out.println(output);
            if (p.exitValue() != 0 || this.containsKnownErrorPattern(output)) {
                System.out.println(this.getStream(p.getErrorStream()));
                throw new CommandException(ERROR_WHILE_RUNNING + command);
            }
        }
        catch (Exception e) {
            throw new CommandException(ERROR_WHILE_RUNNING + command, e);
        }
    }

    private boolean containsKnownErrorPattern(String output) {
        return (output = output.toLowerCase()).contains("error") || output.contains("cms: unrecognized service");
    }

    private String getStream(InputStream in) throws IOException {
        int result;
        StringBuilder sb = new StringBuilder();
        int bytesToRead = 1024;
        byte[] input = new byte[bytesToRead];
        for (int bytesRead = 0; bytesRead < bytesToRead; bytesRead += result) {
            result = in.read(input, bytesRead, bytesToRead - bytesRead);
            sb.append(new String(input));
            if (result == -1) break;
        }
        in.close();
        return sb.toString();
    }
}

