/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.DetailedRunStatus;
import com.ericsson.cms.test.RunStatus;
import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.client.Command;
import com.ericsson.cms.test.client.CommandException;
import com.ericsson.cms.test.client.RemoteCommadExecuter;
import com.ericsson.cms.test.client.TestClientConfig;
import com.ericsson.cms.test.client.TestControllerClient;
import com.ericsson.cms.test.client.TestResultsCache;
import java.util.List;
import org.apache.log4j.Logger;

public class RunTestCommand
implements Command {
    private static Logger logger = Logger.getLogger(RunTestCommand.class);
    private String testClassName;
    private String componentName;
    private String testRunId;
    private TestClientConfig config;
    private TestControllerClient client;

    public RunTestCommand(String testClassName, String componentName, String testRunId, TestClientConfig config) {
        this.testClassName = testClassName;
        this.componentName = componentName;
        this.testRunId = testRunId;
        this.config = config;
        this.client = new TestControllerClient(config.getServerConfig().getRemoteControllerUrl());
    }

    @Override
    public void run() throws CommandException {
        this.startServerIfNeeded();
        boolean shouldWait = this.runTest();
        if (shouldWait) {
            this.waitUntilTestComplete();
        }
    }

    private void waitUntilTestComplete() throws CommandException {
        logger.info((Object)("Waiting for test to finish at most " + this.config.getServerConfig().getTestRunTimeoutMins() + " minutes..."));
        long startTime = System.currentTimeMillis();
        long timeout = 60000 * this.config.getServerConfig().getTestRunTimeoutMins();
        while (!this.isServerReadyForNextTest()) {
            if (System.currentTimeMillis() - startTime > timeout) {
                logger.info((Object)"Timed out.");
                return;
            }
            try {
                Thread.sleep(20000L);
            }
            catch (Exception ex) {}
        }
        logger.info((Object)"Done.");
        this.storeResults();
        DetailedRunStatus status = this.getDetailedStatus();
        if (status != null && status.isDbBackupRequired() && this.config.getServerConfig().isDBCommandsEnabled()) {
            logger.info((Object)"Database backup requested.");
            this.backupDb();
        }
    }

    private void storeResults() {
        try {
            TestResults results = this.client.getTestResults();
            TestResultsCache.getInstance().getTestRunResults().addTestResults(this.componentName, results);
            logger.info((Object)("Results for " + results.getClassName()));
            List<TestResult> list = results.getResults();
            if (list != null) {
                for (TestResult res : list) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Test case: " + res.getTestCaseName() + ", status: " + (Object)((Object)res.getTestStatus()));
                    if (res.getErrorMsg() != null) {
                        msg.append(", message: " + res.getErrorMsg());
                    }
                    logger.info((Object)msg);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not get test results: ", (Throwable)ex);
        }
    }

    private void backupDb() {
        try {
            RemoteCommadExecuter cmdExecutor = new RemoteCommadExecuter(this.config);
            cmdExecutor.backupDb(this.testClassName);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not backup database: ", (Throwable)ex);
        }
    }

    private boolean runTest() {
        logger.info((Object)("Calling " + this.config.getServerConfig().getRemoteControllerUrl() + " to run " + this.testClassName));
        try {
            this.client.runTest(this.testClassName, this.testRunId);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Could not start the test.", (Throwable)ex);
            return false;
        }
    }

    private void restartServer() throws CommandException {
        RemoteCommadExecuter cmdExecutor = new RemoteCommadExecuter(this.config);
        cmdExecutor.restartJboss();
    }

    private void startServerIfNeeded() throws CommandException {
        for (int i = 0; i < 3; ++i) {
            if (this.isServerUp()) {
                return;
            }
            logger.warn((Object)"Unable to ping the server.");
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isServerUp()) {
            return;
        }
        logger.info((Object)"Restarting the server...");
        this.restartServer();
        long startTime = System.currentTimeMillis();
        long timeout = 60000 * this.config.getServerConfig().getServerStartTimeoutMins();
        logger.info((Object)("Will wait for " + this.config.getServerConfig().getServerStartTimeoutMins() + " minutes for server to start."));
        do {
            logger.info((Object)"Waiting...");
            try {
                Thread.sleep(60000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
        } while (!this.isServerUp() && System.currentTimeMillis() - startTime < timeout);
        if (!this.isServerUp()) {
            throw new CommandException("Could not start the server.");
        }
        logger.info((Object)"Server is up");
    }

    private boolean isServerUp() {
        try {
            this.client.ping();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isServerReadyForNextTest() {
        try {
            return RunStatus.READY == this.client.getStatus();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private DetailedRunStatus getDetailedStatus() {
        try {
            return this.client.getDetailedStatus();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

