/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.DetailedRunStatus;
import com.ericsson.cms.test.RunStatus;
import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.client.CommandException;
import com.ericsson.cms.test.jaxb.TesterJaxbService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class TestControllerClient {
    private String strControllerUrl;
    private int timeoutMins = 1;

    public TestControllerClient(String controllerUrl) {
        this.strControllerUrl = controllerUrl;
    }

    public RunStatus getStatus() throws CommandException {
        String resp = this.sendCommand("command=status");
        if ("RUNNING".equals(resp)) {
            return RunStatus.RUNNING;
        }
        if (resp.startsWith("READY")) {
            return RunStatus.READY;
        }
        throw new CommandException("Invalid response " + resp);
    }

    public void ping() throws CommandException {
        String resp = this.sendCommand("command=ping");
        if (!"OK".equals(resp)) {
            throw new CommandException("Invalid response " + resp);
        }
    }

    public TestResults getTestResults() throws CommandException {
        String resp = this.sendCommand("command=getResults");
        if (resp.startsWith("ERROR:")) {
            throw new CommandException(resp);
        }
        try {
            TesterJaxbService service = new TesterJaxbService();
            return service.unmarshalTestResults(resp);
        }
        catch (Exception ex) {
            throw new CommandException("Could not parse test results: " + ex.getMessage());
        }
    }

    public DetailedRunStatus getDetailedStatus() throws CommandException {
        String resp = this.sendCommand("command=status");
        if (resp == null) {
            throw new CommandException("Invalid response " + resp);
        }
        DetailedRunStatus status = new DetailedRunStatus();
        if ("RUNNING".equals(resp)) {
            status.setStatus(RunStatus.RUNNING);
            status.setDbBackupRequired(false);
        } else if (resp.startsWith("READY")) {
            String[] tokens = resp.split(";");
            if (tokens.length >= 2 && "BACKUP_DB".equals(tokens[1])) {
                status.setDbBackupRequired(true);
            }
        } else {
            throw new CommandException("Invalid response " + resp);
        }
        return status;
    }

    public void runTest(String className, String testRunId) throws CommandException {
        String content = "command=RunTest&className=" + className + "&testRunId=" + this.encodeString(testRunId);
        String resp = this.sendCommand(content);
        if (!"OK".equals(resp)) {
            throw new CommandException(resp);
        }
    }

    private String sendCommand(String content) throws CommandException {
        try {
            URL url = new URL(this.strControllerUrl);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(60000 * this.timeoutMins);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream os = conn.getOutputStream();
            os.write(content.getBytes());
            os.flush();
            os.close();
            BufferedReader is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            char[] buf = new char[1024];
            int len = 0;
            StringBuilder bld = new StringBuilder();
            while ((len = is.read(buf)) > 0) {
                bld.append(buf, 0, len);
            }
            is.close();
            return bld.toString().trim();
        }
        catch (Exception ex) {
            throw new CommandException("Unable to send command '" + content + "'", ex);
        }
    }

    private String encodeString(String str) {
        String encodedStr = "";
        if (str != null) {
            try {
                encodedStr = URLEncoder.encode(str, "UTF-8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return encodedStr;
    }
}

