/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.junit;

import com.ericsson.cms.test.ResultNotifier;
import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestStatus;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class CmsTestRunListener
extends RunListener {
    private static final Logger logger = Logger.getLogger(CmsTestRunListener.class);
    private List<String> passedTestCases = new ArrayList<String>();
    private List<String> failedTestCases = new ArrayList<String>();
    private List<String> invalidTestCases = new ArrayList<String>();
    private ResultNotifier notifier;
    private String componentName;

    public CmsTestRunListener(String componentName, ResultNotifier notifier) {
        this.notifier = notifier;
        this.componentName = componentName;
    }

    public void testFailure(Failure failure) {
        String errMsg = failure.getMessage();
        if (errMsg.toLowerCase().contains("no runnable method")) {
            this.invalidTestCases.add(failure.getDescription().getDisplayName());
            logger.info((Object)("No runnable methods in " + failure.getDescription().getDisplayName()));
        } else {
            this.failedTestCases.add(failure.getDescription().getDisplayName());
        }
        this.notifier.logTestCaseResult(new TestResult(failure.getDescription().getDisplayName(), TestStatus.FAILURE, null));
    }

    public void testFinished(Description description) {
        if (!this.failedTestCases.contains(description.getDisplayName()) && !this.invalidTestCases.contains(description.getDisplayName())) {
            this.notifier.logTestCaseResult(new TestResult(description.getDisplayName(), TestStatus.SUCCESS, null));
            this.passedTestCases.add(description.getDisplayName());
        }
    }

    public void testRunFinished(Result result) {
        System.out.println("Unit Test for Component:" + this.componentName);
        System.out.println("--- Total # of JUnit Test Cases:" + (this.passedTestCases.size() + this.failedTestCases.size()));
        System.out.println("----# JUnit Test Cases that Failed:" + this.failedTestCases.size());
    }
}

