/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.junit;

import com.ericsson.cms.test.ResultNotifier;
import com.ericsson.cms.test.junit.CmsTestRunListener;
import com.ericsson.cms.test.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.notification.RunListener;

public class JUnitTester {
    private static final Logger logger = Logger.getLogger(JUnitTester.class);
    protected List<Class<?>> testClasses = new ArrayList();
    protected String componentName = "";
    protected String packageName = "";
    protected ResultNotifier notifier;

    public JUnitTester(ResultNotifier notifier) {
        this.notifier = notifier;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setpackageName(String packageName) {
        this.packageName = packageName;
    }

    public void addTestCase(Class<?> className) {
        this.testClasses.add(className);
    }

    public void test() {
        if (!this.packageName.isEmpty()) {
            try {
                this.testClasses = ClassUtil.getClasses(this.packageName);
            }
            catch (Exception e) {
                logger.error((Object)"Error getting classes from package name. ", (Throwable)e);
            }
        }
        JUnitCore core = new JUnitCore();
        core.addListener((RunListener)new CmsTestRunListener(this.componentName, this.notifier));
        Request r = Request.classes((String)this.componentName, (Class[])this.testClasses.toArray(new Class[0]));
        core.run(r);
    }
}

