/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.util;

import com.ericsson.cms.test.util.ClassesFinder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class ClassUtil {
    private static final Logger logger = Logger.getLogger(ClassUtil.class);

    public static List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String fileName = resource.getFile();
            String fileNameDecoded = URLDecoder.decode(fileName, "UTF-8");
            logger.info((Object)("resourceFile in classloader=" + fileNameDecoded + "    path=" + resource.getPath()));
            dirs.add(new File(fileNameDecoded));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(ClassUtil.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        List<Object> classNames = new ArrayList();
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            logger.debug((Object)("Need to open jar/ear/zip to look for classes,  path=" + directory.getPath()));
            ClassesFinder finder = new ClassesFinder();
            String jarFile = ClassesFinder.getTargetJarFileFromResource(directory.getPath());
            finder.addJar(jarFile);
            finder.addJar("cms.ear");
            try {
                String path = ClassesFinder.getFullPathOfJarFileFromResource(directory.getPath());
                logger.debug((Object)("Path of ear File = " + path));
                classNames = finder.getClasses(path, packageName, true);
                logger.debug((Object)("Classes found in " + jarFile + " = " + classNames.toString()));
                for (String string : classNames) {
                    Class<?> c = ClassUtil.loadClass(string);
                    if (c == null) continue;
                    classes.add(c);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                assert (!fileName.contains("."));
                classes.addAll(ClassUtil.findClasses(file, packageName + "." + fileName));
                continue;
            }
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            Class<?> _class = null;
            try {
                _class = ClassUtil.loadClass(packageName + '.' + fileName.substring(0, fileName.length() - 6));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (_class == null) continue;
            classes.add(_class);
        }
        return classes;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> _class = null;
        try {
            _class = Class.forName(className);
        }
        catch (ExceptionInInitializerError e) {
            _class = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        return _class;
    }

    public static boolean isOldJUnitTest(Class<?> c) {
        if (c.getSuperclass().getName().equals("java.lang.Object")) {
            return false;
        }
        if (c.getSuperclass().getName().equals("junit.framework.TestCase")) {
            return true;
        }
        return ClassUtil.isOldJUnitTest(c.getSuperclass());
    }
}

