/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class ClassesFinder {
    private final Logger logger = Logger.getLogger(ClassesFinder.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String[] JAR_EXTENSIONS = new String[]{".zip", ".jar", ".war", ".ear", ".rar"};
    private String classToLookFor = ".class";
    private List<String> jarsToFind = new ArrayList<String>();
    private String packageName;
    private List<String> classes = new ArrayList<String>();

    public void addJar(String jarName) {
        this.jarsToFind.add(jarName.toLowerCase());
    }

    public void setClassToLookFor(String className) {
        this.classToLookFor = className;
    }

    public List<String> getClasses(String path, String packageName, boolean recursive) throws Exception {
        this.classes.clear();
        if (path == null) {
            return this.classes;
        }
        this.packageName = packageName.replace('.', '/');
        File f = new File(path = path.replace(File.separatorChar, '/'));
        if (f.isDirectory()) {
            this.findClassInDirectory(path, this.classToLookFor, recursive);
        } else if (f.isFile() && this.hasJarExtension(path)) {
            ZipInputStream in = new ZipInputStream(new FileInputStream(path));
            this.findClassInJar(in, this.classToLookFor, path, recursive);
            in.close();
        } else if (f.isFile() && path.contains(this.classToLookFor)) {
            this.addClass("", path);
        }
        return this.classes;
    }

    private void findClassInJar(ZipInputStream in, String classToLookFor, String path, boolean recursive) throws Exception {
        ZipEntry next = in.getNextEntry();
        while (next != null) {
            if (!next.isDirectory()) {
                if (next.getName().contains(classToLookFor)) {
                    if (!this.packageName.isEmpty()) {
                        if (next.getName().startsWith(this.packageName)) {
                            this.addClass(path, next.getName());
                        }
                    } else {
                        this.addClass(path, next.getName());
                    }
                } else if (recursive && this.hasJarExtension(next.getName())) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    int n = in.read(buffer, 0, 4096);
                    while (n >= 0) {
                        out.write(buffer, 0, n);
                        n = in.read(buffer, 0, 4096);
                    }
                    ZipInputStream in2 = new ZipInputStream(new ByteArrayInputStream(out.toByteArray()));
                    this.findClassInJar(in2, classToLookFor, path + "/" + next.getName(), recursive);
                    in2.close();
                }
            }
            next = in.getNextEntry();
        }
    }

    private void findClassInDirectory(String dir, String classToLookFor, boolean recursive) throws Exception {
        File d = new File(dir);
        String[] files = d.list();
        for (int i = 0; i < files.length; ++i) {
            String filePath = dir + "/" + files[i];
            File file = new File(filePath);
            if (file.isFile() && filePath.contains(classToLookFor)) {
                int idx = filePath.indexOf(classToLookFor);
                if (!this.packageName.isEmpty()) {
                    if (!filePath.contains(this.packageName)) continue;
                    idx = filePath.indexOf(this.packageName);
                }
                this.addClass(filePath.substring(0, idx), filePath.substring(idx));
                continue;
            }
            if (!recursive) continue;
            if (file.isDirectory()) {
                this.findClassInDirectory(filePath, classToLookFor, recursive);
                continue;
            }
            if (!this.hasJarExtension(filePath)) continue;
            ZipInputStream in = new ZipInputStream(new FileInputStream(file));
            this.findClassInJar(in, classToLookFor, filePath, recursive);
            in.close();
        }
    }

    private boolean hasJarExtension(String fileName) {
        fileName = fileName.toLowerCase();
        for (int i = 0; i < JAR_EXTENSIONS.length; ++i) {
            if (!fileName.endsWith(JAR_EXTENSIONS[i])) continue;
            int ndx = fileName.lastIndexOf(47);
            String jarFile = fileName.substring(ndx + 1);
            return this.jarsToFind.contains(jarFile);
        }
        return false;
    }

    private void addClass(String path, String fileName) {
        String className = fileName.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        this.logger.info((Object)("FOUND CLASS -> " + path + "::" + className));
        this.classes.add(className);
    }

    public static String getTargetJarFileFromResource(String resourceFile) {
        resourceFile = resourceFile.toLowerCase();
        int endIndex = (resourceFile = resourceFile.replace(File.separatorChar, '/')).lastIndexOf(".jar");
        if (endIndex < 0) {
            endIndex = resourceFile.lastIndexOf(".war");
        }
        if (endIndex < 0) {
            return null;
        }
        int beginIndex = (resourceFile = resourceFile.substring(0, endIndex + 4)).lastIndexOf(47);
        if (beginIndex < 0) {
            return null;
        }
        return resourceFile.substring(beginIndex + 1);
    }

    public static String getFullPathOfJarFileFromResource(String resourceFile) {
        int endIndex = (resourceFile = resourceFile.replace(File.separatorChar, '/')).indexOf(".ear");
        if (endIndex < 0) {
            endIndex = resourceFile.indexOf(".jar");
        }
        if (endIndex < 0) {
            endIndex = resourceFile.indexOf(".war");
        }
        if (endIndex < 0) {
            return null;
        }
        int beginIndex = (resourceFile = resourceFile.substring(0, endIndex + 4)).indexOf(47);
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        return resourceFile.substring(beginIndex);
    }
}

