/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.util;

import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailService {
    private static EmailService instance = new EmailService();
    private Properties props;
    private InternetAddress emailFrom;
    private boolean initialized = false;

    private EmailService() {
    }

    public static EmailService getInstance() {
        return instance;
    }

    public void init(Properties props, String emailFrom) throws AddressException {
        this.props = props;
        this.emailFrom = new InternetAddress(emailFrom);
        this.initialized = true;
    }

    public void sendText(String emailsTo, String subject, String messageString) throws Exception {
        if (!this.initialized) {
            throw new Exception("EmailService is not initialized.");
        }
        InternetAddress[] addressTo = this.parseEmailAddress(emailsTo);
        Session session = Session.getInstance((Properties)this.props, null);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)this.emailFrom);
        message.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        message.setSubject(subject);
        message.setText(messageString);
        Transport.send((Message)message);
    }

    public void sendHtml(String emailsTo, String subject, String htmlString) throws Exception {
        if (!this.initialized) {
            throw new Exception("EmailService is not initialized.");
        }
        InternetAddress[] addressTo = this.parseEmailAddress(emailsTo);
        Session session = Session.getInstance((Properties)this.props, null);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)this.emailFrom);
        message.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        message.setSubject(subject);
        message.setContent((Object)htmlString, "text/html");
        Transport.send((Message)message);
    }

    private InternetAddress[] parseEmailAddress(String str) {
        if (str == null) {
            return null;
        }
        String[] tokens = str.split("[;,]");
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        for (String token : tokens) {
            try {
                list.add(new InternetAddress(token.trim()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return list.toArray(new InternetAddress[0]);
    }
}

