/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.wo;

import com.ericsson.cms.test.wo.Creator;
import com.ericsson.cms.test.wo.StatusFinder;
import com.ericsson.cms.test.wo.WOTestResult;
import com.ericsson.cms.test.wo.WorkOrderStatus;
import com.tandbergtv.workflow.message.IMessageKey;
import java.util.Map;
import org.apache.log4j.Logger;

public class WOTester {
    private static final Logger logger = Logger.getLogger(WOTester.class);
    private static final long SLEEP_TIME_MS = 1000L;

    public static WOTestResult test(String templateName, Map<String, String> params, long timeoutSeconds) {
        long timeoutMS = timeoutSeconds * 1000L;
        IMessageKey woRefKey = Creator.create(templateName, params);
        logger.info((Object)("Workorder [" + woRefKey + "] created for template: " + templateName));
        long startTime = System.currentTimeMillis();
        do {
            try {
                String statusStr = StatusFinder.find(woRefKey);
                logger.debug((Object)("Status for " + woRefKey + ": " + statusStr));
                if (statusStr == null || statusStr.trim().isEmpty()) {
                    return new WOTestResult(WOTestResult.Code.FAILURE, "The status [" + statusStr + "] returned by Workflow System for workorder [" + woRefKey + "] is empty.");
                }
                WorkOrderStatus status = WorkOrderStatus.translate(statusStr);
                if (status == WorkOrderStatus.SUCCESS) {
                    return new WOTestResult(WOTestResult.Code.SUCCESS);
                }
                if (status == WorkOrderStatus.ERROR) {
                    return new WOTestResult(WOTestResult.Code.FAILURE, "Workorder [" + woRefKey + "] Failed");
                }
            }
            catch (Exception e) {
                String message = "Unable to get the status of workorder: [" + woRefKey + "]";
                logger.error((Object)message, (Throwable)e);
                return new WOTestResult(WOTestResult.Code.FAILURE, message + " | Reason: " + e.getMessage());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Sleep was interrupted.");
            }
        } while (System.currentTimeMillis() - startTime < timeoutMS);
        return new WOTestResult(WOTestResult.Code.TIMEOUT);
    }
}

