#!/bin/sh
### --------------------------------------------------------------------------
## 		CMS Rules Upgrade Script for linux (gets rid of the Blob) 	 ---------
### --------------------------------------------------------------------------

#INSTALL THE RPM

#ftp the rpm to the server
appserver=10.232.7.33
rpmname=watchpoint-cms-test-2.0.0.0-4.noarch.rpm
scp -i /root/.ssh/id_psa_cmstester /root/rpmbuild/RPMS/noarch/${rpmname} root@${appserver}:/root/${rpmname} 

#install the rpm
ssh -i /root/.ssh/id_psa_cmstester root@${appserver} 'rpm -e watchpoint-cms'
ssh -i /root/.ssh/id_psa_cmstester root@${appserver} 'rpm -e watchpoint-cms-test'
ssh -i /root/.ssh/id_psa_cmstester root@${appserver} 'rpm -ivh /root/'${rpmname}

#change configuration for startup
ssh -i /root/.ssh/id_psa_cmstester root@${appserver} 'sed -i "'"s/-Xmx[0-9]\+m/-Xmx1024m/g"'" /etc/init.d/cms'

#RUN THE CLIENT

if [ "x$JAVA" = "x" ]; then
    if [ "x$JAVA_HOME" != "x" ]; then
	JAVA="$JAVA_HOME/bin/java"
    else
	JAVA="java"
    fi
fi

#echo "  JAVA: $JAVA"

BASEDIR=$(dirname $0)
CRU_JAR_PATH=$BASEDIR/cms_tester.jar
CRU_LIB_PATH=$BASEDIR/lib

CLASSPATH=$CLASSPATH:$CRU_JAR_PATH
CLASSPATH=$CLASSPATH:$CRU_LIB_PATH/*

#echo "  CLASSPATH: $CLASSPATH"

$JAVA -classpath $CLASSPATH com.ericsson.cms.test.client.TestClient $1

