/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.beans.serviceHandlers;

import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngester;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.ttv.acs.stub.adi.ADI;
import com.ttv.acs.stub.adi.ADIParseUtil;
import com.ttv.acs.stub.adi.AbstractWorkOrderRequest;
import com.ttv.acs.stub.adi.Asset;
import com.ttv.acs.stub.adi.IngestWorkOrderRequest;
import com.ttv.acs.stub.adi.PostIngestWorkOrderRequest;
import com.ttv.acs.util.ADIUtil;
import com.ttv.acs.util.ApplicationProperties;
import com.ttv.acs.util.ChecksumUtil;
import com.ttv.acs.util.FileURIConverter;
import com.ttv.acs.util.VirtualFileSystemManager;
import com.ttv.remote.RemoteClientFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs.FileSystemException;
import org.apache.log4j.Logger;

public class LocalContentStoreHandler {
    private static LocalContentStoreHandler instance = null;
    private final Logger log = Logger.getLogger(LocalContentStoreHandler.class);
    private static String DATE_FORMAT = "MM-dd-yyyy";
    private static String TIME_FORMAT = "HHmmssSSS";

    public static synchronized LocalContentStoreHandler getInstance() {
        if (instance == null) {
            instance = new LocalContentStoreHandler();
        }
        return instance;
    }

    public AbstractWorkOrderRequest provisionPackage(String packageName, String URL2) throws Exception {
        this.log.info((Object)("Received provision request for package : " + packageName + ", at URL: " + URL2));
        boolean provisionResult = true;
        ArrayList<String> errorMsgs = new ArrayList<String>();
        String adiXMLFileName = this.getAdiXMLFileName(URL2);
        ADI adi = null;
        try {
            adi = this.getMetadata(packageName, URL2, adiXMLFileName);
        }
        catch (Exception ex) {
            String errMsg = "Failed to retrieve/parse URL: " + URL2;
            this.log.error((Object)errMsg, (Throwable)ex);
            errorMsgs.add(errMsg);
            provisionResult = false;
        }
        String metadataFilePath = URL2;
        if (adi != null) {
            Iterator<Asset> it = adi.getAssets().iterator();
            while (it.hasNext()) {
                Asset asset = it.next();
                boolean acquireResourceResult = true;
                try {
                    this.provisionAsset(asset, adi, metadataFilePath, adiXMLFileName);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    errorMsgs.add(ex.getMessage());
                    provisionResult = false;
                    acquireResourceResult = false;
                    it.remove();
                }
                String destinationStr = asset.getPath();
                if (!ADIUtil.getCheckChecksumFlag() || !acquireResourceResult || this.validateCheckSum(destinationStr, asset.getCheckSum())) continue;
                provisionResult = false;
                errorMsgs.add("Checksum validation failed for content " + asset.getContent());
                it.remove();
            }
            metadataFilePath = adi.getContentStoreDirectoryAbsolutePath() + File.separator + adiXMLFileName;
        }
        if (this.useClassicMode()) {
            return this.constructIngestWorkorderRequest(metadataFilePath, provisionResult, errorMsgs, adi);
        }
        return this.ingestPackageUsingNewMode(adi, metadataFilePath, provisionResult, errorMsgs);
    }

    private AbstractWorkOrderRequest ingestPackageUsingNewMode(ADI adi, String metadataFilePath, boolean provisionResult, List<String> errorMsgs) {
        if (!provisionResult) {
            return this.constructProvisionFailurePostIngestWorkorderRequest(metadataFilePath, adi, errorMsgs);
        }
        try {
            List<TitleValidationMessage> validationMessages;
            ISavedTitle savedTitle = this.ingestPackage(adi, metadataFilePath);
            if (this.sendIngestedEvent()) {
                this.titleIngester().sendIngestedEvent(savedTitle.getTitle().getId());
            }
            if ((validationMessages = this.validateTitle(savedTitle.getTitle())) != null && validationMessages.size() > 0) {
                return this.constructValidationFailurePostIngestWorkorderRequest(metadataFilePath, adi, savedTitle, validationMessages);
            }
            return this.constructSuccessPostIngestWorkorderRequest(savedTitle, metadataFilePath, adi);
        }
        catch (TitleValidationException e) {
            return this.constructValidationFailurePostIngestWorkorderRequest(metadataFilePath, adi, e.getMessage());
        }
        catch (Exception e) {
            return this.constructProvisionFailurePostIngestWorkorderRequest(metadataFilePath, adi, e.getMessage());
        }
    }

    private List<TitleValidationMessage> validateTitle(Title title) throws TitleIngestException {
        return this.titleIngester().validate(title);
    }

    private AbstractWorkOrderRequest constructProvisionFailurePostIngestWorkorderRequest(String metadataFilePath, ADI adi, List<String> errorMsgs) {
        String errorMessage = LocalContentStoreHandler.join(errorMsgs, "\n");
        return this.constructProvisionFailurePostIngestWorkorderRequest(metadataFilePath, adi, errorMessage);
    }

    public static String join(Collection<?> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    private ISavedTitle ingestPackage(ADI adi, String metadataFilePath) throws TitleIngestException, TitleValidationException {
        String packageFolderPath = adi.getContentStoreDirectoryAbsolutePath();
        List<String> assetsNotInPackage = this.findAssetsNotInPackageFolder(adi);
        String providerId = adi.getMetadata().getProviderId();
        String contentClass = this.getConfiguredContentClass();
        ITitleActionSource source = this.newTitleActionSource();
        ISavedTitle savedTitle = this.titleIngester().ingestPackage(metadataFilePath, packageFolderPath, assetsNotInPackage, providerId, contentClass, source);
        return savedTitle;
    }

    private List<String> findAssetsNotInPackageFolder(ADI adi) {
        ArrayList<String> assetsNotInPackage = new ArrayList<String>();
        for (Asset asset : adi.getAssets()) {
            if (!this.assetWasAlreadyOnServer(asset)) continue;
            assetsNotInPackage.add(asset.getPath());
        }
        return assetsNotInPackage;
    }

    private boolean assetWasAlreadyOnServer(Asset asset) {
        return asset.hasFileURI();
    }

    private AbstractWorkOrderRequest constructProvisionFailurePostIngestWorkorderRequest(String metadataFilePath, ADI adi, String errorMessage) {
        String packageAssetId = this.getPackageAssetIdFromADI(adi);
        String providerId = this.getProviderIdFromADI(adi);
        return new PostIngestWorkOrderRequest(null, null, metadataFilePath, false, errorMessage, true, null, packageAssetId, providerId);
    }

    private AbstractWorkOrderRequest constructValidationFailurePostIngestWorkorderRequest(String metadataFilePath, ADI adi, ISavedTitle savedTitle, List<TitleValidationMessage> validationMessages) {
        Long titleId = this.getTitleId(savedTitle);
        String titleStatus = this.getTitleStatus(savedTitle);
        String validationMessage = this.joinValidationMessages(validationMessages);
        String packageAssetId = this.getPackageAssetIdFromADI(adi);
        String providerId = this.getProviderIdFromADI(adi);
        return new PostIngestWorkOrderRequest(titleId, titleStatus, metadataFilePath, true, null, false, validationMessage, packageAssetId, providerId);
    }

    private String joinValidationMessages(List<TitleValidationMessage> validationMessages) {
        ArrayList<String> strMessages = new ArrayList<String>();
        for (TitleValidationMessage m : validationMessages) {
            strMessages.add(m.getMessage());
        }
        return LocalContentStoreHandler.join(strMessages, "\n");
    }

    private AbstractWorkOrderRequest constructValidationFailurePostIngestWorkorderRequest(String metadataFilePath, ADI adi, String validationMessages) {
        String packageAssetId = this.getPackageAssetIdFromADI(adi);
        String providerId = this.getProviderIdFromADI(adi);
        return new PostIngestWorkOrderRequest(null, null, metadataFilePath, true, null, false, validationMessages, packageAssetId, providerId);
    }

    private Long getTitleId(ISavedTitle savedTitle) {
        if (savedTitle == null || savedTitle.getTitle() == null) {
            return null;
        }
        return savedTitle.getTitle().getId();
    }

    private String getTitleStatus(ISavedTitle savedTitle) {
        if (savedTitle == null || savedTitle.getTitle() == null || savedTitle.getTitle().getStatus() == null) {
            return null;
        }
        return savedTitle.getTitle().getStatus().toString();
    }

    private String getProviderIdFromADI(ADI adi) {
        String providerId;
        try {
            providerId = adi.getMetadata().getProviderId();
        }
        catch (Exception e) {
            providerId = null;
        }
        return providerId;
    }

    private String getPackageAssetIdFromADI(ADI adi) {
        String packageAssetId;
        try {
            packageAssetId = adi.getMetadata().getAssetId();
        }
        catch (Exception e) {
            packageAssetId = null;
        }
        return packageAssetId;
    }

    private AbstractWorkOrderRequest constructSuccessPostIngestWorkorderRequest(ISavedTitle savedTitle, String metadataFilePath, ADI adi) {
        Long titleId = savedTitle.getTitle().getId();
        String titleStatus = this.getTitleStatus(savedTitle);
        String packageAssetId = this.getPackageAssetIdFromADI(adi);
        String providerId = this.getProviderIdFromADI(adi);
        return new PostIngestWorkOrderRequest(titleId, titleStatus, metadataFilePath, true, null, true, null, packageAssetId, providerId);
    }

    private ITitleActionSource newTitleActionSource() {
        return new TitleActionSource("Content Management", "ADI Server", "ADI Server");
    }

    private ITitleIngester titleIngester() throws TitleIngestException {
        try {
            return RemoteClientFactory.newTitleIngester();
        }
        catch (Exception e) {
            throw new TitleIngestException("It wasn't possible to retrieve the remote TitleIngester.", (Throwable)e);
        }
    }

    private synchronized ADI getMetadata(String packageName, String URL2, CharSequence adiXMLFileName) throws Exception {
        File xmlTempFile = File.createTempFile("ADI", ".XML");
        File dtdTempFile = File.createTempFile("ADI", ".DTD");
        URI sourceURI = new URI(URL2);
        URI destinationURI = xmlTempFile.toURI();
        this.acquireResource(sourceURI, destinationURI);
        sourceURI = new URI(URL2.replace(adiXMLFileName, "ADI.DTD"));
        destinationURI = dtdTempFile.toURI();
        this.acquireResource(sourceURI, destinationURI);
        ADI adi = ADIParseUtil.parseFile(xmlTempFile, dtdTempFile);
        File contentStoreDirectoryPath = new File(this.getContentStoreAbsolutePath() + File.separator + adi.getMetadata().getProviderId() + File.separator + new SimpleDateFormat(DATE_FORMAT).format(new Date()) + File.separator + new SimpleDateFormat(TIME_FORMAT).format(new Date()) + File.separator + adi.getMetadata().getAssetId());
        if (!this.getVFS().localStorageDirectoryIsReady(contentStoreDirectoryPath.getAbsolutePath())) {
            String errorString = "Failed to create content store path: " + contentStoreDirectoryPath.getAbsolutePath();
            this.log.error((Object)errorString);
            throw new Exception(errorString);
        }
        adi.setContentStoreDirectoryAbsolutePath(contentStoreDirectoryPath.getAbsolutePath());
        sourceURI = xmlTempFile.toURI();
        destinationURI = new File(contentStoreDirectoryPath.getAbsolutePath() + File.separator + adiXMLFileName).toURI();
        this.acquireResource(sourceURI, destinationURI);
        sourceURI = dtdTempFile.toURI();
        destinationURI = new File(contentStoreDirectoryPath.getAbsolutePath() + File.separator + "ADI.DTD").toURI();
        this.acquireResource(sourceURI, destinationURI);
        if (!xmlTempFile.delete()) {
            xmlTempFile.deleteOnExit();
        }
        if (!dtdTempFile.delete()) {
            dtdTempFile.deleteOnExit();
        }
        return adi;
    }

    private String getAdiXMLFileName(String url) {
        return url.substring(url.length() - 7);
    }

    private AbstractWorkOrderRequest constructIngestWorkorderRequest(String metadataFilePath, boolean provisionResult, List<String> errorMsgs, ADI adi) {
        return new IngestWorkOrderRequest(metadataFilePath, provisionResult, errorMsgs, adi);
    }

    private boolean validateCheckSum(String contentFilePath, String checkSum) throws NoSuchAlgorithmException, IOException {
        String newChecksum = ChecksumUtil.getCheckSum(contentFilePath);
        boolean validateResult = checkSum.equals(newChecksum);
        if (!validateResult) {
            this.log.error((Object)("Checksum validation failed for file: " + contentFilePath));
            File contentFile = new File(contentFilePath);
            boolean deleteResult = contentFile.delete();
            if (!deleteResult) {
                this.log.error((Object)("Failed to delete content file " + contentFilePath));
            }
        }
        return validateResult;
    }

    public void acquireResource(URI source, URI destination) throws Exception {
        this.log.debug((Object)("Source resource: " + source.toString()));
        this.log.debug((Object)("Destination resource: " + destination.toString()));
        try {
            this.getVFS().copyURI(source, destination);
        }
        catch (FileSystemException fse) {
            String errorString = "Failed to copy sourcefile: " + source.toString() + " from remote system.";
            this.log.error((Object)errorString, (Throwable)fse);
            throw new Exception(errorString);
        }
        catch (IOException ioe) {
            String errorString = "Failed to copy sourcefile: " + source.toString() + " from remote system.";
            this.log.error((Object)errorString, (Throwable)ioe);
            throw new Exception(errorString);
        }
        catch (Exception e) {
            String errorString = "Failed to copy sourcefile: " + source.toString() + " from remote system.";
            this.log.error((Object)errorString, (Throwable)e);
            throw new Exception(errorString);
        }
    }

    public String getContentStoreAbsolutePath() {
        return this.getConfigurationProperty("ACS_CONTENTSTORE", "/content");
    }

    private void initializeContentStore() {
        VirtualFileSystemManager vfs = this.getVFS();
        if (!vfs.localStorageDirectoryIsReady(this.getContentStoreAbsolutePath())) {
            this.log.error((Object)"Failed to create content store directory structure.", null);
        }
    }

    private VirtualFileSystemManager getVFS() {
        return new VirtualFileSystemManager();
    }

    private LocalContentStoreHandler() {
        this.initializeContentStore();
    }

    private void provisionAsset(Asset asset, ADI adi, String metadataFilePath, String metadataFileName) throws Exception {
        if (asset.hasFileURI()) {
            this.provisionAssetWithFileURI(asset, adi);
        } else {
            this.provisionAssetWithFTPURI(asset, adi, metadataFilePath, metadataFileName);
        }
    }

    private void provisionAssetWithFileURI(Asset asset, ADI adi) throws Exception {
        String content = asset.getContent();
        this.log.debug((Object)("Processing content :" + content));
        String contentPath = new FileURIConverter().convertURIToUnix(content);
        this.log.debug((Object)("Converted path :" + contentPath));
        if (contentPath == null) {
            asset.setPath(content);
            this.log.error((Object)("[Configuration Error] " + content + " fileURIConverter.properties cannot find converter entry for " + content));
            throw new Exception("Fail to convert URI:" + content);
        }
        asset.setPath(contentPath);
    }

    private void provisionAssetWithFTPURI(Asset asset, ADI adi, String metadataFilePath, String metadataFileName) throws Exception {
        String content = asset.getContent();
        this.log.debug((Object)("Processing content :" + content));
        URI sourceURI = null;
        URI destinationURI = null;
        if (asset.hasFTPURI()) {
            sourceURI = new URI(content);
            String path = sourceURI.getPath();
            String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
            destinationURI = new URI(adi.getContentStoreDirectoryAbsolutePath() + File.separator + fileName);
            asset.setPath(destinationURI.getPath());
        } else {
            destinationURI = new URI(adi.getContentStoreDirectoryAbsolutePath() + File.separator + content);
            asset.setPath(destinationURI.getPath());
            sourceURI = new URI(metadataFilePath.replace(metadataFileName, content));
        }
        try {
            this.acquireResource(sourceURI, destinationURI);
        }
        catch (Exception ex) {
            String errMsg = "Failed to acquire content: " + sourceURI.toString();
            throw new Exception(errMsg, ex);
        }
    }

    private boolean useClassicMode() {
        String useClassicIngestMode = this.getConfigurationProperty("USE_CLASSIC_INGEST_MODE", Boolean.TRUE.toString());
        return useClassicIngestMode.toLowerCase().equals(Boolean.TRUE.toString());
    }

    private boolean sendIngestedEvent() {
        String useClassicIngestMode = this.getConfigurationProperty("SEND_INGESTED_EVENT", Boolean.FALSE.toString());
        return useClassicIngestMode.toLowerCase().equals(Boolean.TRUE.toString());
    }

    private String getConfiguredContentClass() {
        return this.getConfigurationProperty("CONTENT_CLASS", null);
    }

    private String getConfigurationProperty(String propertyName, String propertyDefault) {
        try {
            return ApplicationProperties.getInstance().getProperty(propertyName, propertyDefault);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to get property " + propertyName), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

