/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.jmx;

import com.ttv.acs.jmx.PackageFactoryService;
import com.ttv.acs.util.ADIUtil;
import com.twc.isa.PackageModule.PackageFactory;
import com.twc.isa.PackageModule.PackageFactory_impl;
import com.twc.isa.ServerModule.ServantBase_impl;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Management;
import org.jboss.ejb3.annotation.Service;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

@Service(objectName="acs:service=PackageFactoryServiceMBean")
@Management(value=PackageFactoryService.class)
public class PackageFactoryServiceMBean
implements PackageFactoryService {
    private final Logger log = Logger.getLogger(PackageFactoryServiceMBean.class);
    private PackageFactoryControl packageFactoryControl = null;

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() throws Exception {
        this.log.info((java.lang.Object)"Starting Package Factory.");
        this.startPackageFactoryService();
    }

    @Override
    public void stop() {
        this.log.info((java.lang.Object)"Stopping PackageFactory.");
        this.stopPackageFactoryService();
    }

    @Override
    public void unbindPackageFactoryService() {
        if (this.packageFactoryControl != null) {
            this.packageFactoryControl.unbindPackageFactory();
        }
    }

    @Override
    public void rebindPackageFactoryService() {
        if (this.packageFactoryControl != null) {
            this.packageFactoryControl.rebindPackageFactory();
        }
    }

    private void startPackageFactoryService() {
        if (this.packageFactoryControl == null) {
            this.packageFactoryControl = new PackageFactoryControl();
            this.packageFactoryControl.start();
        } else {
            this.log.debug((java.lang.Object)"PackageFactory already running.");
        }
    }

    private void stopPackageFactoryService() {
        if (this.packageFactoryControl != null) {
            this.packageFactoryControl.stopPackageFactory();
            this.log.debug((java.lang.Object)"PackageFactory signalled.");
        }
    }

    private class PackageFactoryControl
    extends Thread {
        private boolean stop = false;
        private ORB orb = null;
        private PackageFactory_impl factoryImpl = null;
        private PackageFactory factory = null;
        private String[] serverPath = new String[]{"Factories", "PackageFactory"};

        private PackageFactoryControl() {
        }

        public void stopPackageFactory() {
            this.stop = true;
            try {
                this.orb.shutdown(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void rebindPackageFactory() {
            PackageFactoryServiceMBean.this.log.debug((java.lang.Object)("orb = " + this.orb));
            PackageFactoryServiceMBean.this.log.debug((java.lang.Object)("serverPath = " + this.serverPath));
            PackageFactoryServiceMBean.this.log.debug((java.lang.Object)("factory = " + this.factory));
            ServantBase_impl.setFactoryObject(this.orb, this.serverPath, (Object)this.factory);
        }

        public void unbindPackageFactory() {
            NamingContextExt ctx = ServantBase_impl.createNamingContext(this.orb, this.serverPath, this.serverPath.length - 1);
            try {
                NameComponent[] nameComp = new NameComponent[]{new NameComponent(this.serverPath[this.serverPath.length - 1], "Factory")};
                ctx.unbind(nameComp);
                PackageFactoryServiceMBean.this.log.debug((java.lang.Object)"PackageFactory unbound from NamingContext.");
            }
            catch (Exception ex) {
                PackageFactoryServiceMBean.this.log.error((java.lang.Object)"Failed to locate Name Server", (Throwable)ex);
            }
        }

        @Override
        public void run() {
            while (!this.stop) {
                if (ADIUtil.getNameServerAddress() == null || ADIUtil.getNameServerAddress().length() == 0) {
                    PackageFactoryServiceMBean.this.log.error((java.lang.Object)"--------------------------------------------------------------------------");
                    PackageFactoryServiceMBean.this.log.error((java.lang.Object)"Local NameServer CORBALOC not configured. PackageFactory startup deferred.");
                    PackageFactoryServiceMBean.this.log.error((java.lang.Object)"--------------------------------------------------------------------------");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ignore) {}
                    continue;
                }
                try {
                    this.startPackageFactory();
                }
                catch (InterruptedException ie) {
                    if (!this.stop) {
                        PackageFactoryServiceMBean.this.log.error((java.lang.Object)"PackageFactory caught InterruptedException. Restart scheduled.");
                    } else {
                        PackageFactoryServiceMBean.this.log.error((java.lang.Object)"PackageFactory Shutdown complete.");
                    }
                }
                catch (Exception e) {
                    PackageFactoryServiceMBean.this.log.error((java.lang.Object)"PackageFactory caught unexpected exception. Restart scheduled.", (Throwable)e);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
            PackageFactoryServiceMBean.this.log.debug((java.lang.Object)"PackageFactory shutdown complete.");
        }

        private void startPackageFactory() throws InterruptedException, Exception {
            this.orb = ORB.init((String[])this.getOrbMainArgs(), (Properties)this.getProperties());
            POA rootPOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            POAManager manager = rootPOA.the_POAManager();
            manager.activate();
            this.factoryImpl = new PackageFactory_impl(this.orb, "PackageFactory");
            this.factory = this.factoryImpl._this(this.orb);
            this.factoryImpl.base.setFullPath(this.serverPath);
            this.rebindPackageFactory();
            manager.activate();
            PackageFactoryServiceMBean.this.log.info((java.lang.Object)("Bound PackageFactory to ior:" + this.factory.toString()));
            this.orb.run();
        }

        private String[] getOrbMainArgs() {
            String[] args = new String[]{"-ORBInitRef", "NameService=" + ADIUtil.getNameServerAddress()};
            return args;
        }

        private Properties getProperties() {
            Properties p = new Properties();
            p.put("OAPort", ADIUtil.getPackageFactoryPort());
            return p;
        }
    }
}

