/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.stub.adi;

import com.tandbergtv.workflow.message.WorkflowPayload;
import com.ttv.acs.stub.adi.ADI;
import com.ttv.acs.stub.adi.AbstractWorkOrderRequest;
import com.ttv.acs.stub.adi.Asset;
import java.util.List;

public class IngestWorkOrderRequest
extends AbstractWorkOrderRequest {
    private static final String MESSAGE_UID = "AD0101";
    private String metadataFilePath = "";
    private String assetFileNames = "";
    private String success = "";
    private String message = "";
    private String packageAssetID = "";
    private String providerId = "";

    public IngestWorkOrderRequest() {
        super(MESSAGE_UID);
    }

    public IngestWorkOrderRequest(String metadataFilePath, boolean provisionResult, List<String> provisionErrorMsgs, ADI adi) {
        super(MESSAGE_UID);
        this.metadataFilePath = metadataFilePath;
        this.setProvisionResult(provisionResult);
        if (provisionErrorMsgs != null) {
            StringBuffer errorMsgSB = new StringBuffer();
            for (String error : provisionErrorMsgs) {
                errorMsgSB.append(error + ";");
            }
            if (errorMsgSB.length() > 0) {
                this.message = errorMsgSB.substring(0, errorMsgSB.length() - 1);
            }
        }
        this.setADI(adi);
    }

    public IngestWorkOrderRequest(String metadataFilePath, boolean provisionResult, String provisionErrorMsgs, ADI adi) {
        super(MESSAGE_UID);
        this.metadataFilePath = metadataFilePath;
        this.setProvisionResult(provisionResult);
        this.setMessage(provisionErrorMsgs);
        this.setADI(adi);
    }

    public IngestWorkOrderRequest(String contentUrl, Exception e) {
        super(MESSAGE_UID);
        this.setProvisionResult(false);
        this.setMessage("Exception throwed when provisioning for file: " + contentUrl + ". Exception thrown: " + e.getMessage());
    }

    public void setProvisionResult(boolean provisionResult) {
        this.success = provisionResult ? "true" : "false";
    }

    public void setADI(ADI adi) {
        if (adi == null) {
            return;
        }
        if (adi.getAssets() != null) {
            StringBuffer assetFileNamesSB = new StringBuffer();
            for (Asset asset : adi.getAssets()) {
                assetFileNamesSB.append(asset.getPath() + ",");
            }
            if (assetFileNamesSB.length() > 0) {
                this.assetFileNames = assetFileNamesSB.substring(0, assetFileNamesSB.length() - 1);
            }
        }
        if (adi.getMetadata() != null) {
            this.packageAssetID = adi.getMetadata().getAssetId();
            this.providerId = adi.getMetadata().getProviderId();
        }
    }

    public String getMetadataFilePath() {
        return this.metadataFilePath;
    }

    public void setMetadataFilePath(String metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
    }

    public String getAssetFileNames() {
        return this.assetFileNames;
    }

    public void setAssetFileNames(String assetFileNames) {
        this.assetFileNames = assetFileNames;
    }

    @Override
    public String getSuccess() {
        return this.success;
    }

    public void setSuccess(String success) {
        this.success = success;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPackageAssetID() {
        return this.packageAssetID;
    }

    public void setPackageAssetID(String packageAssetID) {
        this.packageAssetID = packageAssetID;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("metadataFilePath: " + this.metadataFilePath + "\n");
        result.append("assetFileNames: " + this.assetFileNames + "\n");
        result.append("success: " + this.success + "\n");
        result.append("message: " + this.message + "\n");
        result.append("packageAssetID: " + this.packageAssetID + "\n");
        result.append("providerId: " + this.providerId + "\n");
        return result.toString();
    }

    @Override
    public void populatePayload(WorkflowPayload payload) {
        payload.putValue("metadataFilePath", this.getMetadataFilePath());
        payload.putValue("assetFileNames", this.getAssetFileNames());
        payload.putValue("success", this.getSuccess());
        payload.putValue("message", this.getMessage());
        payload.putValue("packageAssetId", this.getPackageAssetID());
        payload.putValue("providerId", this.getProviderId());
    }

    @Override
    public boolean succeeded() {
        return "true".equals(this.getSuccess());
    }

    @Override
    public String getMessageUID() {
        return MESSAGE_UID;
    }
}

