/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileURIConverter {
    private Map<String, String> fileURIPathMap = new HashMap<String, String>();
    private Map<String, String> mountMap = new HashMap<String, String>();
    private static final String RESOURCE_PATH = "/fileURIConverter.properties";
    private static Logger logger = Logger.getLogger(FileURIConverter.class);

    public FileURIConverter() {
        this.loadPathConfiguration();
    }

    private synchronized void loadPathConfiguration() {
        this.mountMap.clear();
        this.fileURIPathMap.clear();
        try {
            InputStream stream = this.getClass().getResourceAsStream(RESOURCE_PATH);
            Properties config = new Properties();
            config.load(stream);
            for (Object keyObject : config.keySet()) {
                String mountPath = ((String)keyObject).trim();
                String fileURI = config.getProperty(mountPath).trim();
                logger.debug((Object)(mountPath + " = " + fileURI));
                this.mountMap.put(mountPath, fileURI);
                this.fileURIPathMap.put(fileURI, mountPath);
            }
        }
        catch (IOException e) {
            String msg = "Failed to load the Path configuration file: /fileURIConverter.properties";
            throw new RuntimeException(msg, e);
        }
    }

    public String convertURIToUnix(String uri) {
        if (uri == null) {
            return null;
        }
        String unixPath = this.replacePath(uri, true);
        return unixPath;
    }

    public String convertUnixToURI(String unixPath) {
        if (unixPath == null) {
            return null;
        }
        String uriPath = this.replacePath(unixPath, false);
        return uriPath;
    }

    private String replacePath(String path, boolean isURIPath) {
        StringBuffer sb = new StringBuffer(path.trim());
        Map<String, String> pathMap = isURIPath ? this.fileURIPathMap : this.mountMap;
        for (String mappedPath : pathMap.keySet()) {
            if (!path.startsWith(mappedPath)) continue;
            sb.replace(0, mappedPath.length(), pathMap.get(mappedPath));
            return sb.toString();
        }
        return null;
    }
}

