/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.log4j.Logger;

public class VirtualFileSystemManager {
    private final Logger log = Logger.getLogger(VirtualFileSystemManager.class);
    private FileSystemManager fileSystemManager = null;

    public URI getURIWithDefaultPrefix(String defaultPrefix, String base) throws URISyntaxException {
        try {
            return new URI(base);
        }
        catch (URISyntaxException e) {
            return new URI(defaultPrefix + base);
        }
    }

    public FileSystemManager getVFSManager() throws FileSystemException {
        if (this.fileSystemManager == null) {
            this.fileSystemManager = VirtualFileSystemManager.createManager("org.apache.commons.vfs.impl.StandardFileSystemManager");
        }
        return this.fileSystemManager;
    }

    public void resetVFSManager() {
        this.fileSystemManager = null;
    }

    private static FileSystemManager createManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> mgrClass = Class.forName(managerClassName);
            FileSystemManager mgr = (FileSystemManager)mgrClass.newInstance();
            try {
                Method initMethod = mgrClass.getMethod("init", new Class[0]);
                initMethod.invoke((Object)mgr, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return mgr;
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, e.getTargetException());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, (Throwable)e);
        }
    }

    public InputStream getInputStream(String uriString) throws FileSystemException {
        return this.resolveFile(uriString).getContent().getInputStream();
    }

    public OutputStream getOutputStream(String uriString) throws FileSystemException {
        return this.resolveFile(uriString).getContent().getOutputStream();
    }

    public FileObject resolveFile(String uriString) throws FileSystemException {
        return this.getVFSManager().resolveFile(uriString);
    }

    public boolean localStorageDirectoryExists(String dirString) throws FileSystemException {
        FileObject dir = this.getVFSManager().resolveFile(dirString);
        return dir.exists();
    }

    public void killLocalDirectory(String dirString) throws FileSystemException {
        FileObject dir = this.getVFSManager().resolveFile(dirString);
        FileObject[] files = dir.getChildren();
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
        dir.delete();
    }

    public void copyURI(URI fromURI, URI toURI) throws FileSystemException, IOException {
        InputStream instream = null;
        OutputStream outstream = null;
        this.log.info((Object)("copyURI from=" + fromURI.toString() + ";to=" + toURI));
        try {
            FileSystemManager fsManager = this.getVFSManager();
            FileObject fo_in = fsManager.resolveFile(fromURI.toString());
            outstream = fsManager.resolveFile(toURI.toString()).getContent().getOutputStream();
            if (fo_in.getURL().getProtocol().equals("ftp")) {
                this.doFtp(fromURI, outstream);
            } else {
                instream = fo_in.getContent().getInputStream();
                int bytesRead = 0;
                byte[] buffer = new byte[4096];
                while ((bytesRead = instream.read(buffer)) != -1) {
                    if (bytesRead <= 0) continue;
                    outstream.write(buffer, 0, bytesRead);
                }
            }
        }
        catch (FileSystemException e) {
            this.log.error((Object)e);
            throw e;
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw e;
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException ioe) {
                    this.log.error((Object)ioe);
                }
            }
            if (outstream != null) {
                try {
                    outstream.close();
                }
                catch (IOException ioe) {
                    this.log.error((Object)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFtp(URI uri, OutputStream outstream) throws IOException {
        String userinfo = uri.getUserInfo();
        String username = VirtualFileSystemManager.getUserName(userinfo);
        String password = VirtualFileSystemManager.getPassword(userinfo);
        FTPClient ftpClient = null;
        try {
            ftpClient = new FTPClient();
            ftpClient.setRemoteVerificationEnabled(false);
            ftpClient.connect(uri.getHost());
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                ftpClient.disconnect();
                this.log.error((Object)"FTP server refused connection.");
                throw new IOException("FTP server refused connection.");
            }
            if (!ftpClient.login(username, password)) {
                ftpClient.logout();
            }
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            String remotePath = uri.getPath();
            boolean isRetrievingSuccess = ftpClient.retrieveFile(remotePath, outstream);
            if (!isRetrievingSuccess) {
                throw new IOException("Failed to retrieve file: " + remotePath + " via FTP.");
            }
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException ignore) {}
            }
        }
    }

    static String getUserName(String userinfo) {
        String username = null;
        String defaultusername = "anonymous";
        int colonindex = -1;
        username = userinfo == null || (colonindex = userinfo.indexOf(58)) == -1 ? defaultusername : userinfo.substring(0, colonindex);
        return username;
    }

    static String getPassword(String userinfo) {
        String password = null;
        String defaultpassword = "ads123";
        int colonindex = -1;
        password = userinfo == null || (colonindex = userinfo.indexOf(58)) == -1 ? defaultpassword : userinfo.substring(colonindex + 1, userinfo.length());
        return password;
    }

    public boolean localStorageDirectoryIsReady(String dirString) {
        try {
            FileObject dir = this.getVFSManager().resolveFile(dirString);
            this.log.debug((Object)("entering localStorageDirectoryIsReady for dir = " + dirString));
            if (dir.exists()) {
                this.log.debug((Object)("directory already exists " + dir.toString() + " for " + dirString));
            } else {
                try {
                    dir.createFolder();
                }
                catch (Exception e) {
                    this.log.error((Object)("failed to create storage directory " + dir.toString() + " for " + dirString));
                    return false;
                }
            }
            return dir.isWriteable();
        }
        catch (FileSystemException e) {
            this.log.error((Object)"failed in localStorageDirectoryIsReady ", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)"failed in localStorageDirectoryIsReady ", (Throwable)e);
            return false;
        }
    }
}

