/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.acs.util;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.ttv.acs.stub.adi.AbstractWorkOrderRequest;
import com.ttv.acs.util.ADIUtil;
import com.ttv.acs.util.ApplicationProperties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WorkflowAdaptor {
    private Logger logger = Logger.getLogger(WorkflowAdaptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyWorkFlow(AbstractWorkOrderRequest workOrderRequest) {
        boolean notifyResult = true;
        SOAPConnection connection = null;
        try {
            Document notificationReqDoc = this.prepareIngestMessage(workOrderRequest);
            String destinationUrl = this.getDestinationURL();
            this.logger.debug((Object)("Making SOAP call to " + destinationUrl));
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            MimeHeaders headers = message.getMimeHeaders();
            headers.addHeader("SOAPAction", "");
            SOAPBody requestBody = message.getSOAPBody();
            requestBody.addDocument(notificationReqDoc);
            connection = SOAPConnectionFactory.newInstance().createConnection();
            SOAPMessage reply = connection.call(message, (Object)destinationUrl);
            notifyResult = this.parseWorkflowResponse(reply);
        }
        catch (Exception e) {
            notifyResult = false;
            this.logger.error((Object)("Error sending message - " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SOAPException e) {
                    this.logger.error((Object)("Failed to close SOAPConnection - " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return notifyResult;
    }

    private boolean parseWorkflowResponse(SOAPMessage reply) {
        boolean reqResult = true;
        try {
            SOAPBody body = reply.getSOAPBody();
            if (body.getFault() != null) {
                SOAPFault fault = body.getFault();
                throw new SOAPException("Got a soap fault in the response: " + fault.getFaultString());
            }
            Node wfsMessage = body.getFirstChild();
            System.out.println(wfsMessage);
            WorkflowMessage response = Unmarshaller.unmarshal((Document)this.convertNodeToNewDocument(wfsMessage));
            this.logger.debug((Object)("Workflow response:" + response.getType()));
            if (WorkflowMessage.MessageType.nack.equals((Object)response.getType())) {
                reqResult = false;
            }
        }
        catch (Exception e) {
            reqResult = false;
            this.logger.error((Object)"Failed to parse SOAP response from WorkFlow", (Throwable)e);
        }
        return reqResult;
    }

    private Document convertNodeToNewDocument(Node wfsMessage) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer xf = tf.newTransformer();
        DOMResult dr = new DOMResult();
        xf.transform(new DOMSource(wfsMessage), dr);
        Document newDoc = (Document)dr.getNode();
        return newDoc;
    }

    private Document prepareIngestMessage(AbstractWorkOrderRequest workOrderRequest) {
        WorkflowMessage notificationReq = new WorkflowMessage((IMessageUID)new MessageUIDImpl(workOrderRequest.getMessageUID()));
        notificationReq.setType(WorkflowMessage.MessageType.notification);
        WorkflowPayload payload = notificationReq.getPayload();
        this.populatePayload(payload, workOrderRequest);
        notificationReq.setSource((ISource)new HTTPDevice(ADIUtil.getNameServerAddress()));
        try {
            return Marshaller.newMarshaller().marshal(notificationReq);
        }
        catch (MarshalException e) {
            this.logger.error((Object)("Failed to marshal notificationReq obj: " + notificationReq + ". Error: " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    private String getDestinationURL() {
        try {
            return ApplicationProperties.getInstance().getProperty("WORKFLOW_WEBSERVICE_UTL", "http://localhost:8080/workflow/services/AdaptorService");
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to get property WORKFLOW_WEBSERVICE_UTL", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void populatePayload(WorkflowPayload payload, AbstractWorkOrderRequest workOrderRequest) {
        workOrderRequest.populatePayload(payload);
    }
}

