/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.remote;

import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngester;
import com.ttv.acs.util.ApplicationProperties;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RemoteClientFactory {
    public static ITitleIngester newTitleIngester() throws NamingException, InvalidPropertiesFormatException, IOException {
        String remoteAddress = ApplicationProperties.getInstance().getProperty("TITLE_INGESTER_REMOTE_ADDRESS");
        String remoteName = ApplicationProperties.getInstance().getProperty("TITLE_INGESTER_REMOTE_NAME");
        InitialContext context = RemoteClientFactory.getInitialContext(remoteAddress);
        Object proxy = context.lookup(remoteName);
        return (ITitleIngester)proxy;
    }

    private static InitialContext getInitialContext(String remoteAddress) throws NamingException {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        properties.put("java.naming.provider.url", remoteAddress);
        InitialContext context = new InitialContext(properties);
        return context;
    }
}

