/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.DefaultFileReplicator;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandardFileSystemManager
extends DefaultFileSystemManager {
    private static final String CONFIG_RESOURCE = "providers.xml";
    private String configUri;
    private ClassLoader classLoader;

    public void setConfiguration(String configUri) {
        this.configUri = configUri;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void init() throws FileSystemException {
        DefaultFileReplicator replicator = new DefaultFileReplicator();
        this.setReplicator(new PrivilegedFileReplicator(replicator));
        this.setTemporaryFileStore(replicator);
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        if (this.configUri == null) {
            URL url = this.getClass().getResource(CONFIG_RESOURCE);
            if (url == null) {
                throw new FileSystemException("vfs.impl/find-config-file.error", CONFIG_RESOURCE);
            }
            this.configUri = url.toExternalForm();
        }
        this.configure(this.configUri);
        super.init();
    }

    private void configure(String configUri) throws FileSystemException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setExpandEntityReferences(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Element config = builder.parse(configUri).getDocumentElement();
            NodeList providers = config.getElementsByTagName("provider");
            int count = providers.getLength();
            int i = 0;
            while (i < count) {
                Element provider = (Element)providers.item(i);
                this.addProvider(provider, false);
                ++i;
            }
            NodeList defProviders = config.getElementsByTagName("default-provider");
            if (defProviders.getLength() > 0) {
                Element provider = (Element)defProviders.item(0);
                this.addProvider(provider, true);
            }
            NodeList mimeTypes = config.getElementsByTagName("mime-type-map");
            int i2 = 0;
            while (i2 < mimeTypes.getLength()) {
                Element map = (Element)mimeTypes.item(i2);
                this.addMimeTypeMap(map);
                ++i2;
            }
            NodeList extensions = config.getElementsByTagName("extension-map");
            int i3 = 0;
            while (i3 < extensions.getLength()) {
                Element map = (Element)extensions.item(i3);
                this.addExtensionMap(map);
                ++i3;
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", configUri, (Throwable)e);
        }
    }

    private void addExtensionMap(Element map) {
        String extension = map.getAttribute("extension");
        String scheme = map.getAttribute("scheme");
        this.addExtensionMap(extension, scheme);
    }

    private void addMimeTypeMap(Element map) {
        String mimeType = map.getAttribute("mime-type");
        String scheme = map.getAttribute("scheme");
        this.addMimeTypeMap(mimeType, scheme);
    }

    private void addProvider(Element providerDef, boolean isDefault) throws FileSystemException {
        String classname = providerDef.getAttribute("class-name");
        String[] requiredClasses = this.getRequiredClasses(providerDef);
        int i = 0;
        while (i < requiredClasses.length) {
            String requiredClass = requiredClasses[i];
            if (!this.findClass(requiredClass)) {
                String msg = Messages.getString("vfs.impl/skipping-provider.warn", new String[]{classname, requiredClass});
                this.getLog().warn((Object)msg);
                return;
            }
            ++i;
        }
        FileProvider provider = this.createProvider(classname);
        String[] schemas = this.getSchemas(providerDef);
        if (schemas.length > 0) {
            this.addProvider(schemas, provider);
        }
        if (isDefault) {
            this.setDefaultProvider(provider);
        }
    }

    private boolean findClass(String className) {
        try {
            this.classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String[] getRequiredClasses(Element providerDef) {
        ArrayList<String> classes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        int i = 0;
        while (i < count) {
            Element dep = (Element)deps.item(i);
            classes.add(dep.getAttribute("class-name"));
            ++i;
        }
        return classes.toArray(new String[classes.size()]);
    }

    private String[] getSchemas(Element provider) {
        ArrayList<String> schemas = new ArrayList<String>();
        NodeList schemaElements = provider.getElementsByTagName("scheme");
        int count = schemaElements.getLength();
        int i = 0;
        while (i < count) {
            Element scheme = (Element)schemaElements.item(i);
            schemas.add(scheme.getAttribute("name"));
            ++i;
        }
        return schemas.toArray(new String[schemas.size()]);
    }

    private FileProvider createProvider(String providerClassName) throws FileSystemException {
        try {
            Class<?> providerClass = this.classLoader.loadClass(providerClassName);
            return (FileProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/create-provider.error", providerClassName, (Throwable)e);
        }
    }
}

