/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.util.MonitorOutputStream;

class SftpFileObject
extends AbstractFileObject
implements FileObject {
    private final SftpFileSystem fileSystem;
    private SftpATTRS attrs;

    public SftpFileObject(FileName name, SftpFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
    }

    protected FileType doGetType() throws Exception {
        this.statSelf();
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected void onChange() throws Exception {
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statSelf() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            try {
                this.attrs = channel.stat(this.getName().getPath());
            }
            catch (SftpException e) {
                this.attrs = null;
                Object var4_3 = null;
                this.fileSystem.putChannel(channel);
            }
            Object var4_2 = null;
            this.fileSystem.putChannel(channel);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fileSystem.putChannel(channel);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            channel.mkdir(this.getName().getPath());
            Object var3_2 = null;
            this.fileSystem.putChannel(channel);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fileSystem.putChannel(channel);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            if (this.getType() == FileType.FILE) {
                channel.rm(this.getName().getPath());
            } else {
                channel.rmdir(this.getName().getPath());
            }
            Object var3_2 = null;
            this.fileSystem.putChannel(channel);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fileSystem.putChannel(channel);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] doListChildren() throws Exception {
        Vector vector;
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            vector = channel.ls(this.getName().getPath());
            Object var4_3 = null;
            this.fileSystem.putChannel(channel);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fileSystem.putChannel(channel);
            throw throwable;
        }
        if (vector == null) {
            throw new FileSystemException("vfs.provider.sftp/list-children.error");
        }
        ArrayList<String> children = new ArrayList<String>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String stat = (String)iterator.next();
            StringTokenizer tokens = new StringTokenizer(stat);
            int i = 0;
            while (i < 8) {
                tokens.nextToken();
                ++i;
            }
            String name = tokens.nextToken();
            if (name.equals(".") || name.equals("..")) continue;
            children.add(name);
        }
        return children.toArray(new String[children.size()]);
    }

    protected long doGetContentSize() throws Exception {
        if ((this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            channel.get(this.getName().getPath(), (OutputStream)outstr);
            outstr.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outstr.toByteArray());
            Object var5_4 = null;
            this.fileSystem.putChannel(channel);
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.fileSystem.putChannel(channel);
            throw throwable;
        }
    }

    protected OutputStream doGetOutputStream() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        return new SftpOutputStream(channel);
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final ChannelSftp channel;

        public SftpOutputStream(ChannelSftp channel) {
            super(new ByteArrayOutputStream());
            this.channel = channel;
        }

        protected void onClose() throws IOException {
            try {
                try {
                    ByteArrayOutputStream outstr = (ByteArrayOutputStream)this.out;
                    this.channel.put((InputStream)new ByteArrayInputStream(outstr.toByteArray()), SftpFileObject.this.getName().getPath());
                }
                catch (SftpException e) {
                    throw new FileSystemException(e);
                }
                Object var3_3 = null;
                SftpFileObject.this.fileSystem.putChannel(this.channel);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                SftpFileObject.this.fileSystem.putChannel(this.channel);
                throw throwable;
            }
        }
    }
}

