/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static Map messages = new HashMap();
    private static ResourceBundle resources;

    private Messages() {
    }

    public static String getString(String code) {
        return Messages.getString(code, new Object[0]);
    }

    public static String getString(String code, Object param) {
        return Messages.getString(code, new Object[]{param});
    }

    public static String getString(String code, Object[] params) {
        try {
            MessageFormat msg = Messages.findMessage(code);
            return msg.format(params);
        }
        catch (MissingResourceException mre) {
            return "Unknown message with code \"" + code + "\".";
        }
    }

    private static synchronized MessageFormat findMessage(String code) throws MissingResourceException {
        MessageFormat msg = (MessageFormat)messages.get(code);
        if (msg != null) {
            return msg;
        }
        if (resources == null) {
            resources = ResourceBundle.getBundle("org.apache.commons.vfs.Resources");
        }
        String msgText = resources.getString(code);
        msg = new MessageFormat(msgText);
        messages.put(code, msg);
        return msg;
    }
}

