/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.JavaPlatform;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import org.xml.sax.XMLReader;

public class StandardCollectionURIResolver
implements CollectionURIResolver {
    public SequenceIterator resolve(String string, String string2, XPathContext xPathContext) throws XPathException {
        URI uRI;
        Object object;
        Comparable<URI> comparable;
        if (string == null) {
            return null;
        }
        if (string2 == null && (string2 = JavaPlatform.tryToExpand(string2)) == null) {
            DynamicError dynamicError = new DynamicError("Cannot resolve relative URI: no base URI available");
            dynamicError.setErrorCode("FODC0002");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        URIQueryParameters uRIQueryParameters = null;
        try {
            comparable = new URI(string);
            object = ((URI)comparable).getQuery();
            if (object != null) {
                uRIQueryParameters = new URIQueryParameters((String)object, xPathContext.getConfiguration());
                int n = string.indexOf(63);
                string = string.substring(0, n);
            }
            uRI = new URI(string2).resolve(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            DynamicError dynamicError = new DynamicError("Invalid URI " + Err.wrap(string) + " passed to collection() function");
            dynamicError.setErrorCode("FODC0002");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if ("file".equals(uRI.getScheme())) {
            comparable = new File(uRI);
            if (!((File)comparable).exists()) {
                object = new DynamicError("The file or directory " + uRI + " does not exist");
                ((XPathException)object).setErrorCode("FODC0004");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw object;
            }
            if (((File)comparable).isDirectory()) {
                return this.directoryContents((File)comparable, uRIQueryParameters, xPathContext);
            }
        }
        return this.catalogContents(uRI, uRIQueryParameters, xPathContext);
    }

    private SequenceIterator directoryContents(File file, URIQueryParameters uRIQueryParameters, XPathContext xPathContext) {
        int n;
        File[] fileArray;
        File[] fileArray2 = null;
        if (uRIQueryParameters != null && (fileArray = uRIQueryParameters.getFilenameFilter()) != null) {
            fileArray2 = fileArray;
        }
        fileArray = fileArray2 == null ? file.listFiles() : file.listFiles((FilenameFilter)fileArray2);
        Item[] itemArray = new ObjectValue[fileArray.length];
        for (n = 0; n < fileArray.length; ++n) {
            itemArray[n] = new ObjectValue(fileArray[n]);
        }
        n = 1;
        if (uRIQueryParameters != null && uRIQueryParameters.getOnError() != null) {
            n = uRIQueryParameters.getOnError();
        }
        Controller controller = xPathContext.getController();
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        PipelineConfiguration pipelineConfiguration2 = new PipelineConfiguration(pipelineConfiguration);
        final ErrorListener errorListener = controller.getErrorListener();
        if (n == 3) {
            pipelineConfiguration2.setErrorListener(new ErrorListener(){

                public void warning(TransformerException transformerException) {
                }

                public void error(TransformerException transformerException) {
                }

                public void fatalError(TransformerException transformerException) {
                }
            });
        } else if (n == 2) {
            pipelineConfiguration2.setErrorListener(new ErrorListener(){

                public void warning(TransformerException transformerException) throws TransformerException {
                    errorListener.warning(transformerException);
                }

                public void error(TransformerException transformerException) throws TransformerException {
                    errorListener.warning(transformerException);
                    DynamicError dynamicError = new DynamicError("The document will be excluded from the collection");
                    dynamicError.setLocator(transformerException.getLocator());
                    errorListener.warning(dynamicError);
                }

                public void fatalError(TransformerException transformerException) throws TransformerException {
                    this.error(transformerException);
                }
            });
        }
        FileExpander fileExpander = new FileExpander(uRIQueryParameters, pipelineConfiguration2);
        ArrayIterator arrayIterator = new ArrayIterator(itemArray);
        return new MappingIterator(arrayIterator, fileExpander);
    }

    private SequenceIterator catalogContents(URI uRI, URIQueryParameters uRIQueryParameters, final XPathContext xPathContext) throws XPathException {
        DocumentInfo documentInfo = (DocumentInfo)Document.makeDoc(uRI.toString(), null, xPathContext, null);
        if (documentInfo == null) {
            DynamicError dynamicError = new DynamicError("Failed to load collection catalogue " + uRI);
            dynamicError.setErrorCode("FODC0004");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        AxisIterator axisIterator = documentInfo.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (!(nodeInfo == null || "collection".equals(nodeInfo.getLocalPart()) && nodeInfo.getURI().equals(""))) {
            DynamicError dynamicError = new DynamicError("collection catalogue must contain top-level element <collection>");
            dynamicError.setErrorCode("FODC0004");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                NodeInfo nodeInfo = (NodeInfo)item;
                if (!"doc".equals(nodeInfo.getLocalPart()) || !nodeInfo.getURI().equals("")) {
                    DynamicError dynamicError = new DynamicError("children of <collection> element must be <doc> elements");
                    dynamicError.setErrorCode("FODC0004");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                String string = Navigator.getAttributeValue(nodeInfo, "", "href");
                if (string == null) {
                    DynamicError dynamicError = new DynamicError("\"<doc> element in catalogue has no @href attribute\"");
                    dynamicError.setErrorCode("FODC0004");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                NodeInfo nodeInfo2 = Document.makeDoc(string, nodeInfo.getBaseURI(), xPathContext, null);
                return nodeInfo2;
            }
        };
        return new ItemMappingIterator(axisIterator2, itemMappingFunction);
    }

    private static class FileExpander
    implements MappingFunction {
        private URIQueryParameters params;
        boolean recurse = false;
        int strip = 13;
        int validation = 4;
        XMLReader parser = null;
        int onError = 1;
        FilenameFilter filter = null;
        PipelineConfiguration pipe;

        public FileExpander(URIQueryParameters uRIQueryParameters, PipelineConfiguration pipelineConfiguration) {
            this.params = uRIQueryParameters;
            this.pipe = pipelineConfiguration;
            if (uRIQueryParameters != null) {
                XMLReader xMLReader;
                Integer n;
                Boolean bl;
                FilenameFilter filenameFilter = uRIQueryParameters.getFilenameFilter();
                if (filenameFilter != null) {
                    this.filter = filenameFilter;
                }
                if ((bl = uRIQueryParameters.getRecurse()) != null) {
                    this.recurse = bl;
                }
                if ((n = uRIQueryParameters.getValidationMode()) != null) {
                    this.validation = n;
                }
                this.strip = uRIQueryParameters.getStripSpace();
                Integer n2 = uRIQueryParameters.getOnError();
                if (n2 != null) {
                    this.onError = n2;
                }
                if ((xMLReader = uRIQueryParameters.getXMLReader()) != null) {
                    this.parser = xMLReader;
                }
            }
        }

        public Object map(Item item) throws XPathException {
            File file = (File)((ObjectValue)item).getObject();
            if (file.isDirectory()) {
                if (this.recurse) {
                    File[] fileArray = this.filter == null ? file.listFiles() : file.listFiles(this.filter);
                    Item[] itemArray = new ObjectValue[fileArray.length];
                    for (int i = 0; i < fileArray.length; ++i) {
                        itemArray[i] = new ObjectValue(fileArray[i]);
                    }
                    FileExpander fileExpander = new FileExpander(this.params, this.pipe);
                    return new MappingIterator(new ArrayIterator(itemArray), fileExpander);
                }
                return null;
            }
            try {
                Source source = new StreamSource(file.toURI().toString());
                if (this.validation != 4 && this.validation != 3) {
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).setSchemaValidationMode(this.validation);
                }
                if (this.parser != null) {
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).setXMLReader(this.parser);
                }
                AllElementStripper allElementStripper = null;
                if (this.params != null) {
                    int n = this.params.getStripSpace();
                    switch (this.strip) {
                        case 12: {
                            allElementStripper = AllElementStripper.getInstance();
                            allElementStripper.setStripAll();
                            source = AugmentedSource.makeAugmentedSource(source);
                            ((AugmentedSource)source).addFilter(allElementStripper);
                            break;
                        }
                        case 10: 
                        case 11: {
                            source = AugmentedSource.makeAugmentedSource(source);
                            ((AugmentedSource)source).setStripSpace(n);
                        }
                    }
                }
                NodeInfo nodeInfo = Builder.build(source, null, this.pipe);
                return nodeInfo.getDocumentRoot();
            }
            catch (XPathException xPathException) {
                if (this.onError == 3) {
                    return null;
                }
                if (this.onError == 2) {
                    try {
                        if (!xPathException.hasBeenReported()) {
                            this.pipe.getErrorListener().warning(xPathException);
                            DynamicError dynamicError = new DynamicError("The document will be excluded from the collection");
                            dynamicError.setLocator(xPathException.getLocator());
                            this.pipe.getErrorListener().warning(dynamicError);
                        }
                    }
                    catch (TransformerException transformerException) {
                        // empty catch block
                    }
                    return null;
                }
                throw xPathException;
            }
        }
    }
}

