/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.ShareableSequence;
import net.sf.saxon.value.Value;

public class Closure
extends Value {
    protected Expression expression;
    protected XPathContextMajor savedXPathContext;
    protected int depth = 0;
    protected SequenceIterator inputIterator;

    public static Closure makeIteratorClosure(SequenceIterator sequenceIterator) {
        Closure closure = new Closure();
        closure.inputIterator = sequenceIterator;
        return closure;
    }

    public static Value make(Expression expression, XPathContext xPathContext, int n) throws XPathException {
        Object object;
        ValueRepresentation[] valueRepresentationArray;
        Expression expression2;
        Object object2;
        if (expression instanceof ErrorExpression) {
            expression.evaluateItem(xPathContext);
            return null;
        }
        if (expression instanceof TailExpression && (object2 = ((TailExpression)(expression2 = (TailExpression)expression)).getBaseExpression()) instanceof VariableReference) {
            if ((object2 = Value.asValue(ExpressionTool.lazyEvaluate((Expression)object2, xPathContext, n))) instanceof MemoClosure) {
                valueRepresentationArray = object2.iterate(null);
                object2 = ((GroundedIterator)valueRepresentationArray).materialize();
            }
            if (object2 instanceof IntegerRange) {
                long l;
                long l2 = ((IntegerRange)object2).getStart() + 1L;
                if (l2 == (l = ((IntegerRange)object2).getEnd())) {
                    return new IntegerValue(l);
                }
                return new IntegerRange(l2, l);
            }
            if (object2 instanceof SequenceExtent) {
                return new SequenceExtent((SequenceExtent)object2, ((TailExpression)expression2).getStart() - 1, ((SequenceExtent)object2).getLength() - ((TailExpression)expression2).getStart() + 1);
            }
        }
        if (expression instanceof Block && ((Block)expression).getChildren().length == 2) {
            expression2 = (Block)expression;
            object2 = ((Block)expression2).getChildren()[0];
            if (object2 instanceof VariableReference && (object2 = Value.asValue(ExpressionTool.lazyEvaluate((Expression)object2, xPathContext, n))) instanceof MemoClosure && ((MemoClosure)object2).isFullyRead()) {
                object2 = ((MemoClosure)object2).materialize();
            }
            if (object2 instanceof ShareableSequence && ((ShareableSequence)object2).isShareable()) {
                Item item;
                valueRepresentationArray = ((ShareableSequence)object2).getList();
                SequenceIterator sequenceIterator = ((Block)expression2).getChildren()[1].iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    valueRepresentationArray.add(item);
                }
                return new ShareableSequence((List)valueRepresentationArray);
            }
            if (object2 instanceof Value) {
                Item item;
                valueRepresentationArray = new ArrayList(20);
                SequenceIterator sequenceIterator = object2.iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    valueRepresentationArray.add(item);
                }
                sequenceIterator = ((Block)expression2).getChildren()[1].iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    valueRepresentationArray.add(item);
                }
                return new ShareableSequence((List)valueRepresentationArray);
            }
        }
        expression2 = xPathContext.getConfiguration().getOptimizer().makeClosure(expression, n);
        ((Closure)expression2).expression = expression;
        ((Closure)expression2).savedXPathContext = xPathContext.newContext();
        ((Closure)expression2).savedXPathContext.setOriginatingConstructType(2063);
        if (expression instanceof ComputedExpression && (expression.getDependencies() & 0x80) != 0) {
            object2 = xPathContext.getStackFrame();
            valueRepresentationArray = ((StackFrame)object2).getStackFrameValues();
            object = ((ComputedExpression)expression).getSlotsUsed();
            if (valueRepresentationArray != null) {
                ValueRepresentation[] valueRepresentationArray2 = new ValueRepresentation[valueRepresentationArray.length];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object3 = object[i];
                    if (valueRepresentationArray[object3] instanceof Closure) {
                        int n2 = ((Closure)valueRepresentationArray[object3]).depth;
                        if (n2 >= 10) {
                            valueRepresentationArray[object3] = ExpressionTool.eagerEvaluate((Closure)valueRepresentationArray[object3], xPathContext);
                        } else if (n2 + 1 > ((Closure)expression2).depth) {
                            ((Closure)expression2).depth = n2 + 1;
                        }
                    }
                    valueRepresentationArray2[object3] = valueRepresentationArray[object3];
                }
                ((Closure)expression2).savedXPathContext.setStackFrame(((StackFrame)object2).getStackFrameMap(), valueRepresentationArray2);
            }
        }
        if ((object2 = xPathContext.getCurrentIterator()) != null) {
            valueRepresentationArray = object2.current();
            object = SingletonIterator.makeIterator((Item)valueRepresentationArray);
            object.next();
            ((Closure)expression2).savedXPathContext.setCurrentIterator((SequenceIterator)object);
        }
        ((Closure)expression2).savedXPathContext.setReceiver(null);
        return expression2;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.expression == null) {
            return AnyItemType.getInstance();
        }
        return this.expression.getItemType(typeHierarchy);
    }

    public int getCardinality() {
        if (this.expression == null) {
            return 57344;
        }
        return this.expression.getCardinality();
    }

    public int getSpecialProperties() {
        if (this.expression == null) {
            return 57344;
        }
        return this.expression.getSpecialProperties();
    }

    public int getImplementationMethod() {
        return 6;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.inputIterator == null) {
            this.inputIterator = this.expression.iterate(this.savedXPathContext);
            return this.inputIterator;
        }
        return this.inputIterator.getAnother();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        XPathContextMajor xPathContextMajor = this.savedXPathContext.newContext();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        xPathContextMajor.setTemporaryReceiver(sequenceReceiver);
        this.expression.process(xPathContextMajor);
    }

    public Value reduce() throws XPathException {
        return new SequenceExtent(this.iterate(null)).reduce();
    }

    public boolean isIndexable() {
        return false;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "Closure of expression:");
        this.expression.display(n + 1, printStream, configuration);
    }
}

