/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class TitleConf {
    private UISpecification specification;
    private String name;
    private String alias;
    private String path;
    private TitleConf parent;
    private List<TitleConf> children = new ArrayList<TitleConf>();
    private List<Variable> metadata = new ArrayList<Variable>();

    public TitleConf(UISpecification specification) {
        this.specification = specification;
    }

    public String getAlias() {
        if (this.alias == null || this.alias.length() == 0) {
            return this.name;
        }
        ResourceBundle bundle = this.specification.getBundle();
        if (bundle != null && bundle.containsKey(this.alias)) {
            return bundle.getString(this.alias);
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public UISpecification getSpecification() {
        return this.specification;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TitleConf getParent() {
        return this.parent;
    }

    public void setParent(TitleConf parent) {
        this.parent = parent;
    }

    public String getParentName() {
        return this.parent != null ? this.parent.getName() : null;
    }

    public List<TitleConf> getChildren() {
        return this.children;
    }

    public void setChildren(List<TitleConf> children) {
        if (children != null) {
            for (TitleConf child : children) {
                child.setParent(this);
            }
        }
        this.children = children != null ? children : new ArrayList();
    }

    public List<Variable> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Variable> metadata) {
        this.metadata = metadata != null ? metadata : new ArrayList();
    }

    public Variable getMetadataVariableByXPath(String xpath) {
        return this.getMetadataVariableByXPath(this.metadata, xpath);
    }

    private Variable getMetadataVariableByXPath(List<Variable> variables, String xpath) {
        if (variables == null) {
            return null;
        }
        Variable match = null;
        for (Variable variable : variables) {
            if (xpath.equals(variable.getXPath())) {
                match = variable;
            } else if (variable instanceof ComplexVariable) {
                ComplexVariable complexVariable = (ComplexVariable)variable;
                match = this.getMetadataVariableByXPath(complexVariable.getChildren(), xpath);
            }
            if (match == null) continue;
            break;
        }
        return match;
    }

    public TitleConf getChild(String name) {
        if (this.children != null) {
            for (TitleConf child : this.children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public void addChild(TitleConf titleConf) {
        titleConf.setParent(this);
        this.children.add(titleConf);
    }

    public void addMetadata(Variable v) {
        this.metadata.add(v);
    }

    public List<TitleConf> getAllDescendants() {
        ArrayList<TitleConf> allDecendants = new ArrayList<TitleConf>();
        for (TitleConf child : this.getChildren()) {
            allDecendants.add(child);
            allDecendants.addAll(child.getAllDescendants());
        }
        return allDecendants;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : super.hashCode();
    }

    public boolean equals(Object o) {
        if (this.name != null) {
            return o instanceof TitleConf && this.name.equals(((TitleConf)o).name);
        }
        return super.equals(o);
    }

    public String toString() {
        String newLineString = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("TitleConf:\n");
        sb.append("Name: " + this.name).append(" (").append(this.getAlias()).append(")").append(newLineString);
        sb.append("Parent Name: " + this.getParentName()).append(newLineString);
        sb.append("Metadata: \n");
        for (Variable v : this.metadata) {
            sb.append(v).append(newLineString);
        }
        sb.append("Children: \n");
        for (TitleConf child : this.children) {
            sb.append(child).append(newLineString);
        }
        return sb.toString();
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

