/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.addressing.soap;

import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.ReferenceParameters;
import javax.xml.ws.addressing.Relationship;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.util.NotImplementedException;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.addressing.AddressingConstantsImpl;
import org.jboss.ws.addressing.AddressingPropertiesImpl;
import org.jboss.ws.addressing.EndpointReferenceImpl;
import org.jboss.ws.addressing.soap.SOAPAddressingBuilderImpl;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPAddressingPropertiesImpl
extends AddressingPropertiesImpl
implements SOAPAddressingProperties {
    private static AddressingConstants ADDR = new AddressingConstantsImpl();
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();

    @Override
    public void readHeaders(SOAPMessage message) throws AddressingException {
        try {
            SOAPHeader soapHeader = message.getSOAPHeader();
            SOAPAddressingBuilderImpl builder = new SOAPAddressingBuilderImpl();
            AddressingConstants ADDR = ((AddressingBuilder)builder).newAddressingConstants();
            Element wsaAction = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getActionQName());
            if (wsaAction != null) {
                Element wsaFaultTo;
                Element wsaReplyTo;
                Element wsaFrom;
                this.nsRegistry.registerURI(ADDR.getNamespaceURI(), ADDR.getNamespacePrefix());
                NamedNodeMap attribs = soapHeader.getAttributes();
                for (int i = 0; i < attribs.getLength(); ++i) {
                    Attr attr = (Attr)attribs.item(i);
                    String attrName = attr.getName();
                    String attrValue = attr.getValue();
                    if (!attrName.startsWith("xmlns:")) continue;
                    String prefix = attrName.substring(6);
                    this.nsRegistry.registerURI(attrValue, prefix);
                }
                Element wsaTo = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getToQName());
                if (wsaTo != null) {
                    String to = DOMUtils.getTextContent((Node)wsaTo);
                    this.setTo(((AddressingBuilder)builder).newURI(to));
                }
                if ((wsaFrom = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getFromQName())) != null) {
                    EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaFrom);
                    this.setReplyTo(ref);
                }
                if ((wsaReplyTo = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getReplyToQName())) != null) {
                    EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaReplyTo);
                    this.setReplyTo(ref);
                }
                if ((wsaFaultTo = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getFaultToQName())) != null) {
                    EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaFaultTo);
                    this.setFaultTo(ref);
                }
                String action = DOMUtils.getTextContent((Node)wsaAction);
                this.setAction(((AddressingBuilder)builder).newURI(action));
                Element wsaMessageId = DOMUtils.getFirstChildElement((Node)soapHeader, (QName)ADDR.getMessageIDQName());
                if (wsaMessageId != null) {
                    String messageID = DOMUtils.getTextContent((Node)wsaMessageId);
                    this.setMessageID(((AddressingBuilder)builder).newURI(messageID));
                }
                Iterator itRelatesTo = DOMUtils.getChildElements((Node)soapHeader, (QName)ADDR.getRelatesToQName());
                ArrayList<Relationship> relList = new ArrayList<Relationship>();
                while (itRelatesTo.hasNext()) {
                    Element wsaRelatesTo = (Element)itRelatesTo.next();
                    QName type = DOMUtils.getAttributeValueAsQName((Element)wsaRelatesTo, (String)ADDR.getRelationshipTypeName());
                    String uri = DOMUtils.getTextContent((Node)wsaRelatesTo);
                    Relationship rel = ((AddressingBuilder)builder).newRelationship(new URI(uri));
                    rel.setType(type);
                    relList.add(rel);
                }
                Relationship[] relArr = (Relationship[])Array.newInstance(Relationship.class, relList.size());
                relList.toArray(relArr);
                this.setRelatesTo(relArr);
            }
            QName refQName = new QName(this.getNamespaceURI(), "IsReferenceParameter");
            ReferenceParameters refParams = this.getReferenceParameters();
            Iterator it = soapHeader.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                if (!"true".equals(DOMUtils.getAttributeValue((Element)headerElement, (QName)refQName))) continue;
                refParams.addElement(headerElement);
            }
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot read headers", ex);
        }
        catch (URISyntaxException ex) {
            throw new AddressingException("Cannot read headers", ex);
        }
    }

    @Override
    public void writeHeaders(SOAPMessage message) throws AddressingException {
        try {
            ReferenceParameters refParams;
            SOAPElementImpl soapElement;
            EndpointReferenceImpl epr;
            SOAPFactoryImpl factory = (SOAPFactoryImpl)SOAPFactory.newInstance();
            SOAPHeader soapHeader = message.getSOAPHeader();
            if (this.getAction() == null) {
                throw new AddressingException("Required addressing property wsa:Action");
            }
            soapHeader.addNamespaceDeclaration(ADDR.getNamespacePrefix(), ADDR.getNamespaceURI());
            if (this.getTo() != null) {
                SOAPElement wsaTo = soapHeader.addChildElement((Name)new NameImpl(ADDR.getToQName()));
                wsaTo.addTextNode(this.getTo().getURI().toString());
            }
            if (this.getFrom() != null) {
                epr = (EndpointReferenceImpl)this.getFrom();
                epr.setRootQName(ADDR.getFromQName());
                soapElement = factory.createElement(epr.toElement(), true);
                soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
                soapHeader.addChildElement((SOAPElement)soapElement);
            }
            if (this.getReplyTo() != null) {
                epr = (EndpointReferenceImpl)this.getReplyTo();
                epr.setRootQName(ADDR.getReplyToQName());
                soapElement = factory.createElement(epr.toElement(), true);
                soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
                soapHeader.addChildElement((SOAPElement)soapElement);
            }
            if (this.getFaultTo() != null) {
                epr = (EndpointReferenceImpl)this.getFaultTo();
                epr.setRootQName(ADDR.getFaultToQName());
                soapElement = factory.createElement(epr.toElement(), true);
                soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
                soapHeader.addChildElement((SOAPElement)soapElement);
            }
            SOAPElement wsaAction = soapHeader.addChildElement((Name)new NameImpl(ADDR.getActionQName()));
            wsaAction.addTextNode(this.getAction().getURI().toString());
            if (this.getMessageID() != null) {
                SOAPElement wsaMessageId = soapHeader.addChildElement((Name)new NameImpl(ADDR.getMessageIDQName()));
                wsaMessageId.addTextNode(this.getMessageID().getURI().toString());
            }
            if (this.getRelatesTo() != null) {
                for (Relationship rel : this.getRelatesTo()) {
                    SOAPElement wsaRelatesTo = soapHeader.addChildElement((Name)new NameImpl(ADDR.getRelatesToQName()));
                    if (rel.getType() != null) {
                        wsaRelatesTo.setAttribute(ADDR.getRelationshipTypeName(), this.getPrefixedName(rel.getType()));
                    }
                    wsaRelatesTo.addTextNode(rel.getID().toString());
                }
            }
            if ((refParams = this.getReferenceParameters()).getElements().size() > 0 || refParams.getAttributes().size() > 0) {
                SOAPElement wsaRefParams = soapHeader.addChildElement((Name)new NameImpl(ADDR.getReferenceParametersQName()));
                this.appendAttributes(wsaRefParams, refParams.getAttributes());
                this.appendElements(wsaRefParams, refParams.getElements());
            }
            this.appendElements((SOAPElement)soapHeader, this.getElements());
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot read headers", ex);
        }
    }

    @Override
    public void setMu(boolean mu) {
        throw new NotImplementedException();
    }

    private void appendAttributes(SOAPElement soapElement, Map<QName, String> attributes) {
        for (QName qname : attributes.keySet()) {
            String qualname = this.getPrefixedName(qname);
            String value = attributes.get(qname);
            soapElement.setAttribute(qualname, value);
        }
    }

    private void appendElements(SOAPElement soapElement, List<Object> elements) {
        try {
            SOAPFactoryImpl factory = (SOAPFactoryImpl)SOAPFactory.newInstance();
            for (Object obj : elements) {
                if (obj instanceof Element) {
                    SOAPElementImpl child = factory.createElement((Element)obj, true);
                    soapElement.addChildElement((SOAPElement)child);
                    continue;
                }
                if (obj instanceof String) {
                    Element el = DOMUtils.parse((String)((String)obj));
                    SOAPElementImpl child = factory.createElement(el, true);
                    soapElement.addChildElement((SOAPElement)child);
                    continue;
                }
                throw new AddressingException("Unsupported element: " + obj.getClass().getName());
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new AddressingException("Cannot append elements", ex);
        }
    }

    private String getPrefixedName(QName qname) {
        String prefix = qname.getPrefix();
        String localPart = qname.getLocalPart();
        String qualname = prefix != null && prefix.length() > 0 ? prefix + ":" + localPart : localPart;
        return qualname;
    }
}

