/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.config.WSConfig;
import org.jboss.ws.metadata.config.WSConfigFactory;
import org.jboss.ws.metadata.config.WSEndpointConfig;
import org.jboss.ws.metadata.config.WSHandlerChainConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEndpointMetaData
extends EndpointMetaData {
    private static Logger log = Logger.getLogger(ServerEndpointMetaData.class);
    private WSEndpointConfig endpointConfig;
    private String linkName;
    private String portComponentName;
    private String implName;
    private ObjectName endpointID;
    private String contextRoot;
    private String urlPattern;
    private boolean annotated = false;

    public ServerEndpointMetaData(ServiceMetaData service, QName qname) {
        super(service, qname);
        this.setConfigName("Standard Endpoint");
        this.setConfigFile("META-INF/standard-jbossws-endpoint-config.xml");
    }

    public WSEndpointConfig getEndpointConfig() {
        if (this.endpointConfig == null) {
            WSConfig wsConfig;
            ClassLoader cl;
            String configName = this.getConfigName();
            String configFile = this.getConfigFile();
            log.debug((Object)("getEndpointConfig: [name=" + configName + ",url=" + configFile + "]"));
            URL configURL = null;
            try {
                configURL = new URL(configFile);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (configURL == null && (configURL = (cl = Thread.currentThread().getContextClassLoader()).getResource(configFile)) == null) {
                throw new WSException("Cannot get resource: " + configFile);
            }
            try {
                WSConfigFactory factory = WSConfigFactory.newInstance();
                wsConfig = factory.parseWithObjectModelFactory(configURL);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WSException("Cannot parse client config", ex);
            }
            this.endpointConfig = wsConfig.getEndpointConfigByName(configName);
            if (this.endpointConfig == null) {
                throw new WSException("Cannot obtain endpoint config: " + configName);
            }
            if (!configName.equals(this.endpointConfig.getConfigName())) {
                configName = this.endpointConfig.getConfigName();
                log.debug((Object)("Using config name: " + configName));
                this.setConfigName(configName);
            }
        }
        return this.endpointConfig;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String portComponentName) {
        this.portComponentName = portComponentName;
    }

    public String getEndpointImplementationName() {
        return this.implName;
    }

    public void setEndpointImplementationName(String endpointImpl) {
        this.implName = endpointImpl;
    }

    public ObjectName getEndpointID() {
        return this.endpointID;
    }

    public void setEndpointID(ObjectName endpointID) {
        this.endpointID = endpointID;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean isAnnotated) {
        this.annotated = isAnnotated;
    }

    @Override
    public List<HandlerMetaData> getHandlers() {
        ArrayList<HandlerMetaData> handlers = new ArrayList<HandlerMetaData>();
        WSHandlerChainConfig preHandlerConfig = this.getEndpointConfig().getPreHandlerChain();
        if (preHandlerConfig != null) {
            handlers.addAll(preHandlerConfig.getHandlers());
        }
        handlers.addAll(super.getHandlers());
        WSHandlerChainConfig postHandlerConfig = this.getEndpointConfig().getPostHandlerChain();
        if (postHandlerConfig != null) {
            handlers.addAll(postHandlerConfig.getHandlers());
        }
        return handlers;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nServerEndpointMetaData:");
        buffer.append("\n name=" + this.getName());
        buffer.append("\n id=" + this.getEndpointID().getCanonicalName());
        buffer.append("\n address=" + this.getEndpointAddress());
        buffer.append("\n linkName=" + this.getLinkName());
        buffer.append("\n implName=" + this.getEndpointImplementationName());
        buffer.append("\n seiName=" + this.getServiceEndpointInterfaceName());
        buffer.append("\n annotated=" + this.annotated);
        buffer.append("\n portComponentName=" + this.getPortComponentName());
        buffer.append("\n contextRoot=" + this.getContextRoot());
        buffer.append("\n urlPattern=" + this.getURLPattern());
        buffer.append("\n configFile=" + this.getConfigFile());
        buffer.append("\n configName=" + this.getConfigName());
        buffer.append("\n authMethod=" + this.getAuthMethod());
        buffer.append("\n transportGuarantee=" + this.getTransportGuarantee());
        buffer.append("\n properties=" + this.getProperties());
        for (OperationMetaData opMetaData : this.getOperations()) {
            buffer.append("\n" + opMetaData);
        }
        for (HandlerMetaData hdlMetaData : this.getHandlers()) {
            buffer.append("\n" + hdlMetaData);
        }
        return buffer.toString();
    }
}

