/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.Holder;
import org.jboss.webservice.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PortMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingFault;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.JavaToXSD;
import org.jboss.ws.tools.interfaces.JavaToXSDIntf;
import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
import org.jboss.ws.utils.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDLHelper {
    protected WSDLDefinitions wsdl = null;
    protected String wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
    protected JavaToXSDIntf javaToXSD = new JavaToXSD();
    protected Class seiClass = null;
    private JavaWsdlMapping javaWsdlMapping = new JavaWsdlMapping();
    private Map<QName, JavaXmlTypeMapping> mappedTypes = new HashMap<QName, JavaXmlTypeMapping>();
    private Set<String> mappedPackages = new HashSet<String>();
    protected Map<String, String> packageNamespaceMap = new HashMap<String, String>();
    private Set<String> mappedExceptions = new HashSet<String>();
    protected Map<String, Boolean> features = new HashMap<String, Boolean>();

    public JavaToWSDLHelper(WSDLDefinitions wsdl, String wsdlNS) {
        this.wsdl = wsdl;
        this.wsdlNamespace = wsdlNS;
    }

    public void appendDefinitions(String targetNamespace) {
        this.wsdl.setTargetNamespace(targetNamespace);
        this.wsdl.registerNamespaceURI(targetNamespace, "tns");
        this.wsdl.registerNamespaceURI("http://www.w3.org/2001/XMLSchema", "xsd");
        if (this.wsdlNamespace.equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.wsdl.registerNamespaceURI("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        }
    }

    public void generateTypesForXSD(ParameterMetaData pmd) throws IOException {
        SchemaCreatorIntf sc = this.javaToXSD.getSchemaCreator();
        QName xmlType = pmd.getXmlType();
        if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            this.generateType(xmlType, pmd.getJavaType(), this.buildElementNameMap(pmd));
        }
        if (pmd.getOperationMetaData().getStyle() == Style.DOCUMENT || pmd.isInHeader()) {
            this.generateElement(pmd.getXmlName(), xmlType);
        }
        if (pmd.isSwA()) {
            this.wsdl.registerNamespaceURI("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        }
    }

    private Map<String, QName> buildElementNameMap(ParameterMetaData pmd) {
        List<QName> elements = pmd.getWrappedElementNames();
        List<String> variables = pmd.getWrappedVariables();
        if (elements == null || variables == null) {
            return null;
        }
        if (elements.size() != variables.size()) {
            return null;
        }
        LinkedHashMap<String, QName> map = new LinkedHashMap<String, QName>(elements.size());
        int i = 0;
        for (String variable : variables) {
            map.put(variable, elements.get(i++));
        }
        return map;
    }

    public void generateTypesForXSD(FaultMetaData fmd) throws IOException {
        SchemaCreatorIntf sc = this.javaToXSD.getSchemaCreator();
        QName xmlType = fmd.getXmlType();
        if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            this.generateType(xmlType, fmd.getJavaType(), null);
        }
    }

    public void generateInterfaces(OperationMetaData op, String intfName) {
        Class<Void> returnType;
        QName xmlName;
        String opname;
        WSDLUtils utils = WSDLUtils.getInstance();
        if (op == null) {
            throw new IllegalArgumentException("Illegal Null Argument: op");
        }
        WSDLInterface wsdlInterface = this.wsdl.getInterface(new NCName(intfName));
        if (wsdlInterface == null) {
            wsdlInterface = new WSDLInterface(this.wsdl);
            wsdlInterface.setName(new NCName(intfName));
            this.wsdl.addInterface(wsdlInterface);
        }
        if ((opname = (xmlName = op.getXmlName()).getLocalPart()) == null || opname.length() == 0) {
            throw new WSException("opname is null or blank");
        }
        WSDLInterfaceOperation wsdlInterfaceOperation = new WSDLInterfaceOperation(wsdlInterface);
        wsdlInterfaceOperation.setName(new NCName(opname));
        wsdlInterface.addOperation(wsdlInterfaceOperation);
        if (op.getStyle() == Style.DOCUMENT) {
            wsdlInterfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/iri");
        } else {
            wsdlInterfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/rpc");
        }
        if (op.isOneWayOperation()) {
            wsdlInterfaceOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-only");
        } else {
            wsdlInterfaceOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-out");
        }
        ArrayList<WSDLInterfaceOperationOutput> holderOuts = new ArrayList<WSDLInterfaceOperationOutput>();
        List<ParameterMetaData> pmds = op.getParameters();
        for (ParameterMetaData pmd : pmds) {
            if (pmd.getMode() != ParameterMode.IN) {
                if (op.isOneWayOperation()) {
                    throw new WSException(opname + " is a oneway operation and" + " defines a holder");
                }
                holderOuts.add(this.getWSDLInterfaceOperationOutput(wsdlInterfaceOperation, pmd));
                if (pmd.getMode() != ParameterMode.INOUT) continue;
                wsdlInterfaceOperation.addInput(this.getWSDLInterfaceOperationInput(wsdlInterfaceOperation, pmd));
                continue;
            }
            wsdlInterfaceOperation.addInput(this.getWSDLInterfaceOperationInput(wsdlInterfaceOperation, pmd));
        }
        ParameterMetaData retpmd = op.getReturnParameter();
        Class<Void> clazz = returnType = retpmd != null ? retpmd.getClass() : Void.TYPE;
        if (returnType != null && Void.TYPE != returnType) {
            WSDLInterfaceOperationOutput returnOutput = this.getWSDLInterfaceOperationOutput(wsdlInterfaceOperation, retpmd);
            returnOutput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/return-part", null));
            wsdlInterfaceOperation.addOutput(returnOutput);
        }
        for (WSDLInterfaceOperationOutput wo : holderOuts) {
            wsdlInterfaceOperation.addOutput(wo);
        }
        List<FaultMetaData> fmds = op.getFaults();
        for (FaultMetaData fmd : fmds) {
            this.generateWSDLFaults(wsdlInterfaceOperation, fmd.getXmlName());
        }
    }

    public void generateBindings(OperationMetaData op, String bindName) {
        Class<Void> returnType;
        WSDLUtils utils = WSDLUtils.getInstance();
        String intfName = utils.chop(bindName, "Binding");
        WSDLBinding wsdlBinding = this.wsdl.getBinding(new NCName(bindName));
        if (wsdlBinding == null) {
            wsdlBinding = new WSDLBinding(this.wsdl);
            wsdlBinding.setName(new NCName(bindName));
            wsdlBinding.setInterfaceName(new QName(this.wsdl.getTargetNamespace(), intfName));
            this.wsdl.addBinding(wsdlBinding);
        }
        String opname = op.getXmlName().getLocalPart();
        WSDLBindingOperation wsdlBindingOperation = new WSDLBindingOperation(wsdlBinding);
        wsdlBindingOperation.setRef(new QName(this.wsdl.getTargetNamespace(), opname));
        wsdlBinding.addOperation(wsdlBindingOperation);
        List<ParameterMetaData> pmds = op.getInputParameters();
        for (ParameterMetaData pmd : pmds) {
            WSDLBindingOperationInput wsdlBindingOperationInput = new WSDLBindingOperationInput(wsdlBindingOperation);
            wsdlBindingOperationInput.setMessageLabel(new NCName(pmd.getXmlName().getLocalPart()));
            wsdlBindingOperation.addInput(wsdlBindingOperationInput);
        }
        ParameterMetaData retpmd = op.getReturnParameter();
        Class<Void> clazz = returnType = retpmd != null ? retpmd.getClass() : Void.TYPE;
        if (returnType != null && Void.TYPE != returnType) {
            WSDLBindingOperationOutput wsdlBindingOperationOutput = new WSDLBindingOperationOutput(wsdlBindingOperation);
            wsdlBindingOperationOutput.setMessageLabel(new NCName(retpmd.getXmlName().getLocalPart()));
            wsdlBindingOperation.addOutput(wsdlBindingOperationOutput);
        }
        pmds = op.getOutputParameters();
        for (ParameterMetaData pmd : pmds) {
            WSDLBindingOperationOutput wsdlBindingOperationOutput = new WSDLBindingOperationOutput(wsdlBindingOperation);
            wsdlBindingOperationOutput.setMessageLabel(new NCName(pmd.getXmlName().getLocalPart()));
            wsdlBindingOperation.addOutput(wsdlBindingOperationOutput);
        }
        List<FaultMetaData> fmds = op.getFaults();
        for (FaultMetaData fmd : fmds) {
            WSDLBindingFault f = new WSDLBindingFault(wsdlBinding);
            String faultName = fmd.getXmlName().getLocalPart();
            WSDLInterfaceFault intFault = this.wsdl.getInterface(new NCName(intfName)).getFault(new NCName(faultName));
            if (intFault == null) {
                throw new WSException("Fault in WSDLInterface for name=" + faultName + " not found");
            }
            QName fqname = new QName(this.wsdl.getTargetNamespace(), faultName);
            f.setRef(fqname);
        }
    }

    public void generateServices(EndpointMetaData endpoint, String intfName) {
        if (endpoint == null) {
            throw new WSException("Illegal Null Argument: endpt");
        }
        String serviceName = endpoint.getServiceMetaData().getName().getLocalPart();
        WSDLService wsdlService = new WSDLService(this.wsdl);
        wsdlService.setName(new NCName(serviceName));
        this.wsdl.addService(wsdlService);
        String portName = endpoint.getName().getLocalPart();
        WSDLInterface wsdlInterface = this.wsdl.getInterface(new NCName(intfName));
        if (wsdlInterface == null) {
            throw new WSException("WSDL Interface for name = " + intfName + " is null");
        }
        QName seiQName = wsdlInterface.getQName();
        WSDLBinding wsdlBinding = this.wsdl.getBindings()[0];
        NCName bindingName = wsdlBinding.getName();
        QName bindingQName = new QName(this.wsdl.getTargetNamespace(), bindingName.toString());
        wsdlService.setInterfaceName(seiQName);
        WSDLEndpoint wsdlEndpoint = new WSDLEndpoint(wsdlService);
        wsdlEndpoint.setName(new NCName(portName));
        wsdlEndpoint.setBinding(bindingQName);
        wsdlEndpoint.setAddress("REPLACE_WITH_ACTUAL_URL");
        wsdlService.addEndpoint(wsdlEndpoint);
        this.buildServiceMapping(endpoint, intfName);
    }

    private void buildServiceMapping(EndpointMetaData endpoint, String interfaceName) {
        QName origQName = endpoint.getServiceMetaData().getName();
        String serviceInterfaceName = endpoint.getServiceEndpointInterface().getPackage().getName() + "." + origQName.getLocalPart();
        QName serviceQName = new QName(origQName.getNamespaceURI(), origQName.getLocalPart(), "serviceNS");
        ServiceInterfaceMapping serviceMapping = new ServiceInterfaceMapping(this.javaWsdlMapping);
        serviceMapping.setServiceInterface(serviceInterfaceName);
        serviceMapping.setWsdlServiceName(serviceQName);
        String endpointName = endpoint.getName().getLocalPart();
        PortMapping portMapping = new PortMapping(serviceMapping);
        portMapping.setJavaPortName(endpointName);
        portMapping.setPortName(endpointName);
        serviceMapping.addPortMapping(portMapping);
        this.javaWsdlMapping.addServiceInterfaceMappings(serviceMapping);
        ServiceEndpointInterfaceMapping seiMapping = new ServiceEndpointInterfaceMapping(this.javaWsdlMapping);
        seiMapping.setServiceEndpointInterface(endpoint.getServiceEndpointInterfaceName());
        seiMapping.setWsdlPortType(new QName(this.wsdl.getTargetNamespace(), interfaceName, "portTypeNS"));
        seiMapping.setWsdlBinding(new QName(this.wsdl.getTargetNamespace(), interfaceName + "Binding", "bindingNS"));
        for (OperationMetaData operation : endpoint.getOperations()) {
            Object name;
            ServiceEndpointMethodMapping methodMapping = new ServiceEndpointMethodMapping(seiMapping);
            methodMapping.setJavaMethodName(operation.getJavaName());
            methodMapping.setWsdlOperation(operation.getXmlName().getLocalPart());
            boolean isWrapped = operation.isDocumentWrapped();
            methodMapping.setWrappedElement(isWrapped);
            int i = 0;
            for (ParameterMetaData param : operation.getParameters()) {
                if (isWrapped && !param.isInHeader()) {
                    List<String> wrappedTypes = param.getWrappedTypes();
                    List<QName> wrappedElementNames = param.getWrappedElementNames();
                    for (int c = 0; c < wrappedTypes.size(); ++c) {
                        String type = JavaUtils.convertJVMNameToSourceName(wrappedTypes.get(c), endpoint.getClassLoader());
                        name = wrappedElementNames.get(c).getLocalPart();
                        this.buildParamMapping(methodMapping, interfaceName, operation, (String)name, type, "IN", false, i++);
                    }
                    continue;
                }
                String name2 = param.getXmlName().getLocalPart();
                String type = JavaUtils.convertJVMNameToSourceName(param.getJavaTypeName(), endpoint.getClassLoader());
                this.buildParamMapping(methodMapping, interfaceName, operation, name2, type, param.getMode().toString(), param.isInHeader(), i++);
            }
            ParameterMetaData returnParam = operation.getReturnParameter();
            if (!(returnParam == null || isWrapped && returnParam.getWrappedElementNames().isEmpty())) {
                String type;
                String name3;
                if (isWrapped) {
                    name3 = returnParam.getWrappedElementNames().get(0).getLocalPart();
                    type = returnParam.getWrappedTypes().get(0);
                } else {
                    name3 = returnParam.getXmlName().getLocalPart();
                    type = returnParam.getJavaTypeName();
                }
                type = JavaUtils.convertJVMNameToSourceName(type, endpoint.getClassLoader());
                this.buildReturnParamMapping(methodMapping, interfaceName, operation, name3, type);
            }
            seiMapping.addServiceEndpointMethodMapping(methodMapping);
            for (FaultMetaData fmd : operation.getFaults()) {
                String javaTypeName;
                JavaXmlTypeMapping typeMapping = this.mappedTypes.get(fmd.getXmlType());
                if (typeMapping == null || this.mappedExceptions.contains(javaTypeName = fmd.getJavaTypeName())) continue;
                this.mappedExceptions.add(javaTypeName);
                ExceptionMapping mapping = new ExceptionMapping(this.javaWsdlMapping);
                mapping.setExceptionType(javaTypeName);
                name = new QName(this.wsdl.getTargetNamespace(), fmd.getXmlName().getLocalPart());
                mapping.setWsdlMessage((QName)name);
                for (VariableMapping variableMapping : typeMapping.getVariableMappings()) {
                    mapping.addConstructorParameter(variableMapping.getXmlElementName());
                }
                this.javaWsdlMapping.addExceptionMappings(mapping);
            }
        }
        this.javaWsdlMapping.addServiceEndpointInterfaceMappings(seiMapping);
        String name = endpoint.getServiceEndpointInterface().getPackage().getName();
        String namespace = this.packageNamespaceMap.get(name);
        if (namespace == null) {
            namespace = WSDLUtils.getInstance().getTypeNamespace(name);
        }
        this.addPackageMapping(name, namespace);
    }

    private void buildParamMapping(ServiceEndpointMethodMapping methodMapping, String interfaceName, OperationMetaData operation, String name, String type, String mode, boolean header, int position) {
        MethodParamPartsMapping paramMapping = new MethodParamPartsMapping(methodMapping);
        paramMapping.setParamPosition(position);
        paramMapping.setParamType(type);
        WsdlMessageMapping messageMapping = new WsdlMessageMapping(paramMapping);
        messageMapping.setWsdlMessagePartName(name);
        String messageName = interfaceName + "_" + operation.getXmlName().getLocalPart();
        if ("OUT".equals(mode)) {
            messageName = messageName + "Response";
        }
        QName messageQName = new QName(this.wsdl.getTargetNamespace(), messageName, "wsdlMsgNS");
        messageMapping.setWsdlMessage(messageQName);
        messageMapping.setParameterMode(mode);
        messageMapping.setSoapHeader(header);
        paramMapping.setWsdlMessageMapping(messageMapping);
        methodMapping.addMethodParamPartsMapping(paramMapping);
    }

    private void buildReturnParamMapping(ServiceEndpointMethodMapping methodMapping, String interfaceName, OperationMetaData operation, String name, String type) {
        WsdlReturnValueMapping returnMapping = new WsdlReturnValueMapping(methodMapping);
        returnMapping.setMethodReturnValue(type);
        returnMapping.setWsdlMessagePartName(name);
        String messageName = interfaceName + "_" + operation.getXmlName().getLocalPart() + "Response";
        QName messageQName = new QName(this.wsdl.getTargetNamespace(), messageName, "wsdlMsgNS");
        returnMapping.setWsdlMessage(messageQName);
        methodMapping.setWsdlReturnValueMapping(returnMapping);
    }

    public TypeMapping getTypeMapping() {
        return this.javaToXSD.getSchemaCreator().getTypeMapping();
    }

    public void setPackageNamespaceMap(Map<String, String> map) {
        this.packageNamespaceMap = map;
        this.javaToXSD.setPackageNamespaceMap(map);
    }

    public void setEndpoint(Class cls) {
        this.seiClass = cls;
    }

    public void setFeatures(Map<String, Boolean> features) {
        this.features = features;
    }

    public void setJavaToXSD(JavaToXSDIntf jxsd) {
        this.javaToXSD = jxsd;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    protected void generateType(QName xmlType, Class javaType, Map<String, QName> elementNames) throws IOException {
        Iterator iter;
        JBossXSModel xsModel;
        if (Holder.class.isAssignableFrom(javaType)) {
            javaType = WSDLUtils.getInstance().getJavaTypeForHolder(javaType);
        }
        if ((xsModel = this.javaToXSD.generateForSingleType(xmlType, javaType, elementNames)) == null) {
            throw new WSException("XSModel is null");
        }
        WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
        wsdlTypes.addSchemaModel(xmlType.getNamespaceURI(), xsModel);
        this.wsdl.registerNamespaceURI(xmlType.getNamespaceURI(), null);
        SchemaCreatorIntf schemaCreator = this.javaToXSD.getSchemaCreator();
        this.mergeJavaWsdlMapping(schemaCreator.getJavaWsdlMapping());
        HashMap map = schemaCreator.getCustomNamespaceMap();
        Set keys = map != null ? map.keySet() : null;
        Iterator iterator = iter = keys != null && !keys.isEmpty() ? keys.iterator() : null;
        while (iter != null && iter.hasNext()) {
            String pref = (String)iter.next();
            String ns = (String)map.get(pref);
            if (ns == null) continue;
            this.wsdl.registerNamespaceURI(ns, null);
        }
    }

    private void mergeJavaWsdlMapping(JavaWsdlMapping source) {
        Object name;
        for (PackageMapping packageMapping : source.getPackageMappings()) {
            name = packageMapping.getPackageType();
            String namespaceURI = packageMapping.getNamespaceURI();
            this.addPackageMapping((String)name, namespaceURI);
        }
        for (PackageMapping packageMapping : source.getJavaXmlTypeMappings()) {
            name = packageMapping.getRootTypeQName();
            if (name == null) {
                name = packageMapping.getAnonymousTypeQName();
            }
            if (this.mappedTypes.containsKey(name)) continue;
            this.mappedTypes.put((QName)name, (JavaXmlTypeMapping)packageMapping);
            JavaXmlTypeMapping typeCopy = new JavaXmlTypeMapping(this.javaWsdlMapping);
            typeCopy.setQNameScope(packageMapping.getQnameScope());
            typeCopy.setAnonymousTypeQName(packageMapping.getAnonymousTypeQName());
            typeCopy.setJavaType(packageMapping.getJavaType());
            typeCopy.setRootTypeQName(packageMapping.getRootTypeQName());
            for (VariableMapping variable : packageMapping.getVariableMappings()) {
                VariableMapping variableCopy = new VariableMapping(typeCopy);
                variableCopy.setDataMember(variable.isDataMember());
                variableCopy.setJavaVariableName(variable.getJavaVariableName());
                variableCopy.setXmlAttributeName(variable.getXmlAttributeName());
                variableCopy.setXmlElementName(variable.getXmlElementName());
                variableCopy.setXmlWildcard(variable.getXmlWildcard());
                typeCopy.addVariableMapping(variableCopy);
            }
            this.javaWsdlMapping.addJavaXmlTypeMappings(typeCopy);
        }
    }

    private void addPackageMapping(String name, String namespaceURI) {
        if (this.mappedPackages.contains(name)) {
            return;
        }
        this.mappedPackages.add(name);
        PackageMapping copy = new PackageMapping(this.javaWsdlMapping);
        copy.setPackageType(name);
        copy.setNamespaceURI(namespaceURI);
        this.javaWsdlMapping.addPackageMapping(copy);
    }

    protected void generateElement(QName xmlName, QName xmlType) {
        WSDLTypes types = this.wsdl.getWsdlTypes();
        String namespaceURI = xmlType.getNamespaceURI();
        JBossXSModel schemaModel = types.getSchemaModel();
        JBossXSTypeDefinition type = "http://www.w3.org/2001/XMLSchema".equals(namespaceURI) ? SchemaUtils.getInstance().getSchemaBasicType(xmlType.getLocalPart()) : schemaModel.getTypeDefinition(xmlType.getLocalPart(), namespaceURI);
        WSSchemaUtils utils = WSSchemaUtils.getInstance(schemaModel.getNamespaceRegistry(), null);
        JBossXSElementDeclaration element = utils.createGlobalXSElementDeclaration(xmlName.getLocalPart(), type, xmlName.getNamespaceURI());
        schemaModel.addXSElementDeclaration(element);
        this.wsdl.registerNamespaceURI(xmlName.getNamespaceURI(), null);
    }

    protected String getXMLNameForArray(QName el) {
        WSDLUtils utils = WSDLUtils.getInstance();
        String xmlName = "";
        String localpart = el.getLocalPart();
        while (localpart.lastIndexOf("Array") > -1) {
            xmlName = xmlName + "arrayOf";
            localpart = utils.chop(localpart, "Array");
        }
        xmlName = xmlName + localpart;
        return xmlName;
    }

    protected QName getXMLSchemaType(Class javaType) {
        String prefix;
        LiteralTypeMapping ty = this.javaToXSD.getSchemaCreator().getTypeMapping();
        QName qn = ty.getXMLType(javaType);
        if (qn != null && (qn.getPrefix() == null || qn.getPrefix().length() == 0) && (prefix = this.wsdl.getPrefix(qn.getNamespaceURI())) != null) {
            qn = new QName(qn.getNamespaceURI(), qn.getLocalPart(), prefix);
        }
        return qn;
    }

    protected Class getJavaType(QName xmlType) {
        LiteralTypeMapping ty = this.javaToXSD.getSchemaCreator().getTypeMapping();
        return ty.getJavaType(xmlType);
    }

    private boolean needsToolsOverride(Class paramType) {
        return ByteArrayHolder.class == paramType;
    }

    private QName getOverrideQName(Class paramType) {
        if (ByteArrayHolder.class == paramType) {
            return Constants.TYPE_LITERAL_BASE64BINARY;
        }
        throw new WSException("paramType not recognized");
    }

    private void generateWSDLFaults(WSDLInterfaceOperation op, QName xmlName) {
        WSDLInterface wsdlInterface = op.getWsdlInterface();
        WSDLInterfaceFault fault = wsdlInterface.getFault(new NCName(xmlName.getLocalPart()));
        if (fault == null) {
            fault = new WSDLInterfaceFault(wsdlInterface);
            fault.setName(new NCName(xmlName.getLocalPart()));
            fault.setXmlName(xmlName);
            wsdlInterface.addFault(fault);
        }
        WSDLInterfaceOperationOutfault outFault = new WSDLInterfaceOperationOutfault(op);
        outFault.setRef(xmlName);
        op.addOutfault(outFault);
    }

    private WSDLInterfaceOperationOutput getWSDLInterfaceOperationOutput(WSDLInterfaceOperation intf, ParameterMetaData pmd) {
        QName xmlType = pmd.getXmlType();
        QName xmlName = pmd.getXmlName();
        String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
        WSDLProperty wprop = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", prefix + ":" + xmlType.getLocalPart());
        WSDLInterfaceOperationOutput wsdlInterfaceOperationOutput = new WSDLInterfaceOperationOutput(intf);
        wsdlInterfaceOperationOutput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/partname", xmlName.getLocalPart()));
        wsdlInterfaceOperationOutput.setElement(xmlName);
        wsdlInterfaceOperationOutput.setMessageLabel(new NCName("OUT"));
        wsdlInterfaceOperationOutput.addProperty(wprop);
        if (pmd.isInHeader()) {
            wsdlInterfaceOperationOutput.addProperty(new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", null));
        }
        return wsdlInterfaceOperationOutput;
    }

    private WSDLInterfaceOperationInput getWSDLInterfaceOperationInput(WSDLInterfaceOperation intf, ParameterMetaData pmd) {
        QName xmlType = pmd.getXmlType();
        QName xmlName = pmd.getXmlName();
        WSDLInterfaceOperationInput wsdlInput = new WSDLInterfaceOperationInput(intf);
        String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
        WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", prefix + ":" + xmlType.getLocalPart());
        wsdlInput.addProperty(wsdlProperty);
        wsdlInput.setElement(xmlName);
        wsdlInput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/partname", xmlName.getLocalPart()));
        wsdlInput.setMessageLabel(new NCName("IN"));
        if (pmd.isInHeader()) {
            wsdlInput.addProperty(new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", null));
        }
        return wsdlInput;
    }

    private boolean checkAttachmentBasedOperation(OperationMetaData op) {
        boolean isAttach = false;
        List<ParameterMetaData> params = op.getParameters();
        for (ParameterMetaData param : params) {
            if (!param.isSwA()) continue;
            isAttach = true;
            break;
        }
        return isAttach;
    }
}

