/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.BooleanConditionBuilder;
import com.tandbergtv.metadatamanager.search.DateConditionBuilder;
import com.tandbergtv.metadatamanager.search.NumberConditionBuilder;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.StringConditionBuilder;
import com.tandbergtv.metadatamanager.search.TimeConditionBuilder;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;

public class ConditionBuilder {
    private static SearchSchemaHelper ssh = SearchSchemaHelper.getInstace();
    protected static final String XML_EXISTS_START = "xmlexists('$p";
    protected static final String XML_EXISTS_END = "' passing sys_nc_rowinfo$ as \"p\")";
    protected static final String UNPARSABLE_PATH = "/UnparsableFields/UnparsableField";
    protected static final String UNPARSABLE_ATTRIBUTE = "@xpath";
    protected Predicate predicate;

    protected ConditionBuilder(Predicate predicate) {
        this.predicate = predicate;
    }

    protected String getRhsValue() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return (String)prv.getValue().get(0);
    }

    protected List<String> getValues() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue();
    }

    protected String getFullXpath() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        if (!this.predicate.getFieldLeft().startsWith("/") && !this.predicate.getFieldLeft().isEmpty()) {
            sb.append("/");
        }
        sb.append(this.predicate.getFieldLeft());
        return sb.toString();
    }

    protected String getDollarPXpath() {
        return "$p" + this.getFullXpath();
    }

    private String getXpathStart() {
        return AssetSearchQueryBuilder.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true);
    }

    protected String getXpathMinusTail() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        int stopIndex = this.predicate.getFieldLeft().lastIndexOf("/");
        sb.append(this.predicate.getFieldLeft().substring(0, stopIndex));
        if (stopIndex == 0 && this.predicate.fieldLeftIsWildCard()) {
            sb.append("/*");
        }
        return sb.toString();
    }

    protected String getXpathTail() {
        int startIndex = this.predicate.getFieldLeft().lastIndexOf("/") + 1;
        return this.predicate.getFieldLeft().substring(startIndex);
    }

    protected String isEmpty() {
        StringBuffer condition = new StringBuffer();
        condition.append("not(");
        condition.append(XML_EXISTS_START);
        condition.append(this.getFullXpath());
        condition.append(XML_EXISTS_END);
        condition.append(")");
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" AND  not(");
            condition.append(XML_EXISTS_START);
            condition.append(this.getXpathStart());
            condition.append(UNPARSABLE_PATH);
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
            condition.append("))");
        }
        return condition.toString();
    }

    protected String isNotEmpty() {
        StringBuffer condition = new StringBuffer();
        condition.append(XML_EXISTS_START);
        condition.append(this.getFullXpath());
        condition.append(XML_EXISTS_END);
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" OR ");
            condition.append(XML_EXISTS_START);
            condition.append(this.getXpathStart());
            condition.append(UNPARSABLE_PATH);
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
            condition.append(")");
        }
        return condition.toString();
    }

    protected String containsUnparsable() {
        StringBuffer condition = new StringBuffer();
        condition.append(XML_EXISTS_START);
        condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true));
        condition.append(UNPARSABLE_PATH);
        if (!this.predicate.getFieldLeft().isEmpty()) {
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
        } else {
            condition.append(XML_EXISTS_END);
            try {
                List<String> assetPaths = ssh.getChildAssetTypes(this.predicate.getFieldLeftSectionType());
                for (String assetPath : assetPaths) {
                    condition.append(" or ");
                    condition.append(XML_EXISTS_START);
                    condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(assetPath, true));
                    condition.append(UNPARSABLE_PATH);
                    condition.append(XML_EXISTS_END);
                }
                if (assetPaths.size() > 0) {
                    condition.insert(0, "(");
                    condition.append(")");
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return condition.toString();
    }

    protected String notContainsUnparsable() {
        StringBuffer condition = new StringBuffer();
        condition.append("not(");
        condition.append(XML_EXISTS_START);
        condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true));
        condition.append(UNPARSABLE_PATH);
        if (!this.predicate.getFieldLeft().isEmpty()) {
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(XML_EXISTS_END);
            condition.append(")");
        } else {
            condition.append(XML_EXISTS_END);
            condition.append(")");
            try {
                List<String> assetPaths = ssh.getChildAssetTypes(this.predicate.getFieldLeftSectionType());
                for (String assetPath : assetPaths) {
                    condition.append(" and not(");
                    condition.append(XML_EXISTS_START);
                    condition.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(assetPath, true));
                    condition.append(UNPARSABLE_PATH);
                    condition.append(XML_EXISTS_END);
                    condition.append(")");
                }
                if (assetPaths.size() > 0) {
                    condition.insert(0, "(");
                    condition.append(")");
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return condition.toString();
    }

    protected String contains() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String endsWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String equal() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String greaterThan() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String greaterThanEqual() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String greaterThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String in() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String lessThan() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String lessThanEqual() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String lessThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notContains() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notEqual() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String startsWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notIn() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notLessThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notGreaterThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String between() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String doesNotEndWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String doesNotStartWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    private static ConditionBuilder getConditionBuilder(Predicate predicate) {
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(predicate.getFieldLeft());
        if (dataType == null) {
            return new ConditionBuilder(predicate);
        }
        if (dataType.equals("integer") || dataType.equals("float")) {
            return new NumberConditionBuilder(predicate);
        }
        if (dataType.equals("string")) {
            return new StringConditionBuilder(predicate);
        }
        if (dataType.equals("time")) {
            return new TimeConditionBuilder(predicate);
        }
        if (dataType.equals("date")) {
            return new DateConditionBuilder(predicate);
        }
        if (dataType.equals("boolean")) {
            return new BooleanConditionBuilder(predicate);
        }
        return new ConditionBuilder(predicate);
    }

    private String getCondition() {
        switch (this.predicate.getSearchComplientOperator()) {
            case EQUAL: {
                return this.equal();
            }
            case NOTEQUAL: {
                return this.notEqual();
            }
            case LESSTHAN: {
                return this.lessThan();
            }
            case GREATERTHAN: {
                return this.greaterThan();
            }
            case LESSTHANEQUAL: {
                return this.lessThanEqual();
            }
            case GREATERTHANEQUAL: {
                return this.greaterThanEqual();
            }
            case ISNULL: {
                return this.isEmpty();
            }
            case ISNOTNULL: {
                return this.isNotEmpty();
            }
            case ISEMPTY: {
                return this.isEmpty();
            }
            case ISNOTEMPTY: {
                return this.isNotEmpty();
            }
            case CONTAINS: {
                return this.contains();
            }
            case DOESNOTCONTAIN: {
                return this.notContains();
            }
            case IN: {
                return this.in();
            }
            case NOTIN: {
                return this.notIn();
            }
            case STARTSWITH: {
                return this.startsWith();
            }
            case ENDSWITH: {
                return this.endsWith();
            }
            case DOESNOTSTARTWITH: {
                return this.doesNotStartWith();
            }
            case DOESNOTENDWITH: {
                return this.doesNotEndWith();
            }
            case GREATERTHANTODAY: {
                return this.greaterThanToday();
            }
            case LESSTHANTODAY: {
                return this.lessThanToday();
            }
            case CONTAINSUNPARSABLE: {
                return this.containsUnparsable();
            }
            case DOESNOTCONTAINUNPARSABLE: {
                return this.notContainsUnparsable();
            }
            case NOTGREATERTHANTODAY: {
                return this.notGreaterThanToday();
            }
            case NOTLESSTHANTODAY: {
                return this.notLessThanToday();
            }
            case BETWEEN: {
                return this.between();
            }
        }
        throw new RuntimeException("OMG, Encountered the unsupported operator " + this.predicate.getSearchComplientOperator());
    }

    public static String getCondition(Predicate predicate) {
        ConditionBuilder conditionBuilder = ConditionBuilder.getConditionBuilder(predicate);
        return conditionBuilder.getCondition();
    }
}

