/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.ConditionBuilder;
import java.util.List;

public class NumberConditionBuilder
extends ConditionBuilder {
    public NumberConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        return this.buildSimpleCondition("=");
    }

    @Override
    protected String notEqual() {
        String rhsValue = this.getRhsValue();
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String xpathTail = this.getXpathTail();
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        condition.append("not(");
        condition.append(xpathTail);
        condition.append(") or ");
        condition.append(xpathTail);
        condition.append("!=");
        condition.append(rhsValue);
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String greaterThan() {
        return this.buildSimpleCondition(">");
    }

    @Override
    protected String greaterThanEqual() {
        return this.buildSimpleCondition(">=");
    }

    @Override
    protected String lessThan() {
        return this.buildSimpleCondition("<");
    }

    @Override
    protected String lessThanEqual() {
        return this.buildSimpleCondition("<=");
    }

    @Override
    protected String in() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String xpathTail = this.getXpathTail();
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        for (int i = 0; i < values.size(); ++i) {
            String rhsValue = values.get(i);
            if (i > 0) {
                condition.append(" or ");
            }
            condition.append(xpathTail);
            condition.append("=");
            condition.append(rhsValue);
        }
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String notIn() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String xpathTail = this.getXpathTail();
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        for (int i = 0; i < values.size(); ++i) {
            String rhsValue = values.get(i);
            if (i > 0) {
                condition.append(" and ");
            }
            condition.append(xpathTail);
            condition.append("!=");
            condition.append(rhsValue);
        }
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String between() {
        List<String> values = this.getValues();
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String xpathTail = this.getXpathTail();
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        condition.append(xpathTail);
        condition.append(">=");
        condition.append(values.get(0));
        condition.append(" and ");
        condition.append(xpathTail);
        condition.append("<=");
        condition.append(values.get(1));
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    private String buildSimpleCondition(String operator) {
        String rhsValue = this.getRhsValue();
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String xpathTail = this.getXpathTail();
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        condition.append(xpathTail);
        condition.append(operator);
        condition.append(rhsValue);
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }
}

