/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.specimpl.ttv.schema.SpecLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SearchSchemaHelper {
    private Document spec;
    private XPath xpath;
    private static final SearchSchemaHelper instance = new SearchSchemaHelper();

    private SearchSchemaHelper() {
        try {
            SpecLoader sl = new SpecLoader();
            this.spec = sl.getSpecAsDocument();
            XPathFactory factory = XPathFactory.newInstance();
            this.xpath = factory.newXPath();
            this.xpath.setNamespaceContext(new UniversalNamespaceResolver(this.spec));
            this.xpath.setXPathFunctionResolver(new MyFunctionResolver());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SearchSchemaHelper getInstace() {
        return instance;
    }

    private String[] combineArrays(String[] assetTypes, String[] xpaths) {
        String[] result = new String[assetTypes.length + xpaths.length];
        int pos = 0;
        for (String str : assetTypes) {
            result[pos++] = str;
        }
        for (String str : xpaths) {
            result[pos++] = str;
        }
        return result;
    }

    public Collection<String> getAssetTypesWFile(String assetPath) {
        HashSet<String> assetTypes = new HashSet<String>();
        int lastAssetStart = assetPath.lastIndexOf(47) == -1 ? 0 : assetPath.lastIndexOf(47) + 1;
        String lastAssetName = assetPath.substring(lastAssetStart);
        String expression = "//xs:element[fn:upper-case(@name)='" + lastAssetName.toUpperCase() + "']/@type";
        try {
            String type = this.getXpath().evaluate(expression, this.getSpec());
            String exp = "//xs:complexType[@name='" + type + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
            NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
            for (int j = 0; j < childNodes.getLength(); ++j) {
                NamedNodeMap attributes = childNodes.item(j).getAttributes();
                String childType = attributes.getNamedItem("type").getNodeValue();
                String childName = attributes.getNamedItem("name").getNodeValue();
                this.getAssetTypesWFileRec(assetTypes, assetPath, childName, childType);
            }
            return assetTypes;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> getAssetTypesWFile() {
        HashSet<String> assetTypes = new HashSet<String>();
        String exp = "//xs:complexType[@name='ECMFSpecComplexType']/xs:sequence/xs:element";
        try {
            NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
            for (int j = 0; j < childNodes.getLength(); ++j) {
                NamedNodeMap attributes = childNodes.item(j).getAttributes();
                String childType = attributes.getNamedItem("type").getNodeValue();
                String childName = attributes.getNamedItem("name").getNodeValue();
                this.getAssetTypesWFileRec(assetTypes, "", childName, childType);
            }
            return assetTypes;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getAssetTypesWFileRec(Set<String> assetTypes, String assetPrefix, String nodeName, String nodeType) throws XPathExpressionException {
        if (nodeName.equals("File")) {
            assetTypes.add(assetPrefix);
            return true;
        }
        boolean result = false;
        String exp = "//xs:complexType[@name='" + nodeType + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
        NodeList nodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap attributes = nodes.item(i).getAttributes();
            String type = attributes.getNamedItem("type").getNodeValue();
            String name = attributes.getNamedItem("name").getNodeValue();
            if (type.equals(nodeType)) continue;
            String newPrefix = assetPrefix.isEmpty() ? "" : assetPrefix + "/";
            if (!this.getAssetTypesWFileRec(assetTypes, newPrefix = newPrefix + nodeName.toUpperCase(), name, type)) continue;
            result = true;
        }
        if (result && !assetPrefix.isEmpty()) {
            assetTypes.add(assetPrefix);
        }
        return result;
    }

    public List<String> getChildAssetTypes(String assetPath) throws XPathExpressionException {
        assetPath = this.getCorrectedAssetPath(assetPath, false);
        ArrayList<String> assetTypes = new ArrayList<String>();
        int lastAssetStart = assetPath.lastIndexOf(47) == -1 ? 0 : assetPath.lastIndexOf(47) + 1;
        String lastAssetName = assetPath.substring(lastAssetStart);
        String expression = "//xs:element[@name='" + lastAssetName + "']";
        Object result = this.getXpath().evaluate(expression, this.getSpec(), XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String type = nodes.item(i).getAttributes().getNamedItem("type").getNodeValue();
            String exp = "//xs:complexType[@name='" + type + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
            NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
            for (int j = 0; j < childNodes.getLength(); ++j) {
                NamedNodeMap attributes = childNodes.item(j).getAttributes();
                String childType = attributes.getNamedItem("type").getNodeValue();
                String childName = attributes.getNamedItem("name").getNodeValue();
                this.getChildAssetTypesRec(assetTypes, assetPath, childName, childType);
            }
        }
        return assetTypes;
    }

    public List<String> getAssetTypesWOFile() throws XPathExpressionException {
        ArrayList<String> assetTypes = new ArrayList<String>();
        String exp = "//xs:complexType[@name='ECMFSpecComplexType']/xs:sequence/xs:element";
        NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
        for (int j = 0; j < childNodes.getLength(); ++j) {
            NamedNodeMap attributes = childNodes.item(j).getAttributes();
            String childType = attributes.getNamedItem("type").getNodeValue();
            String childName = attributes.getNamedItem("name").getNodeValue();
            this.getChildAssetTypesRec(assetTypes, "", childName, childType);
        }
        return assetTypes;
    }

    private void getChildAssetTypesRec(List<String> assetTypes, String assetPrefix, String nodeName, String nodeType) throws XPathExpressionException {
        if (nodeName.equals("File")) {
            return;
        }
        String exp = "//xs:complexType[@name='" + nodeType + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
        NodeList nodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
        if (nodes.getLength() > 0) {
            assetTypes.add(assetPrefix + "/" + nodeName);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap attributes = nodes.item(i).getAttributes();
            String type = attributes.getNamedItem("type").getNodeValue();
            String name = attributes.getNamedItem("name").getNodeValue();
            if (type.equals(nodeType)) continue;
            this.getChildAssetTypesRec(assetTypes, assetPrefix + "/" + nodeName, name, type);
        }
    }

    public String getCorrectedAssetPath(String assetPath, boolean includeFirstIndex) {
        StringBuffer sb = new StringBuffer();
        String[] assetTypes = assetPath.split("/");
        String expression = "//xs:element[fn:upper-case(@name)='" + assetTypes[0].toUpperCase() + "']";
        try {
            Object result = this.getXpath().evaluate(expression, this.getSpec(), XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            for (int i = 0; i < nodes.getLength(); ++i) {
                String type = nodes.item(i).getAttributes().getNamedItem("type").getNodeValue();
                String name = nodes.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String exp = "//xs:complexType[@name='" + type + "' and xs:sequence/xs:element/@name='Fields']";
                NodeList assetNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
                if (assetNodes.getLength() == 0) continue;
                if (assetNodes.getLength() > 1) {
                    throw new RuntimeException("WTF");
                }
                sb.append(name);
                if (assetTypes.length <= 1) continue;
                this.buildAssetType(assetTypes, 1, type, sb, includeFirstIndex);
            }
            return sb.toString();
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public String prepareSelectXpath(String assetType, String fieldXpath) {
        try {
            StringBuffer sb = new StringBuffer("/ECMFSpec/");
            String[] fieldPaths = fieldXpath.startsWith("/") ? fieldXpath.substring(1).split("/") : fieldXpath.split("/");
            String[] assetTypes = assetType.split("/");
            String expression = "//xs:element[fn:upper-case(@name)='" + assetTypes[0].toUpperCase() + "']";
            Object result = this.getXpath().evaluate(expression, this.getSpec(), XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            for (int i = 0; i < nodes.getLength(); ++i) {
                String type = nodes.item(i).getAttributes().getNamedItem("type").getNodeValue();
                String name = nodes.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String exp = "//xs:complexType[@name='" + type + "' and xs:sequence/xs:element/@name='Fields']";
                NodeList assetNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
                if (assetNodes.getLength() == 0) continue;
                if (assetNodes.getLength() > 1) {
                    throw new RuntimeException("WTF");
                }
                String[] fullPath = this.combineArrays(assetTypes, fieldPaths);
                sb.append(name);
                if (fullPath.length <= 1) continue;
                this.buildAssetType(fullPath, 1, type, sb, true);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private NodeList getElementsofTypeExp(String type) throws XPathExpressionException {
        String exp = "//xs:complexType[@name='" + type + "']/*";
        return (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
    }

    private boolean buildAssetType(String[] path, int pos, String currType, StringBuffer sb, boolean includeIndex) throws XPathExpressionException {
        if (path[pos].startsWith("@")) {
            sb.append("/");
            sb.append(path[pos]);
            return true;
        }
        NodeList immediateChilren = this.getElementsofTypeExp(currType);
        NodeList childItems = null;
        for (int i = 0; i < immediateChilren.getLength(); ++i) {
            Node node = immediateChilren.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("xs:sequence") || nodeName.equals("xs:all") || nodeName.equals("xs:choice")) {
                childItems = immediateChilren.item(i).getChildNodes();
                break;
            }
            if (!nodeName.equals("xs:complexContent")) continue;
            String baseType = this.xpath.evaluate("xs:extension/@base", node);
            if (this.buildAssetType(path, pos, baseType, sb, includeIndex)) {
                return true;
            }
            NodeList childNodes = (NodeList)this.xpath.evaluate("xs:extension/*/xs:element", node, XPathConstants.NODESET);
            if (childNodes.getLength() <= 0) continue;
            childItems = childNodes;
        }
        if (childItems == null) {
            throw new RuntimeException("Error evaluating xpath " + path.toString());
        }
        return this.handleNodeList(childItems, path, pos, sb, includeIndex);
    }

    private boolean handleNodeList(NodeList childItems, String[] path, int pos, StringBuffer sb, boolean includeIndex) throws XPathExpressionException {
        for (int j = 0; j < childItems.getLength(); ++j) {
            String childAssetName;
            Node childNode = childItems.item(j);
            if (!childNode.getNodeName().equals("xs:element") || !(childAssetName = childItems.item(j).getAttributes().getNamedItem("name").getNodeValue()).equalsIgnoreCase(path[pos])) continue;
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(childAssetName);
            Node maxOccursNode = childItems.item(j).getAttributes().getNamedItem("maxOccurs");
            if (includeIndex && maxOccursNode != null && !maxOccursNode.getNodeValue().equals("1")) {
                sb.append("[1]");
            }
            if (++pos < path.length) {
                String childType = childItems.item(j).getAttributes().getNamedItem("type").getNodeValue();
                this.buildAssetType(path, pos, childType, sb, includeIndex);
            }
            return true;
        }
        return false;
    }

    private XPath getXpath() {
        return this.xpath;
    }

    private Document getSpec() {
        return this.spec;
    }

    public class MyFunctionResolver
    implements XPathFunctionResolver {
        @Override
        public XPathFunction resolveFunction(QName fname, int arity) {
            if (fname == null) {
                throw new NullPointerException("The function name cannot be null.");
            }
            if (fname.equals(new QName("http://www.w3.org/2005/xpath-functions", "upper-case", "fn"))) {
                return new XPathFunction(){

                    public Object evaluate(List args) {
                        NodeList nodes = (NodeList)args.get(0);
                        return nodes.item(0).getNodeValue().toUpperCase();
                    }
                };
            }
            return null;
        }
    }

    private class UniversalNamespaceResolver
    implements NamespaceContext {
        private Document sourceDocument;

        public UniversalNamespaceResolver(Document document) {
            this.sourceDocument = document;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return this.sourceDocument.lookupNamespaceURI(null);
            }
            if (prefix.equals("fn")) {
                return "http://www.w3.org/2005/xpath-functions";
            }
            return this.sourceDocument.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceDocument.lookupPrefix(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

