/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.ConditionBuilder;
import java.util.List;

public class StringConditionBuilder
extends ConditionBuilder {
    public StringConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        return this.simpleConditionHelper(" = ");
    }

    @Override
    protected String notEqual() {
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        condition.append("not(");
        condition.append(this.getXpathTail());
        condition.append(") or ");
        condition.append(this.getICCXpathTail());
        condition.append(" != ");
        condition.append(this.getICCRhsValue());
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    protected String simpleConditionHelper(String operator) {
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        condition.append(this.getICCXpathTail());
        condition.append(operator);
        condition.append(this.getICCRhsValue());
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    private String getICCXpathTail() {
        String xpathTail = this.getXpathTail();
        if (this.predicate.getIgnoreCase()) {
            return "fn:upper-case(" + xpathTail + ")";
        }
        return xpathTail;
    }

    private String getICCRhsValue() {
        StringBuffer sb = new StringBuffer("\"");
        if (this.predicate.getIgnoreCase()) {
            sb.append(this.getRhsValue().toUpperCase());
        } else {
            sb.append(this.getRhsValue());
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    protected String in() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String xpathTail = this.getICCXpathTail();
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                condition.append(" or ");
            }
            condition.append(xpathTail);
            condition.append("=");
            condition.append(this.getICCRhsValue());
        }
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String notIn() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        String xpathTail = this.getICCXpathTail();
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                condition.append(" and ");
            }
            condition.append(xpathTail);
            condition.append("!=");
            condition.append(this.getICCRhsValue());
        }
        condition.append("]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String contains() {
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(this.getFullXpath());
        condition.append("[");
        condition.append("ora:contains(text()");
        condition.append(", \"");
        condition.append(this.getRhsValue());
        condition.append("\") > 0]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String notContains() {
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(this.getFullXpath());
        condition.append("[");
        condition.append("ora:contains(text()");
        condition.append(", \"");
        condition.append(this.getRhsValue());
        condition.append("\") = 0]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String startsWith() {
        return this.getFuncCondition("fn:starts-with");
    }

    private String getFuncCondition(String function) {
        StringBuffer condition = new StringBuffer("xmlexists('$p");
        condition.append(this.getXpathMinusTail());
        condition.append("[");
        condition.append(function);
        condition.append("(");
        condition.append(this.getICCXpathTail());
        condition.append(", ");
        condition.append(this.getICCRhsValue());
        condition.append(")]");
        condition.append("' passing sys_nc_rowinfo$ as \"p\")");
        return condition.toString();
    }

    @Override
    protected String doesNotStartWith() {
        return "not(" + this.startsWith() + ")";
    }

    @Override
    protected String endsWith() {
        return this.getFuncCondition("fn:starts-with");
    }

    @Override
    protected String doesNotEndWith() {
        return "not(" + this.endsWith() + ")";
    }
}

